/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.ImportedModule;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.SimulatedSyncErrors;
import com.android.tools.idea.gradle.project.sync.common.CommandLineArgs;
import com.android.tools.idea.gradle.project.sync.common.VariantSelector;
import com.android.tools.idea.gradle.project.sync.idea.GradleModelVersionCheck;
import com.android.tools.idea.gradle.project.sync.idea.ProjectFinder;
import com.android.tools.idea.gradle.project.sync.idea.ProjectImportErrorHandler;
import com.android.tools.idea.gradle.project.sync.idea.data.model.ProjectCleanupModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleScript;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class AndroidGradleProjectResolver
extends AbstractProjectResolverExtension {
    private static final Key<Boolean> IS_ANDROID_PROJECT_KEY = Key.create((String)"IS_ANDROID_PROJECT_KEY");
    @NotNull
    private final CommandLineArgs myCommandLineArgs;
    @NotNull
    private final ProjectImportErrorHandler myErrorHandler;
    @NotNull
    private final ProjectFinder myProjectFinder;
    @NotNull
    private final VariantSelector myVariantSelector;

    public AndroidGradleProjectResolver() {
        this(new CommandLineArgs(false), new ProjectImportErrorHandler(), new ProjectFinder(), new VariantSelector());
    }

    @VisibleForTesting
    AndroidGradleProjectResolver(@NotNull CommandLineArgs commandLineArgs, @NotNull ProjectImportErrorHandler errorHandler, @NotNull ProjectFinder projectFinder, @NotNull VariantSelector variantSelector) {
        if (commandLineArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineArgs", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "<init>"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "<init>"));
        }
        if (projectFinder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectFinder", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "<init>"));
        }
        if (variantSelector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantSelector", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "<init>"));
        }
        this.myCommandLineArgs = commandLineArgs;
        this.myErrorHandler = errorHandler;
        this.myProjectFinder = projectFinder;
        this.myVariantSelector = variantSelector;
    }

    @NotNull
    public DataNode<ModuleData> createModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "createModule"));
        }
        if (projectDataNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDataNode", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "createModule"));
        }
        AndroidProject androidProject = (AndroidProject)this.resolverCtx.getExtraProject(gradleModule, AndroidProject.class);
        if (androidProject != null && !GradleModelVersionCheck.isSupportedVersion(androidProject)) {
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
            event.setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE).setGradleSyncFailure(AndroidStudioEvent.GradleSyncFailure.UNSUPPORTED_ANDROID_MODEL_VERSION).setGradleVersion(androidProject.getModelVersion());
            UsageTracker.getInstance().log(event);
            String msg = AndroidGradleProjectResolver.getUnsupportedModelVersionErrorMsg(GradleModelVersionCheck.getModelVersion(androidProject));
            throw new IllegalStateException(msg);
        }
        if (this.isAndroidGradleProject()) {
            DataNode<ModuleData> dataNode = this.doCreateModule(gradleModule, projectDataNode);
            if (dataNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "createModule"));
            }
            return dataNode;
        }
        DataNode dataNode = this.nextResolver.createModule(gradleModule, projectDataNode);
        if (dataNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "createModule"));
        }
        return dataNode;
    }

    @NotNull
    private DataNode<ModuleData> doCreateModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "doCreateModule"));
        }
        if (projectDataNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDataNode", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "doCreateModule"));
        }
        String moduleName = gradleModule.getName();
        if (moduleName == null) {
            throw new IllegalStateException("Module with undefined name detected: " + gradleModule);
        }
        String projectPath = ((ProjectData)projectDataNode.getData()).getLinkedExternalProjectPath();
        String moduleConfigPath = GradleProjectResolverUtil.getModuleConfigPath((ProjectResolverContext)this.resolverCtx, (IdeaModule)gradleModule, (String)projectPath);
        String gradlePath = gradleModule.getGradleProject().getPath();
        String moduleId = StringUtil.isEmpty((String)gradlePath) || ":".equals(gradlePath) ? moduleName : gradlePath;
        ProjectSystemId owner = GradleConstants.SYSTEM_ID;
        String typeId = StdModuleTypes.JAVA.getId();
        ModuleData moduleData = new ModuleData(moduleId, owner, typeId, moduleName, moduleConfigPath, moduleConfigPath);
        ExternalProject externalProject = (ExternalProject)this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (externalProject != null) {
            moduleData.setDescription(externalProject.getDescription());
        }
        DataNode dataNode = projectDataNode.createChild(ProjectKeys.MODULE, (Object)moduleData);
        if (dataNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "doCreateModule"));
        }
        return dataNode;
    }

    public void populateModuleContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        File gradleSettingsFile;
        NativeAndroidProject nativeAndroidProject;
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "populateModuleContentRoots"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "populateModuleContentRoots"));
        }
        ImportedModule importedModule = new ImportedModule(gradleModule);
        ideModule.createChild(AndroidProjectKeys.IMPORTED_MODULE, (Object)importedModule);
        GradleProject gradleProject = gradleModule.getGradleProject();
        GradleScript buildScript = null;
        try {
            buildScript = gradleProject.getBuildScript();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (buildScript == null || !this.isAndroidGradleProject()) {
            this.nextResolver.populateModuleContentRoots(gradleModule, ideModule);
            return;
        }
        File moduleRootDirPath = new File(FileUtil.toSystemDependentName((String)((ModuleData)ideModule.getData()).getLinkedExternalProjectPath()));
        AndroidProject androidProject = (AndroidProject)this.resolverCtx.getExtraProject(gradleModule, AndroidProject.class);
        boolean androidProjectWithoutVariants = false;
        String moduleName = gradleModule.getName();
        if (androidProject != null) {
            Variant selectedVariant = this.myVariantSelector.findVariantToSelect(androidProject);
            if (selectedVariant == null) {
                androidProjectWithoutVariants = true;
            } else {
                String variantName = selectedVariant.getName();
                AndroidModuleModel model = new AndroidModuleModel(moduleName, moduleRootDirPath, androidProject, variantName);
                ideModule.createChild(AndroidProjectKeys.ANDROID_MODEL, (Object)model);
            }
        }
        if ((nativeAndroidProject = (NativeAndroidProject)this.resolverCtx.getExtraProject(gradleModule, NativeAndroidProject.class)) != null) {
            NdkModuleModel ndkModuleModel = new NdkModuleModel(moduleName, moduleRootDirPath, nativeAndroidProject);
            ideModule.createChild(AndroidProjectKeys.NDK_MODEL, (Object)ndkModuleModel);
        }
        if ((gradleSettingsFile = new File(moduleRootDirPath, "settings.gradle")).isFile() && androidProject == null && nativeAndroidProject == null) {
            this.createJavaProject(gradleModule, ideModule, false);
            return;
        }
        BuildScriptClasspathModel buildScriptModel = (BuildScriptClasspathModel)this.resolverCtx.getExtraProject(BuildScriptClasspathModel.class);
        String gradleVersion = buildScriptModel != null ? buildScriptModel.getGradleVersion() : null;
        File buildFilePath = buildScript.getSourceFile();
        GradleModuleModel gradleModuleModel = new GradleModuleModel(moduleName, gradleProject, buildFilePath, gradleVersion);
        ideModule.createChild(AndroidProjectKeys.GRADLE_MODULE_MODEL, (Object)gradleModuleModel);
        if (nativeAndroidProject == null && (androidProject == null || androidProjectWithoutVariants)) {
            this.createJavaProject(gradleModule, ideModule, androidProjectWithoutVariants);
        }
    }

    private void createJavaProject(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, boolean androidProjectWithoutVariants) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "createJavaProject"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "createJavaProject"));
        }
        ModuleExtendedModel model = (ModuleExtendedModel)this.resolverCtx.getExtraProject(gradleModule, ModuleExtendedModel.class);
        JavaModuleModel javaModuleModel = new JavaModuleModel(gradleModule, model, androidProjectWithoutVariants);
        ideModule.createChild(AndroidProjectKeys.JAVA_MODULE_MODEL, (Object)javaModuleModel);
    }

    public void populateModuleCompileOutputSettings(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "populateModuleCompileOutputSettings"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "populateModuleCompileOutputSettings"));
        }
        if (!this.isAndroidGradleProject()) {
            this.nextResolver.populateModuleCompileOutputSettings(gradleModule, ideModule);
        }
    }

    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "populateModuleDependencies"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "populateModuleDependencies"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "populateModuleDependencies"));
        }
        if (!this.isAndroidGradleProject()) {
            this.nextResolver.populateModuleDependencies(gradleModule, ideModule, ideProject);
        }
    }

    private boolean isAndroidGradleProject() {
        Boolean isAndroidGradleProject = (Boolean)this.resolverCtx.getUserData(IS_ANDROID_PROJECT_KEY);
        if (isAndroidGradleProject != null) {
            return isAndroidGradleProject;
        }
        isAndroidGradleProject = this.resolverCtx.hasModulesWithModel(AndroidProject.class) || this.resolverCtx.hasModulesWithModel(NativeAndroidProject.class);
        return (Boolean)this.resolverCtx.putUserDataIfAbsent(IS_ANDROID_PROJECT_KEY, (Object)isAndroidGradleProject);
    }

    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> projectDataNode) {
        if (gradleProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleProject", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "populateProjectExtraModels"));
        }
        if (projectDataNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDataNode", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "populateProjectExtraModels"));
        }
        projectDataNode.createChild(AndroidProjectKeys.PROJECT_CLEANUP_MODEL, (Object)ProjectCleanupModel.getInstance());
        super.populateProjectExtraModels(gradleProject, projectDataNode);
    }

    @NotNull
    public Set<Class> getExtraProjectModelClasses() {
        HashSet<Class> modelClasses = new HashSet<Class>();
        modelClasses.add(AndroidProject.class);
        modelClasses.add(NativeAndroidProject.class);
        HashSet<Class> hashSet = modelClasses;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "getExtraProjectModelClasses"));
        }
        return hashSet;
    }

    public void preImportCheck() {
        SimulatedSyncErrors.simulateRegisteredSyncError();
    }

    @NotNull
    public List<Pair<String, String>> getExtraJvmArgs() {
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID)) {
            File androidHomePath;
            LocalProperties localProperties;
            ArrayList<Pair<String, String>> args = new ArrayList<Pair<String, String>>();
            if (!IdeInfo.getInstance().isAndroidStudio() && (localProperties = this.getLocalProperties()).getAndroidSdkPath() == null && (androidHomePath = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
                args.add((Pair<String, String>)KeyValue.create((Object)"android.home", (Object)androidHomePath.getPath()));
            }
            ArrayList<Pair<String, String>> arrayList = args;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "getExtraJvmArgs"));
            }
            return arrayList;
        }
        List<Pair<String, String>> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "getExtraJvmArgs"));
        }
        return list;
    }

    @NotNull
    private LocalProperties getLocalProperties() {
        LocalProperties localProperties;
        block2: {
            File projectDir = new File(FileUtil.toSystemDependentName((String)this.resolverCtx.getProjectPath()));
            try {
                localProperties = new LocalProperties(projectDir);
                if (localProperties != null) break block2;
            }
            catch (IOException e) {
                String msg = String.format("Unable to read local.properties file in project '%1$s'", projectDir.getPath());
                throw new ExternalSystemException(msg, (Throwable)e, new String[0]);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "getLocalProperties"));
        }
        return localProperties;
    }

    @NotNull
    public List<String> getExtraCommandLineArgs() {
        Project project = this.myProjectFinder.findProject(this.resolverCtx);
        List<String> list = this.myCommandLineArgs.get(project);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "getExtraCommandLineArgs"));
        }
        return list;
    }

    @NotNull
    public ExternalSystemException getUserFriendlyError(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        Throwable rootCause;
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "getUserFriendlyError"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "getUserFriendlyError"));
        }
        String msg = error.getMessage();
        if (msg != null && !msg.contains("The project is using an unsupported version of the Android Gradle plug-in") && (rootCause = ExceptionUtil.getRootCause((Throwable)error)) instanceof ClassNotFoundException && AndroidGradleProjectResolver.isUsingUnsupportedGradleVersion(msg = rootCause.getMessage())) {
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
            event.setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE).setGradleSyncFailure(AndroidStudioEvent.GradleSyncFailure.UNSUPPORTED_GRADLE_VERSION);
            UsageTracker.getInstance().log(event);
            ExternalSystemException externalSystemException = new ExternalSystemException("The project is using an unsupported version of Gradle.");
            if (externalSystemException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "getUserFriendlyError"));
            }
            return externalSystemException;
        }
        ExternalSystemException userFriendlyError = this.myErrorHandler.getUserFriendlyError(error, projectPath, buildFilePath);
        assert (userFriendlyError != null);
        ExternalSystemException externalSystemException = userFriendlyError;
        if (externalSystemException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "getUserFriendlyError"));
        }
        return externalSystemException;
    }

    private static boolean isUsingUnsupportedGradleVersion(@Nullable String errorMessage) {
        return "org.gradle.api.artifacts.result.ResolvedComponentResult".equals(errorMessage) || "org.gradle.api.artifacts.result.ResolvedModuleVersionResult".equals(errorMessage);
    }

    @NotNull
    private static String getUnsupportedModelVersionErrorMsg(@Nullable GradleVersion modelVersion) {
        StringBuilder builder = new StringBuilder();
        builder.append("The project is using an unsupported version of the Android Gradle plug-in");
        String recommendedVersion = String.format("The recommended version is %1$s.", "2.3.0");
        if (modelVersion != null) {
            builder.append(String.format(" (%1$s).", modelVersion.toString())).append(" ").append(recommendedVersion);
            if (modelVersion.getMajor() == 0 && modelVersion.getMinor() <= 8) {
                builder.append("\n\nStarting with version 0.9.0 incompatible changes were introduced in the build language.\n").append("Please read the migration guide").append(" to learn how to update your project.");
            }
        } else {
            builder.append(". ").append(recommendedVersion);
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "getUnsupportedModelVersionErrorMsg"));
        }
        return string;
    }

    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver", "enhanceRemoteProcessing"));
        }
        PathsList classPath = parameters.getClassPath();
        classPath.add(PathUtil.getJarPathForClass(((Object)((Object)this)).getClass()));
        classPath.add(PathUtil.getJarPathForClass(Revision.class));
        classPath.add(PathUtil.getJarPathForClass(AndroidGradleSettings.class));
        classPath.add(PathUtil.getJarPathForClass(AndroidProject.class));
    }
}

