/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;

class ProjectFinder {
    ProjectFinder() {
    }

    @Nullable
    Project findProject(@NotNull ProjectResolverContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/project/sync/idea/ProjectFinder", "findProject"));
        }
        String projectPath = context.getProjectPath();
        if (StringUtil.isNotEmpty((String)projectPath)) {
            Project[] projects;
            File projectDirPath = new File(FileUtil.toSystemDependentName((String)projectPath));
            for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
                File currentPath;
                String basePath = project.getBasePath();
                if (basePath == null || !FileUtil.filesEqual((File)projectDirPath, (File)(currentPath = new File(basePath)))) continue;
                return project;
            }
        }
        return null;
    }
}

