/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.data.service.ModuleModelDataService;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.GradleModuleSetup;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GradleModuleModelDataService
extends ModuleModelDataService<GradleModuleModel> {
    @NotNull
    private final GradleModuleSetup myModuleSetup;

    public GradleModuleModelDataService() {
        this(new GradleModuleSetup());
    }

    GradleModuleModelDataService(@NotNull GradleModuleSetup moduleSetup) {
        if (moduleSetup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleSetup", "com/android/tools/idea/gradle/project/sync/idea/data/service/GradleModuleModelDataService", "<init>"));
        }
        this.myModuleSetup = moduleSetup;
    }

    @NotNull
    public Key<GradleModuleModel> getTargetDataKey() {
        Key<GradleModuleModel> key = AndroidProjectKeys.GRADLE_MODULE_MODEL;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/data/service/GradleModuleModelDataService", "getTargetDataKey"));
        }
        return key;
    }

    @Override
    protected void importData(@NotNull Collection<DataNode<GradleModuleModel>> toImport, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<String, GradleModuleModel> modelsByName) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/android/tools/idea/gradle/project/sync/idea/data/service/GradleModuleModelDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/idea/data/service/GradleModuleModelDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/idea/data/service/GradleModuleModelDataService", "importData"));
        }
        if (modelsByName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsByName", "com/android/tools/idea/gradle/project/sync/idea/data/service/GradleModuleModelDataService", "importData"));
        }
        for (Module module : modelsProvider.getModules()) {
            GradleModuleModel gradleModuleModel = modelsByName.get(module.getName());
            if (gradleModuleModel == null) {
                Facets.removeAllFacets(modelsProvider.getModifiableFacetModel(module), GradleFacet.getFacetTypeId());
                continue;
            }
            this.myModuleSetup.setUpModule(module, modelsProvider, gradleModuleModel);
        }
    }
}

