/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.data.service.ModuleModelDataService;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.NdkModuleSetup;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NdkModuleModelDataService
extends ModuleModelDataService<NdkModuleModel> {
    @NotNull
    private final NdkModuleSetup myModuleSetup;

    public NdkModuleModelDataService() {
        this(new NdkModuleSetup());
    }

    @VisibleForTesting
    NdkModuleModelDataService(@NotNull NdkModuleSetup moduleSetup) {
        if (moduleSetup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleSetup", "com/android/tools/idea/gradle/project/sync/idea/data/service/NdkModuleModelDataService", "<init>"));
        }
        this.myModuleSetup = moduleSetup;
    }

    @NotNull
    public Key<NdkModuleModel> getTargetDataKey() {
        Key<NdkModuleModel> key = AndroidProjectKeys.NDK_MODEL;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/data/service/NdkModuleModelDataService", "getTargetDataKey"));
        }
        return key;
    }

    @Override
    protected void importData(@NotNull Collection<DataNode<NdkModuleModel>> toImport, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<String, NdkModuleModel> modelsByName) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/android/tools/idea/gradle/project/sync/idea/data/service/NdkModuleModelDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/idea/data/service/NdkModuleModelDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/idea/data/service/NdkModuleModelDataService", "importData"));
        }
        if (modelsByName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsByName", "com/android/tools/idea/gradle/project/sync/idea/data/service/NdkModuleModelDataService", "importData"));
        }
        for (Module module : modelsProvider.getModules()) {
            NdkModuleModel ndkModuleModel = modelsByName.get(module.getName());
            this.myModuleSetup.setUpModule(module, modelsProvider, ndkModuleModel, null, null);
        }
    }

    @Override
    protected void onModelsNotFound(@NotNull IdeModifiableModelsProvider modelsProvider) {
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/idea/data/service/NdkModuleModelDataService", "onModelsNotFound"));
        }
        for (Module module : modelsProvider.getModules()) {
            ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel(module);
            Facets.removeAllFacets(facetModel, NdkFacet.getFacetTypeId());
        }
    }
}

