/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.common;

import com.android.tools.idea.gradle.project.subset.ProjectSubset;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencySetupErrors {
    @NotNull
    private final Project myProject;
    @NotNull
    private final SyncMessages mySyncMessages;
    @NotNull
    private final Map<String, MissingModule> myMissingModules;
    @NotNull
    private final Map<String, MissingModule> myMissingModulesWithBackupLibraries;
    @NotNull
    private final Set<String> myDependentsOnModulesWithoutName;
    @NotNull
    private final Set<String> myDependentsOnLibrariesWithoutBinaryPath;
    @NotNull
    private final Set<InvalidModuleDependency> myInvalidModuleDependencies;

    @NotNull
    public static DependencySetupErrors getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "getInstance"));
        }
        DependencySetupErrors dependencySetupErrors = (DependencySetupErrors)ServiceManager.getService((Project)project, DependencySetupErrors.class);
        if (dependencySetupErrors == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "getInstance"));
        }
        return dependencySetupErrors;
    }

    public DependencySetupErrors(@NotNull Project project, @NotNull SyncMessages syncMessages) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "<init>"));
        }
        if (syncMessages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncMessages", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "<init>"));
        }
        this.myMissingModules = new HashMap<String, MissingModule>();
        this.myMissingModulesWithBackupLibraries = new HashMap<String, MissingModule>();
        this.myDependentsOnModulesWithoutName = new HashSet<String>();
        this.myDependentsOnLibrariesWithoutBinaryPath = new HashSet<String>();
        this.myInvalidModuleDependencies = new HashSet<InvalidModuleDependency>();
        this.myProject = project;
        this.mySyncMessages = syncMessages;
    }

    public void reportErrors() {
        String msg;
        this.reportModulesNotFoundIssues(this.getMissingModules());
        for (String dependent : this.getMissingNames()) {
            msg = String.format("Module '%1$s' depends on modules that do not have a name.", dependent);
            this.mySyncMessages.report(new SyncMessage("Missing Dependencies", MessageType.ERROR, msg));
        }
        for (String dependent : this.getDependentsOnLibrariesWithoutBinaryPath()) {
            msg = String.format("Module '%1$s' depends on libraries that do not have a 'binary' path.", dependent);
            this.mySyncMessages.report(new SyncMessage("Missing Dependencies", MessageType.ERROR, msg));
        }
        for (InvalidModuleDependency dependency : this.myInvalidModuleDependencies) {
            msg = String.format("Ignoring dependency of module '%1$s' on module '%2$s'. %3$s", dependency.dependent, dependency.dependency.getName(), dependency.causeDescription);
            VirtualFile buildFile = GradleUtil.getGradleBuildFile(dependency.dependency);
            assert (buildFile != null);
            OpenFileDescriptor navigatable = new OpenFileDescriptor(dependency.dependency.getProject(), buildFile, 0);
            this.mySyncMessages.report(new SyncMessage("Missing Dependencies", MessageType.WARNING, (Navigatable)navigatable, msg));
        }
        this.reportModulesNotFoundIssues(this.getMissingModulesWithBackupLibraries());
        this.clear();
    }

    @VisibleForTesting
    @NotNull
    List<MissingModule> getMissingModules() {
        List<MissingModule> list = DependencySetupErrors.getMissingModules(this.myMissingModules);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "getMissingModules"));
        }
        return list;
    }

    @VisibleForTesting
    @NotNull
    List<MissingModule> getMissingModulesWithBackupLibraries() {
        List<MissingModule> list = DependencySetupErrors.getMissingModules(this.myMissingModulesWithBackupLibraries);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "getMissingModulesWithBackupLibraries"));
        }
        return list;
    }

    @NotNull
    private static List<MissingModule> getMissingModules(@NotNull Map<String, MissingModule> missingModulesByName) {
        if (missingModulesByName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "missingModulesByName", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "getMissingModules"));
        }
        if (missingModulesByName.isEmpty()) {
            List<MissingModule> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "getMissingModules"));
            }
            return list;
        }
        ArrayList<MissingModule> missingModules = new ArrayList<MissingModule>();
        ArrayList<String> names = new ArrayList<String>(missingModulesByName.keySet());
        if (names.size() > 1) {
            Collections.sort(names);
        }
        for (String name : names) {
            MissingModule missingModule = missingModulesByName.get(name);
            missingModule.sortDependentNames();
            missingModules.add(missingModule);
        }
        ArrayList<MissingModule> arrayList = missingModules;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "getMissingModules"));
        }
        return arrayList;
    }

    @VisibleForTesting
    @NotNull
    List<String> getMissingNames() {
        List<String> list = DependencySetupErrors.sortSet(this.myDependentsOnModulesWithoutName);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "getMissingNames"));
        }
        return list;
    }

    @VisibleForTesting
    @NotNull
    List<String> getDependentsOnLibrariesWithoutBinaryPath() {
        List<String> list = DependencySetupErrors.sortSet(this.myDependentsOnLibrariesWithoutBinaryPath);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "getDependentsOnLibrariesWithoutBinaryPath"));
        }
        return list;
    }

    @NotNull
    private static List<String> sortSet(@NotNull Set<String> set) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "sortSet"));
        }
        if (set.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "sortSet"));
            }
            return list;
        }
        ArrayList<String> sorted = new ArrayList<String>(set);
        if (sorted.size() > 1) {
            Collections.sort(sorted);
        }
        ArrayList<String> arrayList = sorted;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "sortSet"));
        }
        return arrayList;
    }

    private void reportModulesNotFoundIssues(@NotNull List<MissingModule> missingModules) {
        if (missingModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "missingModules", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "reportModulesNotFoundIssues"));
        }
        if (!missingModules.isEmpty()) {
            boolean hasSelection;
            CharSequence text;
            MessageType type = MessageType.ERROR;
            for (MissingModule missingModule : missingModules) {
                ArrayList<String> messageLines = new ArrayList<String>();
                text = new StringBuilder();
                ((StringBuilder)text).append(String.format("Unable to find module with Gradle path '%1$s' (needed by module", missingModule.dependencyPath));
                DependencySetupErrors.addDependentsToText((StringBuilder)text, missingModule.dependentNames);
                ((StringBuilder)text).append(".)");
                messageLines.add(((StringBuilder)text).toString());
                String backupLibraryName = missingModule.backupLibraryName;
                if (StringUtil.isNotEmpty((String)backupLibraryName)) {
                    type = MessageType.WARNING;
                    String msg = String.format("Linking to library '%1$s' instead.", backupLibraryName);
                    messageLines.add(msg);
                }
                this.mySyncMessages.report(new SyncMessage("Missing Dependencies", type, ArrayUtil.toStringArray(messageLines)));
            }
            ProjectSubset projectSubset = ProjectSubset.getInstance(this.myProject);
            String[] selection = projectSubset.getSelection();
            boolean bl = hasSelection = selection != null && selection.length > 0;
            if (type == MessageType.ERROR && hasSelection && projectSubset.hasCachedModules()) {
                text = "The missing modules may have been excluded from the project subset.";
                SyncMessage message = new SyncMessage("Missing Dependencies", MessageType.INFO, new String[]{text});
                message.add(new IncludeMissingModulesHyperlink(missingModules));
                this.mySyncMessages.report(message);
            }
        }
    }

    private static void addDependentsToText(@NotNull StringBuilder text, @NotNull List<String> dependents) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "addDependentsToText"));
        }
        if (dependents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependents", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "addDependentsToText"));
        }
        assert (!dependents.isEmpty());
        if (dependents.size() == 1) {
            text.append(String.format(" '%1$s'", dependents.get(0)));
            return;
        }
        text.append("s: ");
        int i = 0;
        for (String dependent : dependents) {
            if (i++ > 0) {
                text.append(", ");
            }
            text.append(String.format("'%1$s'", dependent));
        }
    }

    private void clear() {
        this.myMissingModules.clear();
        this.myMissingModulesWithBackupLibraries.clear();
        this.myDependentsOnModulesWithoutName.clear();
        this.myDependentsOnLibrariesWithoutBinaryPath.clear();
        this.myInvalidModuleDependencies.clear();
    }

    public void addMissingModule(@NotNull String dependencyName, @NotNull String dependentName, @Nullable String backupLibraryName) {
        if (dependencyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyName", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "addMissingModule"));
        }
        if (dependentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependentName", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "addMissingModule"));
        }
        Map<String, MissingModule> mapping = StringUtil.isNotEmpty((String)backupLibraryName) ? this.myMissingModulesWithBackupLibraries : this.myMissingModules;
        MissingModule missingModule = mapping.get(dependencyName);
        if (missingModule == null) {
            missingModule = new MissingModule(dependencyName, backupLibraryName);
            mapping.put(dependencyName, missingModule);
        }
        missingModule.addDependent(dependentName);
    }

    public void addMissingName(@NotNull String dependentName) {
        if (dependentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependentName", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "addMissingName"));
        }
        this.myDependentsOnModulesWithoutName.add(dependentName);
    }

    public void addMissingBinaryPath(@NotNull String dependentName) {
        if (dependentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependentName", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "addMissingBinaryPath"));
        }
        this.myDependentsOnLibrariesWithoutBinaryPath.add(dependentName);
    }

    public void addInvalidModuleDependency(@NotNull Module module, @NotNull String targetModuleName, @NotNull String causeDescription) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "addInvalidModuleDependency"));
        }
        if (targetModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetModuleName", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "addInvalidModuleDependency"));
        }
        if (causeDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "causeDescription", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors", "addInvalidModuleDependency"));
        }
        this.myInvalidModuleDependencies.add(new InvalidModuleDependency(module, targetModuleName, causeDescription));
    }

    private static class IncludeMissingModulesHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final Set<String> myModuleGradlePaths;

        IncludeMissingModulesHyperlink(@NotNull List<MissingModule> missingModules) {
            if (missingModules == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "missingModules", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors$IncludeMissingModulesHyperlink", "<init>"));
            }
            super("include.missing.modules", "Find and include missing modules");
            this.myModuleGradlePaths = new HashSet<String>(missingModules.size());
            for (MissingModule module : missingModules) {
                this.myModuleGradlePaths.add(module.dependencyPath);
            }
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors$IncludeMissingModulesHyperlink", "execute"));
            }
            ProjectSubset.getInstance(project).findAndIncludeModules(this.myModuleGradlePaths);
        }
    }

    @VisibleForTesting
    static class InvalidModuleDependency {
        @NotNull
        final Module dependency;
        @NotNull
        final String dependent;
        @NotNull
        final String causeDescription;

        InvalidModuleDependency(@NotNull Module dependency, @NotNull String dependent, @NotNull String causeDescription) {
            if (dependency == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors$InvalidModuleDependency", "<init>"));
            }
            if (dependent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependent", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors$InvalidModuleDependency", "<init>"));
            }
            if (causeDescription == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "causeDescription", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors$InvalidModuleDependency", "<init>"));
            }
            this.dependency = dependency;
            this.dependent = dependent;
            this.causeDescription = causeDescription;
        }
    }

    @VisibleForTesting
    static class MissingModule {
        @NotNull
        final String dependencyPath;
        @NotNull
        final List<String> dependentNames;
        @Nullable
        final String backupLibraryName;

        MissingModule(@NotNull String dependencyPath, @Nullable String backupLibraryName) {
            if (dependencyPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyPath", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors$MissingModule", "<init>"));
            }
            this.dependencyPath = dependencyPath;
            this.dependentNames = new ArrayList<String>();
            this.backupLibraryName = backupLibraryName;
        }

        void addDependent(@NotNull String dependentName) {
            if (dependentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependentName", "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors$MissingModule", "addDependent"));
            }
            this.dependentNames.add(dependentName);
        }

        void sortDependentNames() {
            if (!this.dependentNames.isEmpty()) {
                Collections.sort(this.dependentNames);
            }
        }
    }
}

