/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.java;

import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.setup.module.JavaModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.SyncLibraryRegistry;
import com.android.tools.idea.gradle.util.FilePaths;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactsByConfigurationModuleSetupStep
extends JavaModuleSetupStep {
    @Override
    protected void doSetUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull JavaModuleModel javaModuleModel, @Nullable SyncAction.ModuleModels gradleModels, @Nullable ProgressIndicator indicator) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/java/ArtifactsByConfigurationModuleSetupStep", "doSetUpModule"));
        }
        if (ideModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/java/ArtifactsByConfigurationModuleSetupStep", "doSetUpModule"));
        }
        if (javaModuleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModuleModel", "com/android/tools/idea/gradle/project/sync/setup/module/java/ArtifactsByConfigurationModuleSetupStep", "doSetUpModule"));
        }
        ModifiableRootModel moduleModel = ideModelsProvider.getModifiableRootModel(module);
        for (Map.Entry<String, Set<File>> entry : javaModuleModel.getArtifactsByConfiguration().entrySet()) {
            Set<File> artifacts = entry.getValue();
            if (artifacts == null || artifacts.isEmpty()) continue;
            for (File artifact : artifacts) {
                if (!artifact.isFile() || !StringUtil.endsWithIgnoreCase((String)artifact.getName(), (String)".jar")) continue;
                File buildFolderPath = javaModuleModel.getBuildFolderPath();
                String artifactName = FileUtil.getNameWithoutExtension((File)artifact);
                if (buildFolderPath != null && buildFolderPath.isDirectory() && FileUtil.isAncestor((File)buildFolderPath, (File)artifact, (boolean)true) && module.getName().equals(artifactName)) continue;
                String libraryName = module.getName() + "." + artifactName;
                Library library = ideModelsProvider.getLibraryByName(libraryName);
                if (library == null) {
                    library = ideModelsProvider.createLibrary(libraryName);
                    Library.ModifiableModel libraryModel = ideModelsProvider.getModifiableLibraryModel(library);
                    String url = FilePaths.pathToIdeaUrl(artifact);
                    libraryModel.addRoot(url, OrderRootType.CLASSES);
                } else {
                    SyncLibraryRegistry.getInstance(module.getProject()).markAsUsed(library, artifact);
                }
                LibraryOrderEntry orderEntry = moduleModel.addLibraryEntry(library);
                orderEntry.setScope(DependencyScope.COMPILE);
                orderEntry.setExported(true);
            }
        }
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("artifacts by configuration setup" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/java/ArtifactsByConfigurationModuleSetupStep", "getDescription"));
        }
        return "artifacts by configuration setup";
    }
}

