/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.tools.idea.gradle.project.sync.setup.post.ModuleSetupStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleSetup {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ModuleSetupStep[] mySetupSteps;

    public ModuleSetup(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/ModuleSetup", "<init>"));
        }
        this(project, ModuleSetupStep.getExtensions());
    }

    @VisibleForTesting
    ModuleSetup(@NotNull Project project, ModuleSetupStep ... setupSteps) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/ModuleSetup", "<init>"));
        }
        if (setupSteps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setupSteps", "com/android/tools/idea/gradle/project/sync/setup/post/ModuleSetup", "<init>"));
        }
        this.myProject = project;
        this.mySetupSteps = setupSteps;
    }

    public void setUpModules(@Nullable ProgressIndicator progressIndicator) {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            for (ModuleSetupStep setupStep : this.mySetupSteps) {
                setupStep.setUpModule(module, progressIndicator);
            }
        }
    }
}

