/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.validation.android;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidProjectValidationStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ExtraGeneratedFolderValidationStrategy
extends AndroidProjectValidationStrategy {
    @NotNull
    private final List<File> myExtraGeneratedSourceFolderPaths;

    ExtraGeneratedFolderValidationStrategy(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/validation/android/ExtraGeneratedFolderValidationStrategy", "<init>"));
        }
        super(project);
        this.myExtraGeneratedSourceFolderPaths = new ArrayList<File>();
    }

    @Override
    void validate(@NotNull Module module, @NotNull AndroidModuleModel androidModel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/validation/android/ExtraGeneratedFolderValidationStrategy", "validate"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/project/sync/validation/android/ExtraGeneratedFolderValidationStrategy", "validate"));
        }
        File[] sourceFolderPaths = androidModel.getExtraGeneratedSourceFolderPaths();
        Collections.addAll(this.myExtraGeneratedSourceFolderPaths, sourceFolderPaths);
    }

    @Override
    void fixAndReportFoundIssues() {
        if (!this.myExtraGeneratedSourceFolderPaths.isEmpty()) {
            SyncMessages messages = SyncMessages.getInstance(this.getProject());
            Collections.sort(this.myExtraGeneratedSourceFolderPaths);
            for (File folder : this.myExtraGeneratedSourceFolderPaths) {
                String[] text = new String[]{"Folder " + folder.getPath()};
                messages.report(new SyncMessage("Generated Sources", MessageType.WARNING, text));
            }
            messages.report(new SyncMessage("Generated Sources", MessageType.INFO, "3rd-party Gradle plug-ins may be the cause"));
        }
    }

    @VisibleForTesting
    @NotNull
    List<File> getExtraGeneratedSourceFolderPaths() {
        List<File> list = this.myExtraGeneratedSourceFolderPaths;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/validation/android/ExtraGeneratedFolderValidationStrategy", "getExtraGeneratedSourceFolderPaths"));
        }
        return list;
    }
}

