/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.dependencies.android;

import com.android.tools.idea.gradle.structure.configurables.ui.PsCheckBoxList;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeEventDispatcher;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.android.tools.idea.gradle.structure.model.android.PsProductFlavor;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProductFlavorsPanel
extends JPanel {
    @NotNull
    private final PsCheckBoxList<PsProductFlavor> myProductFlavorsList;
    @NotNull
    private final SelectionChangeEventDispatcher<List<PsProductFlavor>> myEventDispatcher;

    ProductFlavorsPanel(@NotNull List<PsProductFlavor> productFlavors) {
        if (productFlavors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productFlavors", "com/android/tools/idea/gradle/structure/dependencies/android/ProductFlavorsPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myEventDispatcher = new SelectionChangeEventDispatcher();
        this.myProductFlavorsList = new PsCheckBoxList<PsProductFlavor>(productFlavors);
        this.myProductFlavorsList.setSelectionChangeListener(this.myEventDispatcher::selectionChanged);
        this.myProductFlavorsList.setItemsSelected(true);
        new ListSpeedSearch(this.myProductFlavorsList);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myProductFlavorsList);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)12));
        this.add((Component)scrollPane, "Center");
    }

    @NotNull
    List<PsProductFlavor> getSelectedProductFlavors() {
        ImmutableList<PsProductFlavor> immutableList = this.myProductFlavorsList.getSelectedItems();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/dependencies/android/ProductFlavorsPanel", "getSelectedProductFlavors"));
        }
        return immutableList;
    }

    void add(@NotNull SelectionChangeListener<List<PsProductFlavor>> listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/gradle/structure/dependencies/android/ProductFlavorsPanel", "add"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/android/tools/idea/gradle/structure/dependencies/android/ProductFlavorsPanel", "add"));
        }
        this.myEventDispatcher.addListener(listener, parentDisposable);
    }

    @Nullable
    JComponent getPreferredFocusedComponent() {
        return this.myProductFlavorsList;
    }
}

