/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.editors;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileKeyType;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedComboBoxEditor;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyValuePane
extends JPanel
implements DocumentListener,
ItemListener {
    private final BiMap<BuildFileKey, JComponent> myProperties;
    private boolean myIsUpdating;
    private Map<BuildFileKey, Object> myCurrentBuildFileObject;
    private Map<BuildFileKey, Object> myCurrentModelObject;
    private final Project myProject;
    private final ModificationListener myListener;
    private final Map<BuildFileKey, BiMap<String, String>> myKeysWithKnownValues;

    public KeyValuePane(@NotNull Project project, @NotNull ModificationListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/editors/KeyValuePane", "<init>"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/gradle/structure/editors/KeyValuePane", "<init>"));
        }
        this.myProperties = HashBiMap.create();
        this.myProject = project;
        this.myListener = listener;
        AndroidSdkHandler sdkHandler = null;
        AndroidSdkData androidSdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (androidSdkData != null) {
            sdkHandler = androidSdkData.getSdkHandler();
        }
        ImmutableBiMap.Builder buildToolsMapBuilder = ImmutableBiMap.builder();
        ImmutableBiMap.Builder apisMapBuilder = ImmutableBiMap.builder();
        ImmutableBiMap.Builder compiledApisMapBuilder = ImmutableBiMap.builder();
        if (sdkHandler != null) {
            StudioLoggerProgressIndicator logger = new StudioLoggerProgressIndicator(this.getClass());
            RepositoryPackages packages = sdkHandler.getSdkManager((ProgressIndicator)logger).getPackages();
            HashSet buildToolKeys = Sets.newHashSet();
            for (LocalPackage p : packages.getLocalPackagesForPrefix("build-tools")) {
                String key = p.getVersion().toString();
                if (buildToolKeys.contains(key)) continue;
                buildToolsMapBuilder.put((Object)key, (Object)key);
                buildToolKeys.add(key);
            }
            for (IAndroidTarget target : sdkHandler.getAndroidTargetManager((ProgressIndicator)logger).getTargets((ProgressIndicator)logger)) {
                String platformString;
                String label = AndroidSdkUtils.getTargetLabel(target);
                if (target.isPlatform()) {
                    String value = target.getVersion().getApiString();
                    platformString = target.getVersion().isPreview() ? AndroidTargetHash.getPlatformHashString((AndroidVersion)target.getVersion()) : value;
                    String apiString = value;
                    apisMapBuilder.put((Object)apiString, (Object)label);
                } else {
                    platformString = AndroidTargetHash.getAddonHashString((String)target.getVendor(), (String)target.getName(), (AndroidVersion)target.getVersion());
                }
                compiledApisMapBuilder.put((Object)platformString, (Object)label);
            }
        }
        ImmutableBiMap installedBuildTools = buildToolsMapBuilder.build();
        ImmutableBiMap installedApis = apisMapBuilder.build();
        ImmutableBiMap installedCompileApis = compiledApisMapBuilder.build();
        ImmutableBiMap javaCompatibility = installedApis.containsKey((Object)"N") ? ImmutableBiMap.of((Object)"JavaVersion.VERSION_1_6", (Object)"1.6", (Object)"JavaVersion.VERSION_1_7", (Object)"1.7", (Object)"JavaVersion.VERSION_1_8", (Object)"1.8") : ImmutableBiMap.of((Object)"JavaVersion.VERSION_1_6", (Object)"1.6", (Object)"JavaVersion.VERSION_1_7", (Object)"1.7");
        this.myKeysWithKnownValues = ImmutableMap.builder().put((Object)BuildFileKey.MIN_SDK_VERSION, (Object)installedApis).put((Object)BuildFileKey.TARGET_SDK_VERSION, (Object)installedApis).put((Object)BuildFileKey.COMPILE_SDK_VERSION, (Object)installedCompileApis).put((Object)BuildFileKey.BUILD_TOOLS_VERSION, (Object)installedBuildTools).put((Object)BuildFileKey.SOURCE_COMPATIBILITY, (Object)javaCompatibility).put((Object)BuildFileKey.TARGET_COMPATIBILITY, (Object)javaCompatibility).build();
    }

    public void setCurrentBuildFileObject(@Nullable Map<BuildFileKey, Object> currentBuildFileObject) {
        this.myCurrentBuildFileObject = currentBuildFileObject;
    }

    public void setCurrentModelObject(@Nullable Map<BuildFileKey, Object> currentModelObject) {
        this.myCurrentModelObject = currentModelObject;
    }

    public void init(GradleBuildFile gradleBuildFile, Collection<BuildFileKey> properties) {
        GridLayoutManager layout = new GridLayoutManager(properties.size() + 1, 2);
        this.setLayout((LayoutManager)layout);
        GridConstraints constraints = new GridConstraints();
        constraints.setAnchor(8);
        constraints.setVSizePolicy(0);
        for (BuildFileKey property : properties) {
            ComboBox component;
            constraints.setColumn(0);
            constraints.setFill(0);
            constraints.setHSizePolicy(0);
            JBLabel label = new JBLabel(property.getDisplayName());
            this.add((Component)label, constraints);
            constraints.setColumn(1);
            constraints.setFill(1);
            constraints.setHSizePolicy(4);
            switch (property.getType()) {
                case BOOLEAN: {
                    constraints.setFill(0);
                    ComboBox comboBox = this.createComboBox(false);
                    comboBox.addItem((Object)"");
                    comboBox.addItem((Object)"true");
                    comboBox.addItem((Object)"false");
                    comboBox.setPrototypeDisplayValue((Object)"(false) ");
                    component = comboBox;
                    break;
                }
                case FILE: 
                case FILE_AS_STRING: {
                    JBTextField textField = new JBTextField();
                    TextFieldWithBrowseButton fileField = new TextFieldWithBrowseButton((JTextField)textField);
                    FileChooserDescriptor d = new FileChooserDescriptor(true, false, false, true, false, false);
                    d.setShowFileSystemRoots(true);
                    fileField.addBrowseFolderListener(new TextBrowseFolderListener(d));
                    fileField.getTextField().getDocument().addDocumentListener(this);
                    component = fileField;
                    break;
                }
                case REFERENCE: {
                    constraints.setFill(0);
                    ComboBox comboBox = this.createComboBox(true);
                    if (this.hasKnownValues(property)) {
                        for (String s : this.myKeysWithKnownValues.get((Object)property).values()) {
                            comboBox.addItem((Object)s);
                        }
                    }
                    component = comboBox;
                    break;
                }
                default: {
                    ComboBox comboBox;
                    if (this.hasKnownValues(property)) {
                        constraints.setFill(0);
                        comboBox = this.createComboBox(true);
                        for (String s : this.myKeysWithKnownValues.get((Object)property).values()) {
                            comboBox.addItem((Object)s);
                        }
                        component = comboBox;
                        break;
                    }
                    JBTextField textField = new JBTextField();
                    textField.getDocument().addDocumentListener(this);
                    component = textField;
                }
            }
            this.add((Component)component, constraints);
            label.setLabelFor((Component)component);
            this.myProperties.put((Object)property, (Object)component);
            constraints.setRow(constraints.getRow() + 1);
        }
        constraints.setColumn(0);
        constraints.setVSizePolicy(2);
        constraints.setHSizePolicy(0);
        this.add((Component)new JBLabel(""), constraints);
        this.updateUiFromCurrentObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateReferenceValues(@NotNull BuildFileKey containerProperty, @NotNull Iterable<String> values) {
        if (containerProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerProperty", "com/android/tools/idea/gradle/structure/editors/KeyValuePane", "updateReferenceValues"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/android/tools/idea/gradle/structure/editors/KeyValuePane", "updateReferenceValues"));
        }
        BuildFileKey itemType = containerProperty.getItemType();
        if (itemType == null) {
            return;
        }
        ComboBox comboBox = (ComboBox)this.myProperties.get((Object)itemType);
        if (comboBox == null) {
            return;
        }
        this.myIsUpdating = true;
        try {
            String currentValue = comboBox.getEditor().getItem().toString();
            comboBox.removeAllItems();
            for (String value : values) {
                comboBox.addItem((Object)value);
            }
            comboBox.setSelectedItem((Object)currentValue);
        }
        finally {
            this.myIsUpdating = false;
        }
    }

    private ComboBox createComboBox(boolean editable) {
        ComboBox comboBox = new ComboBox();
        comboBox.addItemListener((ItemListener)this);
        comboBox.setEditor((ComboBoxEditor)new FixedComboBoxEditor());
        comboBox.setEditable(true);
        comboBox.setMinLength(60);
        JBTextField editorComponent = (JBTextField)comboBox.getEditor().getEditorComponent();
        editorComponent.setEditable(editable);
        editorComponent.getDocument().addDocumentListener(this);
        return comboBox;
    }

    private void updateCurrentObjectFromUi() {
        if (this.myIsUpdating || this.myCurrentBuildFileObject == null) {
            return;
        }
        for (Map.Entry entry : this.myProperties.entrySet()) {
            Object newValue;
            BuildFileKey key = (BuildFileKey)((Object)entry.getKey());
            JComponent component = (JComponent)entry.getValue();
            Object currentValue = this.myCurrentBuildFileObject.get((Object)key);
            BuildFileKeyType type = key.getType();
            switch (type) {
                case BOOLEAN: {
                    ComboBox comboBox = (ComboBox)component;
                    JBTextField editorComponent = (JBTextField)comboBox.getEditor().getEditorComponent();
                    int index = comboBox.getSelectedIndex();
                    if (index == 2) {
                        newValue = Boolean.FALSE;
                        editorComponent.setForeground((Color)JBColor.BLACK);
                        break;
                    }
                    if (index == 1) {
                        newValue = Boolean.TRUE;
                        editorComponent.setForeground((Color)JBColor.BLACK);
                        break;
                    }
                    newValue = null;
                    editorComponent.setForeground((Color)JBColor.GRAY);
                    break;
                }
                case FILE: 
                case FILE_AS_STRING: {
                    newValue = ((TextFieldWithBrowseButton)component).getText();
                    if ("".equals(newValue)) {
                        newValue = null;
                    }
                    if (newValue == null) break;
                    newValue = new File(newValue.toString());
                    break;
                }
                case INTEGER: {
                    String newStringValue;
                    try {
                        if (this.hasKnownValues(key)) {
                            newStringValue = ((ComboBox)component).getEditor().getItem().toString();
                            newStringValue = KeyValuePane.getMappedValue((BiMap<String, String>)this.myKeysWithKnownValues.get((Object)key).inverse(), newStringValue);
                            newValue = Integer.valueOf(newStringValue);
                            break;
                        }
                        newValue = Integer.valueOf(((JBTextField)component).getText());
                    }
                    catch (Exception e) {
                        newValue = null;
                    }
                    break;
                }
                case REFERENCE: {
                    newValue = ((ComboBox)component).getEditor().getItem();
                    String newStringValue = (String)newValue;
                    if (this.hasKnownValues(key)) {
                        newStringValue = KeyValuePane.getMappedValue((BiMap<String, String>)this.myKeysWithKnownValues.get((Object)key).inverse(), newStringValue);
                    }
                    if (newStringValue != null && newStringValue.isEmpty()) {
                        newStringValue = null;
                    }
                    String prefix = KeyValuePane.getReferencePrefix(key);
                    if (newStringValue != null && !newStringValue.startsWith(prefix)) {
                        newStringValue = prefix + newStringValue;
                    }
                    newValue = newStringValue;
                    break;
                }
                default: {
                    String newStringValue;
                    if (this.hasKnownValues(key)) {
                        newStringValue = ((ComboBox)component).getEditor().getItem().toString();
                        newStringValue = KeyValuePane.getMappedValue((BiMap<String, String>)this.myKeysWithKnownValues.get((Object)key).inverse(), newStringValue);
                        if (newStringValue.isEmpty()) {
                            newStringValue = null;
                        }
                        newValue = newStringValue;
                    } else {
                        newValue = ((JBTextField)component).getText();
                        if ("".equals(newValue)) {
                            newValue = null;
                        }
                    }
                    if (type != BuildFileKeyType.CLOSURE || newValue == null) break;
                    ArrayList newListValue = new ArrayList();
                    for (String s : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)((String)newValue))) {
                        newListValue.add(key.getValueFactory().parse(s, this.myProject));
                    }
                    newValue = newListValue;
                }
            }
            if (Objects.equal((Object)currentValue, (Object)newValue)) continue;
            if (newValue == null) {
                this.myCurrentBuildFileObject.remove((Object)key);
            } else {
                this.myCurrentBuildFileObject.put(key, newValue);
            }
            if (!GradleBuildFile.shouldWriteValue(currentValue, newValue)) continue;
            this.myListener.modified(key);
        }
    }

    public void updateUiFromCurrentObject() {
        this.myIsUpdating = true;
        for (Map.Entry entry : this.myProperties.entrySet()) {
            BuildFileKey key = (BuildFileKey)((Object)entry.getKey());
            JComponent component = (JComponent)entry.getValue();
            Object value = this.myCurrentBuildFileObject != null ? this.myCurrentBuildFileObject.get((Object)key) : null;
            Object modelValue = this.myCurrentModelObject != null ? this.myCurrentModelObject.get((Object)key) : null;
            switch (key.getType()) {
                case BOOLEAN: {
                    ComboBox comboBox = (ComboBox)component;
                    String text = KeyValuePane.formatDefaultValue(modelValue);
                    comboBox.removeItemAt(0);
                    comboBox.insertItemAt((Object)text, 0);
                    JBTextField editorComponent = (JBTextField)comboBox.getEditor().getEditorComponent();
                    if (Boolean.FALSE.equals(value)) {
                        comboBox.setSelectedIndex(2);
                        editorComponent.setForeground((Color)JBColor.BLACK);
                        break;
                    }
                    if (Boolean.TRUE.equals(value)) {
                        comboBox.setSelectedIndex(1);
                        editorComponent.setForeground((Color)JBColor.BLACK);
                        break;
                    }
                    comboBox.setSelectedIndex(0);
                    editorComponent.setForeground((Color)JBColor.GRAY);
                    break;
                }
                case FILE: 
                case FILE_AS_STRING: {
                    TextFieldWithBrowseButton fieldWithButton = (TextFieldWithBrowseButton)component;
                    fieldWithButton.setText(value != null ? value.toString() : "");
                    JBTextField textField = (JBTextField)fieldWithButton.getTextField();
                    textField.getEmptyText().setText(KeyValuePane.formatDefaultValue(modelValue));
                    break;
                }
                case REFERENCE: {
                    String stringValue = (String)value;
                    if (this.hasKnownValues(key) && stringValue != null) {
                        stringValue = KeyValuePane.getMappedValue(this.myKeysWithKnownValues.get((Object)key), stringValue);
                    }
                    String prefix = KeyValuePane.getReferencePrefix(key);
                    if (stringValue == null) {
                        stringValue = "";
                    } else if (stringValue.startsWith(prefix)) {
                        stringValue = stringValue.substring(prefix.length());
                    }
                    ComboBox comboBox = (ComboBox)component;
                    JBTextField textField = (JBTextField)comboBox.getEditor().getEditorComponent();
                    textField.getEmptyText().setText(KeyValuePane.formatDefaultValue(modelValue));
                    comboBox.setSelectedItem((Object)stringValue);
                    break;
                }
                case CLOSURE: {
                    if (value instanceof List) {
                        value = Joiner.on((String)", ").join((Iterable)((List)value));
                    }
                }
                default: {
                    JBTextField textField;
                    ComboBox comboBox;
                    if (this.hasKnownValues(key)) {
                        if (value != null) {
                            value = KeyValuePane.getMappedValue(this.myKeysWithKnownValues.get((Object)key), value.toString());
                        }
                        comboBox = (ComboBox)component;
                        comboBox.setSelectedItem((Object)(value != null ? value.toString() : ""));
                        textField = (JBTextField)comboBox.getEditor().getEditorComponent();
                        textField.getEmptyText().setText(KeyValuePane.formatDefaultValue(modelValue));
                        break;
                    }
                    JBTextField textField2 = (JBTextField)component;
                    textField2.setText(value != null ? value.toString() : "");
                    textField2.getEmptyText().setText(KeyValuePane.formatDefaultValue(modelValue));
                }
            }
            component.setEnabled(this.myCurrentBuildFileObject != null);
        }
        this.myIsUpdating = false;
    }

    @NotNull
    private static String formatDefaultValue(@Nullable Object modelValue) {
        if (modelValue == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/editors/KeyValuePane", "formatDefaultValue"));
            }
            return "";
        }
        String s = modelValue.toString();
        String string = !s.isEmpty() ? "(" + s + ")" : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/editors/KeyValuePane", "formatDefaultValue"));
        }
        return string;
    }

    @NotNull
    private static String getMappedValue(@NotNull BiMap<String, String> map, @NotNull String value) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/android/tools/idea/gradle/structure/editors/KeyValuePane", "getMappedValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/structure/editors/KeyValuePane", "getMappedValue"));
        }
        if (map.containsKey((Object)value)) {
            value = (String)map.get((Object)value);
        }
        String string = value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/editors/KeyValuePane", "getMappedValue"));
        }
        return string;
    }

    private boolean hasKnownValues(BuildFileKey key) {
        return this.myKeysWithKnownValues.containsKey((Object)key);
    }

    @Override
    public void insertUpdate(@NotNull DocumentEvent documentEvent) {
        if (documentEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentEvent", "com/android/tools/idea/gradle/structure/editors/KeyValuePane", "insertUpdate"));
        }
        this.updateCurrentObjectFromUi();
    }

    @Override
    public void removeUpdate(@NotNull DocumentEvent documentEvent) {
        if (documentEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentEvent", "com/android/tools/idea/gradle/structure/editors/KeyValuePane", "removeUpdate"));
        }
        this.updateCurrentObjectFromUi();
    }

    @Override
    public void changedUpdate(@NotNull DocumentEvent documentEvent) {
        if (documentEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentEvent", "com/android/tools/idea/gradle/structure/editors/KeyValuePane", "changedUpdate"));
        }
        this.updateCurrentObjectFromUi();
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.updateCurrentObjectFromUi();
        }
    }

    @NotNull
    private static String getReferencePrefix(@NotNull BuildFileKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/gradle/structure/editors/KeyValuePane", "getReferencePrefix"));
        }
        BuildFileKey containerType = key.getContainerType();
        if (containerType != null) {
            String path = containerType.getPath();
            String lastLeaf = path.substring(path.lastIndexOf(47) + 1);
            String string = lastLeaf + ".";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/editors/KeyValuePane", "getReferencePrefix"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/editors/KeyValuePane", "getReferencePrefix"));
        }
        return "";
    }

    public static interface ModificationListener {
        public void modified(@NotNull BuildFileKey var1);
    }
}

