/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.java.PsJavaModule;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsProject
extends PsModel {
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<PsModule> myModules;
    private boolean myModified;

    public PsProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/model/PsProject", "<init>"));
        }
        super(null);
        this.myModules = Lists.newArrayList();
        this.myProject = project;
        for (Module resolvedModel : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            String gradlePath = GradleUtil.getGradlePath(resolvedModel);
            if (gradlePath == null) continue;
            PsModule module = null;
            AndroidModuleModel gradleModel = AndroidModuleModel.get(resolvedModel);
            if (gradleModel != null) {
                module = new PsAndroidModule(this, resolvedModel, gradlePath, gradleModel);
            } else {
                JavaModuleModel javaModuleModel;
                JavaFacet facet = JavaFacet.getInstance(resolvedModel);
                if (facet != null && (javaModuleModel = facet.getJavaModuleModel()) != null && javaModuleModel.isBuildable()) {
                    module = new PsJavaModule(this, resolvedModel, gradlePath, javaModuleModel);
                }
            }
            if (module == null) continue;
            this.myModules.add(module);
        }
    }

    @Nullable
    public PsModule findModuleByName(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/structure/model/PsProject", "findModuleByName"));
        }
        for (PsModule model : this.myModules) {
            if (!moduleName.equals(model.getName())) continue;
            return model;
        }
        return null;
    }

    @Nullable
    public PsModule findModuleByGradlePath(@NotNull String gradlePath) {
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/structure/model/PsProject", "findModuleByGradlePath"));
        }
        for (PsModule model : this.myModules) {
            if (!gradlePath.equals(model.getGradlePath())) continue;
            return model;
        }
        return null;
    }

    @NotNull
    public Project getResolvedModel() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsProject", "getResolvedModel"));
        }
        return project;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myProject.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsProject", "getName"));
        }
        return string;
    }

    public void forEachModule(@NotNull Consumer<PsModule> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/android/tools/idea/gradle/structure/model/PsProject", "forEachModule"));
        }
        this.myModules.forEach(consumer);
    }

    @Override
    @Nullable
    public PsModel getParent() {
        return null;
    }

    @Override
    public boolean isDeclared() {
        return true;
    }

    @Override
    public boolean isModified() {
        return this.myModified;
    }

    @Override
    public void setModified(boolean value) {
        this.myModified = value;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return null;
    }

    public int getModelCount() {
        return this.myModules.size();
    }
}

