/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.ReplaceStringQuickFix;
import com.android.tools.lint.checks.AppCompatCallDetector;
import com.android.tools.lint.detector.api.TextFormat;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintAppCompatMethodInspection
extends AndroidLintInspectionBase {
    public AndroidLintAppCompatMethodInspection() {
        super(AndroidBundle.message("android.lint.inspections.app.compat.method", new Object[0]), AppCompatCallDetector.ISSUE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintAppCompatMethodInspection", "getQuickFixes"));
        }
        String oldCall = AppCompatCallDetector.getOldCall((String)message, (TextFormat)TextFormat.RAW);
        String newCall = AppCompatCallDetector.getNewCall((String)message, (TextFormat)TextFormat.RAW);
        if (oldCall != null && newCall != null) {
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace with " + newCall + "()", oldCall, newCall)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintAppCompatMethodInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintAppCompatMethodInspection", "getQuickFixes"));
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }
}

