/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.lint.checks.IncludeDetector;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.SetAttributeQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintIncludeLayoutParamInspection
extends AndroidLintInspectionBase {
    public AndroidLintIncludeLayoutParamInspection() {
        super(AndroidBundle.message("android.lint.inspections.include.layout.param", new Object[0]), IncludeDetector.ISSUE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintIncludeLayoutParamInspection", "getQuickFixes"));
        }
        ArrayList fixes = Lists.newArrayListWithExpectedSize((int)2);
        if (IncludeDetector.requestsWidth((String)message)) {
            fixes.add(new SetAttributeQuickFix("Set layout_width", "layout_width", null));
        }
        if (IncludeDetector.requestsHeight((String)message)) {
            fixes.add(new SetAttributeQuickFix("Set layout_height", "layout_height", null));
        }
        AndroidLintQuickFix[] androidLintQuickFixArray = fixes.toArray(new AndroidLintQuickFix[fixes.size()]);
        if (androidLintQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintIncludeLayoutParamInspection", "getQuickFixes"));
        }
        return androidLintQuickFixArray;
    }
}

