/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.lint.ReplaceStringQuickFix;
import com.android.tools.lint.checks.ManifestDetector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class AndroidLintOldTargetApiInspection
extends AndroidLintInspectionBase {
    public AndroidLintOldTargetApiInspection() {
        super(AndroidBundle.message("android.lint.inspections.old.target.api", new Object[0]), ManifestDetector.TARGET_NEWER);
    }

    private static int getHighestApi(PsiElement element) {
        AndroidSdkData sdkData;
        int max = 25;
        AndroidFacet instance = AndroidFacet.getInstance(element);
        if (instance != null && (sdkData = instance.getSdkData()) != null) {
            for (IAndroidTarget target : sdkData.getTargets()) {
                AndroidVersion version;
                if (!target.isPlatform() || (version = target.getVersion()).getApiLevel() <= max || version.isPreview()) continue;
                max = version.getApiLevel();
            }
        }
        return max;
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintOldTargetApiInspection", "getQuickFixes"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintOldTargetApiInspection", "getQuickFixes"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintOldTargetApiInspection", "getQuickFixes"));
        }
        String highest = Integer.toString(AndroidLintOldTargetApiInspection.getHighestApi(startElement));
        String label = "Update targetSdkVersion to " + highest;
        if (startElement.getContainingFile() instanceof XmlFile) {
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix(label, "targetSdkVersion\\s*=\\s*[\"'](.*)[\"']", highest)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintOldTargetApiInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
        if (startElement.getContainingFile() instanceof GroovyFile) {
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix(label, null, highest)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintOldTargetApiInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintOldTargetApiInspection", "getQuickFixes"));
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }
}

