/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.ReplaceStringQuickFix;
import com.android.tools.lint.checks.JavaPerformanceDetector;
import com.android.tools.lint.detector.api.TextFormat;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintUseValueOfInspection
extends AndroidLintInspectionBase {
    public AndroidLintUseValueOfInspection() {
        super(AndroidBundle.message("android.lint.inspections.use.value.of", new Object[0]), JavaPerformanceDetector.USE_VALUE_OF);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintUseValueOfInspection", "getQuickFixes"));
        }
        String replacedType = JavaPerformanceDetector.getReplacedType((String)message, (TextFormat)TextFormat.RAW);
        if (replacedType != null) {
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace with valueOf()", "(new\\s+" + replacedType + ")", replacedType + ".valueOf")};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintUseValueOfInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintUseValueOfInspection", "getQuickFixes"));
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }
}

