/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.ReplaceStringQuickFix;
import com.android.tools.lint.checks.WrongCaseDetector;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.openapi.editor.Document;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintWrongCaseInspection
extends AndroidLintInspectionBase {
    public AndroidLintWrongCaseInspection() {
        super(AndroidBundle.message("android.lint.inspections.wrong.case", new Object[0]), WrongCaseDetector.WRONG_CASE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintWrongCaseInspection", "getQuickFixes"));
        }
        final String current = WrongCaseDetector.getOldValue((String)message, (TextFormat)TextFormat.RAW);
        final String proposed = WrongCaseDetector.getNewValue((String)message, (TextFormat)TextFormat.RAW);
        if (proposed != null && current != null) {
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix(null, current, proposed){

                @Override
                protected void editAfter(@NotNull Document document) {
                    if (document == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/android/tools/idea/lint/AndroidLintWrongCaseInspection$1", "editAfter"));
                    }
                    String text = document.getText();
                    int index = text.indexOf("</" + current + ">");
                    if (index != -1) {
                        document.replaceString(index + 2, index + 2 + current.length(), (CharSequence)proposed);
                    }
                }
            }};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintWrongCaseInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintWrongCaseInspection", "getQuickFixes"));
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }
}

