/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.ResourceType;
import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.android.tools.idea.lint.GenerateBackupDescriptorFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.lint.SetAttributeQuickFix;
import org.jetbrains.annotations.NotNull;

class SetAndGenerateBackupDescriptor
extends DefaultLintQuickFix {
    private static final String RESOURCE_URL_NAME = "backup_descriptor";
    private final SetAttributeQuickFix mySetAttributeQuickFix;
    private final GenerateBackupDescriptorFix myGenerateDescriptorFix;

    public SetAndGenerateBackupDescriptor() {
        super("Set fullBackupContent attribute and generate descriptor");
        ResourceUrl resourceUrl = ResourceUrl.create((ResourceType)ResourceType.XML, (String)RESOURCE_URL_NAME, (boolean)false, (boolean)false);
        this.mySetAttributeQuickFix = new SetAttributeQuickFix(this.myName, "fullBackupContent", resourceUrl.toString());
        this.myGenerateDescriptorFix = new GenerateBackupDescriptorFix(resourceUrl);
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/SetAndGenerateBackupDescriptor", "apply"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/SetAndGenerateBackupDescriptor", "apply"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/lint/SetAndGenerateBackupDescriptor", "apply"));
        }
        this.mySetAttributeQuickFix.apply(startElement, endElement, context);
        this.myGenerateDescriptorFix.apply(startElement, endElement, context);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/SetAndGenerateBackupDescriptor", "isApplicable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/SetAndGenerateBackupDescriptor", "isApplicable"));
        }
        if (contextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "com/android/tools/idea/lint/SetAndGenerateBackupDescriptor", "isApplicable"));
        }
        return SetAndGenerateBackupDescriptor.isAllowBackupEnabled(startElement) && this.mySetAttributeQuickFix.isApplicable(startElement, endElement, contextType) && this.myGenerateDescriptorFix.isApplicable(startElement, endElement, contextType);
    }

    static boolean isAllowBackupEnabled(@NotNull PsiElement startElement) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/SetAndGenerateBackupDescriptor", "isAllowBackupEnabled"));
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
        if (tag == null) {
            return true;
        }
        return !"false".equals(tag.getAttributeValue("allowBackup", "http://schemas.android.com/apk/res/android"));
    }
}

