/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatService;
import org.jetbrains.annotations.NotNull;

abstract class FormattedLogcatReceiver
implements AndroidLogcatService.LogcatListener {
    private LogCatHeader myActiveHeader;

    FormattedLogcatReceiver() {
    }

    @Override
    public final void onLogLineReceived(@NotNull LogCatMessage line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/FormattedLogcatReceiver", "onLogLineReceived"));
        }
        if (!line.getHeader().equals(this.myActiveHeader)) {
            this.myActiveHeader = line.getHeader();
            String message = AndroidLogcatFormatter.formatMessageFull(this.myActiveHeader, line.getMessage());
            this.receiveFormattedLogLine(message);
        } else {
            String message = AndroidLogcatFormatter.formatContinuation(line.getMessage());
            this.receiveFormattedLogLine(message);
        }
    }

    protected abstract void receiveFormattedLogLine(@NotNull String var1);
}

