/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.AnimatedRange;
import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.GridComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendRenderData;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.datastore.DataStoreSeries;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.datastore.SeriesDataType;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.BaseProfilerUiManager;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseLineChartSegment
extends BaseSegment {
    private static final int MULTI_CLICK_INTERVAL_MS = 300;
    private static final int MOUSE_DRAG_DISTANCE_THRESHOLD_PX = 5;
    private static final int MULTI_CLICK_THRESHOLD = 2;
    @NotNull
    protected AnimatedRange mLeftAxisRange;
    @NotNull
    protected AnimatedRange mRightAxisRange;
    private AxisComponent mLeftAxis;
    private AxisComponent mRightAxis;
    @NotNull
    private final BaseAxisFormatter mLeftAxisFormatterSimple;
    @NotNull
    private final BaseAxisFormatter mLeftAxisFormatter;
    @Nullable
    private final BaseAxisFormatter mRightAxisFormatter;
    private GridComponent mGrid;
    private LineChart mLineChart;
    protected LegendComponent mLegendComponent;
    @NotNull
    protected SeriesDataStore mSeriesDataStore;
    private final ArrayDeque<MouseEvent> mDelayedEvents;
    private boolean mMultiClicked;
    private Point mMousePressedPosition;

    public BaseLineChartSegment(@NotNull String name, @NotNull Range timeCurrentRangeUs, @NotNull SeriesDataStore dataStore, @NotNull BaseAxisFormatter leftAxisFormatterSimple, @NotNull BaseAxisFormatter leftAxisFormatter, @Nullable BaseAxisFormatter rightAxisFormatter, @Nullable AnimatedRange leftAxisRange, @Nullable AnimatedRange rightAxisRange, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/monitor/ui/BaseLineChartSegment", "<init>"));
        }
        if (timeCurrentRangeUs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeCurrentRangeUs", "com/android/tools/idea/monitor/ui/BaseLineChartSegment", "<init>"));
        }
        if (dataStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStore", "com/android/tools/idea/monitor/ui/BaseLineChartSegment", "<init>"));
        }
        if (leftAxisFormatterSimple == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftAxisFormatterSimple", "com/android/tools/idea/monitor/ui/BaseLineChartSegment", "<init>"));
        }
        if (leftAxisFormatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftAxisFormatter", "com/android/tools/idea/monitor/ui/BaseLineChartSegment", "<init>"));
        }
        if (dispatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatcher", "com/android/tools/idea/monitor/ui/BaseLineChartSegment", "<init>"));
        }
        super(name, timeCurrentRangeUs, dispatcher);
        this.mLeftAxisFormatterSimple = leftAxisFormatterSimple;
        this.mLeftAxisFormatter = leftAxisFormatter;
        this.mRightAxisFormatter = rightAxisFormatter;
        this.mLeftAxisRange = leftAxisRange != null ? leftAxisRange : new AnimatedRange();
        this.mRightAxisRange = rightAxisRange != null ? rightAxisRange : new AnimatedRange();
        this.mSeriesDataStore = dataStore;
        this.mDelayedEvents = new ArrayDeque();
        this.initializeListeners();
    }

    public BaseLineChartSegment(@NotNull String name, @NotNull Range timeCurrentRangeUs, @NotNull SeriesDataStore dataStore, @NotNull BaseAxisFormatter leftAxisFormatterSimple, @NotNull BaseAxisFormatter leftAxisFormatter, @Nullable BaseAxisFormatter rightAxisFormatter, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/monitor/ui/BaseLineChartSegment", "<init>"));
        }
        if (timeCurrentRangeUs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeCurrentRangeUs", "com/android/tools/idea/monitor/ui/BaseLineChartSegment", "<init>"));
        }
        if (dataStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStore", "com/android/tools/idea/monitor/ui/BaseLineChartSegment", "<init>"));
        }
        if (leftAxisFormatterSimple == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftAxisFormatterSimple", "com/android/tools/idea/monitor/ui/BaseLineChartSegment", "<init>"));
        }
        if (leftAxisFormatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftAxisFormatter", "com/android/tools/idea/monitor/ui/BaseLineChartSegment", "<init>"));
        }
        if (dispatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatcher", "com/android/tools/idea/monitor/ui/BaseLineChartSegment", "<init>"));
        }
        this(name, timeCurrentRangeUs, dataStore, leftAxisFormatterSimple, leftAxisFormatter, rightAxisFormatter, null, null, dispatcher);
    }

    public abstract BaseProfilerUiManager.ProfilerType getProfilerType();

    @Override
    public void createComponentsList(@NotNull List<Animatable> animatables) {
        if (animatables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "animatables", "com/android/tools/idea/monitor/ui/BaseLineChartSegment", "createComponentsList"));
        }
        AxisComponent.Builder builder = new AxisComponent.Builder((Range)this.mLeftAxisRange, this.mLeftAxisFormatterSimple, AxisComponent.AxisOrientation.LEFT).showMax(true).clampToMajorTicks(true);
        this.mLeftAxis = builder.build();
        if (this.mRightAxisFormatter != null) {
            builder = new AxisComponent.Builder((Range)this.mRightAxisRange, this.mRightAxisFormatter, AxisComponent.AxisOrientation.RIGHT).showMax(true).setParentAxis(this.mLeftAxis);
            this.mRightAxis = builder.build();
            this.mRightAxis.setParentAxis(this.mLeftAxis);
            this.mRightAxis.setVisible(false);
        }
        this.mLineChart = new LineChart();
        this.mGrid = new GridComponent();
        this.mGrid.addAxis(this.mLeftAxis);
        this.mGrid.setVisible(false);
        this.mLegendComponent = new LegendComponent(LegendComponent.Orientation.HORIZONTAL, 100);
        animatables.add((Animatable)this.mLineChart);
        animatables.add((Animatable)this.mLeftAxis);
        if (this.mRightAxis != null) {
            animatables.add((Animatable)this.mRightAxis);
        }
        animatables.add((Animatable)this.mLeftAxisRange);
        animatables.add((Animatable)this.mRightAxisRange);
        animatables.add((Animatable)this.mLegendComponent);
        animatables.add((Animatable)this.mGrid);
    }

    @Override
    protected void setLeftContent(@NotNull JPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/android/tools/idea/monitor/ui/BaseLineChartSegment", "setLeftContent"));
        }
        panel.add((Component)this.mLeftAxis, "Center");
    }

    @Override
    protected void setTopCenterContent(@NotNull JPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/android/tools/idea/monitor/ui/BaseLineChartSegment", "setTopCenterContent"));
        }
        panel.add((Component)this.mLegendComponent, "East");
    }

    @Override
    protected void setCenterContent(@NotNull JPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/android/tools/idea/monitor/ui/BaseLineChartSegment", "setCenterContent"));
        }
        JBLayeredPane layeredPane = new JBLayeredPane();
        layeredPane.add((Component)this.mLineChart);
        layeredPane.add((Component)this.mGrid);
        layeredPane.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JLayeredPane host = (JLayeredPane)e.getComponent();
                if (host != null) {
                    Dimension dim = host.getSize();
                    for (Component c : host.getComponents()) {
                        c.setBounds(0, 0, dim.width, dim.height);
                    }
                }
            }
        });
        panel.add((Component)layeredPane, "Center");
    }

    @Override
    protected void setRightContent(@NotNull JPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/android/tools/idea/monitor/ui/BaseLineChartSegment", "setRightContent"));
        }
        if (this.mRightAxisFormatter != null) {
            panel.add((Component)this.mRightAxis, "Center");
            this.setRightSpacerVisible(true);
        }
    }

    private void initializeListeners() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                BaseLineChartSegment.this.mMousePressedPosition = e.getPoint();
                if (e.getClickCount() >= 2 && !BaseLineChartSegment.this.mDelayedEvents.isEmpty()) {
                    BaseLineChartSegment.this.mMultiClicked = true;
                    BaseLineChartSegment.this.handleMultiClickEvent();
                } else {
                    BaseLineChartSegment.this.mMultiClicked = false;
                    BaseLineChartSegment.this.mDelayedEvents.add(e);
                    Timer dispatchTimer = new Timer(300, e1 -> BaseLineChartSegment.this.dispatchOrAbsorbEvents());
                    dispatchTimer.setRepeats(false);
                    dispatchTimer.start();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                BaseLineChartSegment.this.dispatchOrDelayEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                BaseLineChartSegment.this.dispatchOrDelayEvent(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                BaseLineChartSegment.this.dispatchOrDelayEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                BaseLineChartSegment.this.dispatchOrDelayEvent(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                double distance;
                BaseLineChartSegment.this.dispatchOrDelayEvent(e);
                if (!BaseLineChartSegment.this.mDelayedEvents.isEmpty() && (distance = Point.distance(BaseLineChartSegment.this.mMousePressedPosition.getX(), BaseLineChartSegment.this.mMousePressedPosition.getY(), e.getPoint().getX(), e.getPoint().getY())) > 5.0) {
                    BaseLineChartSegment.this.dispatchOrAbsorbEvents();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                BaseLineChartSegment.this.dispatchOrDelayEvent(e);
            }
        });
    }

    protected void handleMultiClickEvent() {
        ((ProfilerEventListener)this.mEventDispatcher.getMulticaster()).profilerExpanded(this.getProfilerType());
    }

    private void dispatchOrDelayEvent(MouseEvent e) {
        if (this.mDelayedEvents.isEmpty()) {
            this.getParent().dispatchEvent(e);
        } else {
            this.mDelayedEvents.addLast(e);
        }
    }

    private void dispatchOrAbsorbEvents() {
        if (this.mMultiClicked) {
            this.mDelayedEvents.clear();
        } else {
            while (!this.mDelayedEvents.isEmpty()) {
                this.getParent().dispatchEvent(this.mDelayedEvents.remove());
            }
        }
    }

    @Override
    public void toggleView(boolean isExpanded) {
        super.toggleView(isExpanded);
        this.mGrid.setVisible(isExpanded);
        this.mLeftAxis.setAxisFormatter(isExpanded ? this.mLeftAxisFormatter : this.mLeftAxisFormatterSimple);
        this.mLineChart.clearConfigs();
        this.updateChartLines(isExpanded);
        this.mLegendComponent.setLegendData(this.getLegendRenderDataList());
    }

    protected abstract void updateChartLines(boolean var1);

    private List<LegendRenderData> getLegendRenderDataList() {
        ArrayList<LegendRenderData> legendRenderDataList = new ArrayList<LegendRenderData>();
        for (RangedContinuousSeries series : this.mLineChart.getRangedContinuousSeries()) {
            LineConfig lineConfig = this.mLineChart.getLineConfig(series);
            LegendRenderData.IconType iconType = lineConfig.getLegendIconType();
            if (iconType == null) {
                iconType = lineConfig.isFilled() ? LegendRenderData.IconType.BOX : LegendRenderData.IconType.LINE;
            }
            legendRenderDataList.add(new LegendRenderData(iconType, lineConfig.getColor(), series.getLabel()));
        }
        return legendRenderDataList;
    }

    protected void addLeftAxisLine(SeriesDataType type, String label, LineConfig lineConfig) {
        this.addLeftAxisLine(type, label, lineConfig, (DataSeries)new DataStoreSeries(this.mSeriesDataStore, type));
    }

    protected void addLeftAxisLine(SeriesDataType type, String label, LineConfig lineConfig, DataSeries series) {
        this.mLineChart.addLine(new RangedContinuousSeries(label, this.myTimeCurrentRangeUs, (Range)this.mLeftAxisRange, series), lineConfig);
    }

    protected void addRightAxisLine(SeriesDataType type, String label, LineConfig lineConfig) {
        this.addRightAxisLine(type, label, lineConfig, (DataSeries)new DataStoreSeries(this.mSeriesDataStore, type));
    }

    protected void addRightAxisLine(SeriesDataType type, String label, LineConfig lineConfig, DataSeries series) {
        if (this.mRightAxisFormatter == null) {
            throw new IllegalComponentStateException("Right axis formatter is not defined, cannot add right axis line.");
        }
        this.mLineChart.addLine(new RangedContinuousSeries(label, this.myTimeCurrentRangeUs, (Range)this.mRightAxisRange, series), lineConfig);
        this.mRightAxis.setVisible(true);
    }
}

