/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.cpu.view;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendRenderData;
import com.android.tools.adtui.chart.StateChart;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.datastore.DataStoreSeries;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.datastore.SeriesDataType;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.cpu.model.ThreadAddedNotifier;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profilers.cpu.ThreadStateDataSeries;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadsSegment
extends BaseSegment
implements Animatable {
    private static final String SEGMENT_NAME = "Threads";
    private static final String RUNNING_LABEL = "Runnable";
    private static final String SLEEPING_LABEL = "Waiting";
    private static final String BLOCKED_LABEL = "Blocked";
    private static final int THREADS_NAME_LEFT_MARGIN = JBUI.scale((int)10);
    private static final Color LIST_ITEM_HOVER_BACKGROUND = new JBColor(new Color(22, 80, 197, 23), new Color(255, 255, 255, 13));
    private static final Color LIST_ITEM_SELECTED_BACKGROUND = new JBColor(new Color(70, 118, 187), new Color(70, 118, 187));
    private final int mFontHeight;
    private final int mCellHeight;
    private final int mThreadsChartY;
    private final Map<ThreadStateDataSeries, StateChart<CpuProfiler.ThreadActivity.State>> mThreadsStateCharts;
    private final DefaultListModel<ThreadStateDataSeries> mThreadsListModel;
    private final JBList mThreadsList;
    private int mHoveredListIndex;
    private static EnumMap<CpuProfiler.ThreadActivity.State, Color> mThreadStateColor;
    @Nullable
    private final ThreadSelectedListener mThreadSelectedListener;
    @NotNull
    private SeriesDataStore mSeriesDataStore;
    @NotNull
    private final ThreadAddedNotifier myThreadAddedNotifier;
    private LegendComponent mLegendComponent;

    public ThreadsSegment(@NotNull Range timeCurrentRangeUs, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> dispatcher, @Nullable ThreadSelectedListener threadSelectedListener) {
        if (timeCurrentRangeUs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeCurrentRangeUs", "com/android/tools/idea/monitor/ui/cpu/view/ThreadsSegment", "<init>"));
        }
        if (dataStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStore", "com/android/tools/idea/monitor/ui/cpu/view/ThreadsSegment", "<init>"));
        }
        if (dispatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatcher", "com/android/tools/idea/monitor/ui/cpu/view/ThreadsSegment", "<init>"));
        }
        super(SEGMENT_NAME, timeCurrentRangeUs, dispatcher);
        this.mFontHeight = JBUI.scale((int)this.getFontMetrics((Font)AdtUiUtils.DEFAULT_FONT).getHeight());
        this.mCellHeight = 2 * this.mFontHeight;
        this.mThreadsChartY = (this.mCellHeight - this.mFontHeight) / 2;
        this.mThreadsStateCharts = new HashMap<ThreadStateDataSeries, StateChart<CpuProfiler.ThreadActivity.State>>();
        this.mThreadsListModel = new DefaultListModel();
        this.mThreadsList = new JBList(this.mThreadsListModel);
        this.mHoveredListIndex = -1;
        this.mSeriesDataStore = dataStore;
        this.mThreadSelectedListener = threadSelectedListener;
        this.myThreadAddedNotifier = threadStatesDataModel -> {
            if (this.mThreadsStateCharts.containsKey(threadStatesDataModel)) {
                return;
            }
            this.createThreadStateChart(threadStatesDataModel);
        };
        this.initialize();
    }

    @Override
    protected boolean hasLeftContent() {
        return false;
    }

    @Override
    protected boolean hasRightContent() {
        return false;
    }

    @NotNull
    private static EnumMap<CpuProfiler.ThreadActivity.State, Color> getThreadStateColor() {
        if (mThreadStateColor != null) {
            EnumMap<CpuProfiler.ThreadActivity.State, Color> enumMap = mThreadStateColor;
            if (enumMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/ui/cpu/view/ThreadsSegment", "getThreadStateColor"));
            }
            return enumMap;
        }
        mThreadStateColor = new EnumMap(CpuProfiler.ThreadActivity.State.class);
        mThreadStateColor.put(CpuProfiler.ThreadActivity.State.RUNNING, (Color)new JBColor(new Color(134, 199, 144), new Color(134, 199, 144)));
        mThreadStateColor.put(CpuProfiler.ThreadActivity.State.SLEEPING, (Color)new JBColor((Color)Gray._189, (Color)Gray._189));
        mThreadStateColor.put(CpuProfiler.ThreadActivity.State.DEAD, Gray.TRANSPARENT);
        EnumMap<CpuProfiler.ThreadActivity.State, Color> enumMap = mThreadStateColor;
        if (enumMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/ui/cpu/view/ThreadsSegment", "getThreadStateColor"));
        }
        return enumMap;
    }

    private void initialize() {
        this.initializeStateChartsList();
        this.initializeLegendComponent();
    }

    private void initializeLegendComponent() {
        ArrayList<LegendRenderData> legendRenderDataList = new ArrayList<LegendRenderData>();
        legendRenderDataList.add(new LegendRenderData(LegendRenderData.IconType.BOX, ThreadsSegment.getThreadStateColor().get(CpuProfiler.ThreadActivity.State.RUNNING), RUNNING_LABEL));
        legendRenderDataList.add(new LegendRenderData(LegendRenderData.IconType.BOX, ThreadsSegment.getThreadStateColor().get(CpuProfiler.ThreadActivity.State.SLEEPING), SLEEPING_LABEL));
        legendRenderDataList.add(new LegendRenderData(LegendRenderData.IconType.BOX, (Color)new JBColor(new Color(199, 65, 101), new Color(199, 65, 101)), BLOCKED_LABEL));
        this.mLegendComponent = new LegendComponent(LegendComponent.Orientation.HORIZONTAL, Integer.MAX_VALUE);
        this.mLegendComponent.setLegendData(legendRenderDataList);
    }

    private void initializeStateChartsList() {
        this.mThreadsList.setCellRenderer((ListCellRenderer)new ThreadsStateCellRenderer());
        this.mThreadsList.setSelectionBackground(AdtUiUtils.DEFAULT_BACKGROUND_COLOR);
        this.mThreadsList.setFixedCellHeight(this.mCellHeight);
        if (this.mThreadSelectedListener != null) {
            this.mThreadsList.addListSelectionListener(event -> {
                int[] selectedThreadsIndices = this.mThreadsList.getSelectedIndices();
                ArrayList<ThreadStateDataSeries> selectedThreads = new ArrayList<ThreadStateDataSeries>();
                for (int i = 0; i < selectedThreadsIndices.length; ++i) {
                    selectedThreads.add(this.mThreadsListModel.get(selectedThreadsIndices[i]));
                }
                this.mThreadSelectedListener.onSelected(selectedThreads);
            });
        }
        this.mThreadsList.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                Point p = new Point(me.getX(), me.getY());
                int index = ThreadsSegment.this.mThreadsList.locationToIndex(p);
                if (index != ThreadsSegment.this.mHoveredListIndex) {
                    ThreadsSegment.this.mHoveredListIndex = index;
                    ThreadsSegment.this.mThreadsList.repaint();
                }
            }
        });
    }

    @Override
    protected void setTopCenterContent(@NotNull JPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/android/tools/idea/monitor/ui/cpu/view/ThreadsSegment", "setTopCenterContent"));
        }
        panel.add((Component)this.mLegendComponent, "East");
    }

    @Override
    protected void setCenterContent(@NotNull JPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/android/tools/idea/monitor/ui/cpu/view/ThreadsSegment", "setCenterContent"));
        }
        JBLayeredPane centerPane = new JBLayeredPane();
        JBScrollPane scrollPane = new JBScrollPane((Component)this.mThreadsList);
        centerPane.add((Component)scrollPane);
        centerPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JLayeredPane host = (JLayeredPane)e.getComponent();
                if (host != null) {
                    Dimension dim = host.getSize();
                    for (Component c : host.getComponents()) {
                        c.setBounds(0, 0, dim.width, dim.height);
                    }
                }
            }
        });
        panel.add((Component)centerPane, "Center");
    }

    @NotNull
    public ThreadAddedNotifier getThreadAddedNotifier() {
        ThreadAddedNotifier threadAddedNotifier = this.myThreadAddedNotifier;
        if (threadAddedNotifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/ui/cpu/view/ThreadsSegment", "getThreadAddedNotifier"));
        }
        return threadAddedNotifier;
    }

    private void createThreadStateChart(ThreadStateDataSeries threadStateDataSeries) {
        StateChart stateChart = new StateChart(ThreadsSegment.getThreadStateColor());
        this.mThreadsStateCharts.put(threadStateDataSeries, (StateChart<CpuProfiler.ThreadActivity.State>)stateChart);
        DataStoreSeries defaultData = new DataStoreSeries(this.mSeriesDataStore, SeriesDataType.CPU_THREAD_STATE, (Object)threadStateDataSeries);
        RangedSeries threadSeries = new RangedSeries(this.myTimeCurrentRangeUs, (DataSeries)defaultData);
        this.mThreadsStateCharts.get(threadStateDataSeries).addSeries(threadSeries);
        this.mThreadsListModel.addElement(threadStateDataSeries);
    }

    public void reset() {
        this.mThreadsStateCharts.values().forEach(AnimatedComponent::reset);
        this.mLegendComponent.reset();
    }

    public void animate(float frameLength) {
        this.mThreadsStateCharts.values().forEach(chart -> chart.animate(frameLength));
        this.mLegendComponent.animate(frameLength);
    }

    public void postAnimate() {
        this.mThreadsStateCharts.values().forEach(Animatable::postAnimate);
        this.mLegendComponent.postAnimate();
    }

    private class ThreadsStateCellRenderer
    implements ListCellRenderer<ThreadStateDataSeries> {
        private ThreadsStateCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ThreadStateDataSeries> list, ThreadStateDataSeries threadStateDataSeries, int index, boolean isSelected, boolean cellHasFocus) {
            JLayeredPane cellPane = new JLayeredPane();
            cellPane.setOpaque(true);
            cellPane.setBounds(0, 0, list.getWidth(), ThreadsSegment.this.mCellHeight);
            Color cellBackground = AdtUiUtils.DEFAULT_BACKGROUND_COLOR;
            if (isSelected) {
                cellBackground = LIST_ITEM_SELECTED_BACKGROUND;
            } else if (ThreadsSegment.this.mHoveredListIndex == index) {
                cellBackground = LIST_ITEM_HOVER_BACKGROUND;
            }
            cellPane.setBackground(cellBackground);
            return cellPane;
        }
    }

    public static interface ThreadSelectedListener {
        public void onSelected(@NotNull List<ThreadStateDataSeries> var1);
    }
}

