/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.energy.model;

import com.android.tools.datastore.DataAdapter;
import com.android.tools.datastore.Poller;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.datastore.SeriesDataType;
import com.android.tools.idea.monitor.ui.energy.model.EnergyDataAdapter;
import com.android.tools.profiler.proto.EnergyProfiler;
import io.grpc.StatusRuntimeException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class EnergyPoller
extends Poller {
    public static final SeriesDataType[] ENERGY_DATA_TYPES = new SeriesDataType[]{SeriesDataType.ENERGY_SCREEN, SeriesDataType.ENERGY_CPU_SYSTEM, SeriesDataType.ENERGY_CPU_USER, SeriesDataType.ENERGY_CELL_NETWORK, SeriesDataType.ENERGY_WIFI_NETWORK, SeriesDataType.ENERGY_TOTAL};
    private static final long POLL_PERIOD_NS = TimeUnit.MILLISECONDS.toNanos(1000L);
    private final int myPid;
    private long myLatestSampleTimestampNs;
    private HashMap<SeriesDataType, EnergyDataAdapter> myAdapters;

    public EnergyPoller(@NotNull SeriesDataStore dataStore, int pid, boolean showInstantanenousByDefault) {
        if (dataStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStore", "com/android/tools/idea/monitor/ui/energy/model/EnergyPoller", "<init>"));
        }
        super(dataStore, POLL_PERIOD_NS);
        this.myPid = pid;
        this.myLatestSampleTimestampNs = -1L;
        this.myAdapters = new HashMap();
        for (SeriesDataType type : ENERGY_DATA_TYPES) {
            EnergyDataAdapter adapter = new EnergyDataAdapter();
            adapter.setReturnInstantaneousData(showInstantanenousByDefault);
            dataStore.registerAdapter(type, (DataAdapter)adapter);
            this.myAdapters.put(type, adapter);
        }
    }

    public EnergyDataAdapter getEnergyAdapter(SeriesDataType dataType) {
        return this.myAdapters.get(dataType);
    }

    protected void asyncInit() throws StatusRuntimeException {
        EnergyProfiler.StartEnergyCollectionRequest request = EnergyProfiler.StartEnergyCollectionRequest.newBuilder().setAppId(this.myPid).build();
        EnergyProfiler.EnergyCollectionStatusResponse response = this.myService.getEnergyService().startCollection(request);
        this.myLatestSampleTimestampNs = response.getTimestamp();
    }

    protected void asyncShutdown() throws StatusRuntimeException {
        EnergyProfiler.StopEnergyCollectionRequest request = EnergyProfiler.StopEnergyCollectionRequest.newBuilder().setAppId(this.myPid).build();
        this.myService.getEnergyService().stopCollection(request);
    }

    protected void poll() throws StatusRuntimeException {
        EnergyProfiler.EnergyDataRequest request = EnergyProfiler.EnergyDataRequest.newBuilder().setAppId(this.myPid).setStartTimeExcl(this.myLatestSampleTimestampNs).setEndTimeIncl(Long.MAX_VALUE).build();
        EnergyProfiler.EnergyDataResponse response = this.myService.getEnergyService().getEnergyData(request);
        long latestTimestampNs = 0L;
        for (EnergyProfiler.EnergySample sample : response.getEnergySamplesList()) {
            long timestampUs = TimeUnit.NANOSECONDS.toMicros(sample.getTimestamp());
            long total = 0L;
            this.myAdapters.get(SeriesDataType.ENERGY_SCREEN).update(timestampUs, sample.getScreenPowerUsage());
            this.myAdapters.get(SeriesDataType.ENERGY_CPU_SYSTEM).update(timestampUs, sample.getCpuSystemPowerUsage());
            this.myAdapters.get(SeriesDataType.ENERGY_CPU_USER).update(timestampUs, sample.getCpuUserPowerUsage());
            this.myAdapters.get(SeriesDataType.ENERGY_CELL_NETWORK).update(timestampUs, sample.getCellNetworkPowerUsage());
            this.myAdapters.get(SeriesDataType.ENERGY_WIFI_NETWORK).update(timestampUs, sample.getWifiNetworkPowerUsage());
            for (SeriesDataType type : ENERGY_DATA_TYPES) {
                if (type == SeriesDataType.ENERGY_TOTAL) continue;
                total += this.myAdapters.get(type).getLatest();
            }
            this.myAdapters.get(SeriesDataType.ENERGY_TOTAL).update(timestampUs, total);
            if (latestTimestampNs >= sample.getTimestamp()) continue;
            latestTimestampNs = sample.getTimestamp();
        }
        if (this.myLatestSampleTimestampNs < latestTimestampNs) {
            this.myLatestSampleTimestampNs = latestTimestampNs;
        }
    }
}

