/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.network.view;

import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.formatter.BaseAxisFormatter;
import com.android.tools.adtui.common.formatter.NetworkTrafficFormatter;
import com.android.tools.adtui.common.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.Range;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.datastore.SeriesDataType;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.BaseLineChartSegment;
import com.android.tools.idea.monitor.ui.BaseProfilerUiManager;
import com.android.tools.idea.monitor.ui.network.view.Constants;
import com.intellij.util.EventDispatcher;
import org.jetbrains.annotations.NotNull;

public class NetworkSegment
extends BaseLineChartSegment {
    private static final String SEGMENT_NAME = "Network";
    private static final String SENDING = "Sending";
    private static final String RECEIVING = "Receiving";
    private static final String CONNECTIONS = "Connections";
    private static final BaseAxisFormatter BANDWIDTH_AXIS_FORMATTER_L1 = new NetworkTrafficFormatter(1, 5, 5);
    private static final BaseAxisFormatter CONNECTIONS_AXIS_FORMATTER = new SingleUnitAxisFormatter(1, 10, 1, "");

    public NetworkSegment(@NotNull Range timeCurrentRangeUs, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        if (timeCurrentRangeUs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeCurrentRangeUs", "com/android/tools/idea/monitor/ui/network/view/NetworkSegment", "<init>"));
        }
        if (dataStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStore", "com/android/tools/idea/monitor/ui/network/view/NetworkSegment", "<init>"));
        }
        if (dispatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatcher", "com/android/tools/idea/monitor/ui/network/view/NetworkSegment", "<init>"));
        }
        super(SEGMENT_NAME, timeCurrentRangeUs, dataStore, BANDWIDTH_AXIS_FORMATTER_L1, (BaseAxisFormatter)NetworkTrafficFormatter.DEFAULT, CONNECTIONS_AXIS_FORMATTER, dispatcher);
    }

    @Override
    public BaseProfilerUiManager.ProfilerType getProfilerType() {
        return BaseProfilerUiManager.ProfilerType.NETWORK;
    }

    @Override
    protected void updateChartLines(boolean isExpanded) {
        this.addLeftAxisLine(SeriesDataType.NETWORK_SENT, SENDING, new LineConfig(Constants.NETWORK_SENDING_COLOR));
        this.addLeftAxisLine(SeriesDataType.NETWORK_RECEIVED, RECEIVING, new LineConfig(Constants.NETWORK_RECEIVING_COLOR));
        if (isExpanded) {
            this.addRightAxisLine(SeriesDataType.NETWORK_CONNECTIONS, CONNECTIONS, new LineConfig(Constants.NETWORK_CONNECTIONS_COLOR).setStepped(true));
        }
    }
}

