/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.android.tools.idea.navigator.nodes.NativeAndroidSourceDirectoryNode;
import com.android.tools.idea.navigator.nodes.NdkModuleNode;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJniFolderNode
extends ProjectViewNode<NdkModuleModel>
implements DirectoryGroupNode {
    protected AndroidJniFolderNode(@NotNull Project project, @NotNull NdkModuleModel ndkModuleModel, @NotNull ViewSettings viewSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/navigator/nodes/AndroidJniFolderNode", "<init>"));
        }
        if (ndkModuleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ndkModuleModel", "com/android/tools/idea/navigator/nodes/AndroidJniFolderNode", "<init>"));
        }
        if (viewSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewSettings", "com/android/tools/idea/navigator/nodes/AndroidJniFolderNode", "<init>"));
        }
        super(project, (Object)ndkModuleModel, viewSettings);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        AbstractTreeNode sourceNode;
        assert (this.myProject != null);
        Collection<AbstractTreeNode> nativeSourceNodes = NdkModuleNode.getNativeSourceNodes(this.myProject, this.getModel(), this.getSettings());
        if (nativeSourceNodes.size() == 1 && (sourceNode = (AbstractTreeNode)Iterables.getOnlyElement(nativeSourceNodes)) instanceof NativeAndroidSourceDirectoryNode) {
            Collection collection = ((NativeAndroidSourceDirectoryNode)sourceNode).getChildren();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidJniFolderNode", "getChildren"));
            }
            return collection;
        }
        Collection<AbstractTreeNode> collection = nativeSourceNodes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidJniFolderNode", "getChildren"));
        }
        return collection;
    }

    @Override
    @NotNull
    public PsiDirectory[] getDirectories() {
        Collection<File> sourceFolders = this.getModel().getSelectedVariant().getSourceFolders();
        ArrayList psiDirectories = Lists.newArrayListWithExpectedSize((int)sourceFolders.size());
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        assert (this.myProject != null);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (File folder : sourceFolders) {
            PsiDirectory dir;
            VirtualFile virtualFile = fileSystem.findFileByIoFile(folder);
            if (virtualFile == null || (dir = psiManager.findDirectory(virtualFile)) == null) continue;
            psiDirectories.add(dir);
        }
        PsiDirectory[] psiDirectoryArray = psiDirectories.toArray(new PsiDirectory[psiDirectories.size()]);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidJniFolderNode", "getDirectories"));
        }
        return psiDirectoryArray;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/navigator/nodes/AndroidJniFolderNode", "contains"));
        }
        Collection<File> sourceFolders = this.getModel().getSelectedVariant().getSourceFolders();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (File folder : sourceFolders) {
            VirtualFile virtualFile = fileSystem.findFileByIoFile(folder);
            if (virtualFile == null || !VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    protected void update(PresentationData presentation) {
        presentation.addText(AndroidSourceType.CPP.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon = AndroidSourceType.CPP.getIcon();
        if (icon != null) {
            presentation.setIcon(icon);
        }
        presentation.setPresentableText(AndroidSourceType.CPP.getName());
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return AndroidSourceType.CPP.getName();
    }

    @Nullable
    public Comparable getSortKey() {
        return AndroidSourceType.CPP;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return AndroidSourceType.CPP;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AndroidJniFolderNode that = (AndroidJniFolderNode)o;
        return this.getValue() == that.getValue();
    }

    public int hashCode() {
        int result = super.hashCode();
        NdkModuleModel model = this.getModel();
        return 31 * result + model.hashCode();
    }

    @NotNull
    private NdkModuleModel getModel() {
        NdkModuleModel value = (NdkModuleModel)this.getValue();
        assert (value != null);
        NdkModuleModel ndkModuleModel = value;
        if (ndkModuleModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidJniFolderNode", "getModel"));
        }
        return ndkModuleModel;
    }
}

