/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.npw.deprecated.WrapArchiveWizardPath;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateModuleFromArchiveAction
extends WriteCommandAction<Object> {
    @NotNull
    private Project myProject;
    @Nullable
    private GradleSettingsFile mySettingsFile;
    @NotNull
    private String myGradlePath;
    @NotNull
    private File myArchivePath;
    private boolean myMove;
    @Nullable
    private Module myContainingModule;

    public CreateModuleFromArchiveAction(@NotNull Project project, @NotNull String gradlePath, @NotNull String archivePath, boolean move, @Nullable Module containingModule) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/npw/importing/CreateModuleFromArchiveAction", "<init>"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/npw/importing/CreateModuleFromArchiveAction", "<init>"));
        }
        if (archivePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "archivePath", "com/android/tools/idea/npw/importing/CreateModuleFromArchiveAction", "<init>"));
        }
        this(project, GradleSettingsFile.get(project), gradlePath, archivePath, move, containingModule);
    }

    private CreateModuleFromArchiveAction(@NotNull Project project, @Nullable GradleSettingsFile settingsFile, @NotNull String gradlePath, @NotNull String archivePath, boolean move, @Nullable Module containingModule) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/npw/importing/CreateModuleFromArchiveAction", "<init>"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/npw/importing/CreateModuleFromArchiveAction", "<init>"));
        }
        if (archivePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "archivePath", "com/android/tools/idea/npw/importing/CreateModuleFromArchiveAction", "<init>"));
        }
        super(project, String.format("create module %1$s", gradlePath), new PsiFile[]{settingsFile != null ? settingsFile.getPsiFile() : null});
        this.myProject = project;
        this.mySettingsFile = settingsFile;
        this.myGradlePath = gradlePath;
        this.myArchivePath = new File(archivePath);
        this.myMove = move;
        this.myContainingModule = containingModule;
    }

    protected static String getBuildGradleText(File jarName) {
        return String.format("configurations.maybeCreate(\"default\")\nartifacts.add(\"default\", file('%1$s'))", jarName.getName());
    }

    private void addDependency(@NotNull Module module, String gradlePath) throws IOException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/npw/importing/CreateModuleFromArchiveAction", "addDependency"));
        }
        GradleBuildFile buildFile = GradleBuildFile.get(module);
        if (buildFile == null) {
            throw new IOException("Missing build.gradle");
        }
        List<BuildFileStatement> dependencies = buildFile.getDependencies();
        ArrayList newDeps = Lists.newArrayListWithCapacity((int)(dependencies.size() + 1));
        File moduleRoot = VfsUtilCore.virtualToIoFile((VirtualFile)buildFile.getFile().getParent());
        for (BuildFileStatement dependency : dependencies) {
            Dependency newDep = this.filterDependencyStatement((Dependency)dependency, moduleRoot);
            if (newDep == null) continue;
            newDeps.add(newDep);
        }
        newDeps.add(new Dependency(Dependency.Scope.COMPILE, Dependency.Type.MODULE, gradlePath));
        buildFile.setValue(BuildFileKey.DEPENDENCIES, newDeps);
    }

    @Nullable
    private Dependency filterDependencyStatement(Dependency dependency, File moduleRoot) {
        Object rawArguments = dependency.data;
        if (dependency.type == Dependency.Type.FILES && rawArguments != null) {
            String[] stringArray;
            if (rawArguments instanceof String[]) {
                stringArray = (String[])rawArguments;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = rawArguments.toString();
            }
            String[] data = stringArray;
            ArrayList list = Lists.newArrayListWithCapacity((int)data.length);
            for (String jarFile : data) {
                File path = new File(jarFile);
                if (!path.isAbsolute()) {
                    path = new File(moduleRoot, jarFile);
                }
                if (FileUtil.filesEqual((File)path, (File)this.myArchivePath)) continue;
                list.add(jarFile);
            }
            if (list.isEmpty()) {
                return null;
            }
            if (list.size() == 1) {
                return new Dependency(dependency.scope, dependency.type, list.get(0));
            }
            return new Dependency(dependency.scope, dependency.type, Iterables.toArray((Iterable)list, String.class));
        }
        return dependency;
    }

    protected void run(@NotNull Result<Object> result) throws Throwable {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/npw/importing/CreateModuleFromArchiveAction", "run"));
        }
        File moduleLocation = GradleUtil.getModuleDefaultPath(this.myProject.getBaseDir(), this.myGradlePath);
        try {
            VirtualFile moduleRoot = VfsUtil.createDirectoryIfMissing((String)moduleLocation.getAbsolutePath());
            VirtualFile sourceFile = VfsUtil.findFileByIoFile((File)this.myArchivePath, (boolean)true);
            if (sourceFile != null && moduleRoot != null) {
                if (this.myMove) {
                    sourceFile.move((Object)this, moduleRoot);
                } else {
                    VfsUtil.copy((Object)((Object)this), (VirtualFile)sourceFile, (VirtualFile)moduleRoot);
                }
                VirtualFile buildGradle = moduleRoot.createChildData((Object)this, "build.gradle");
                VfsUtil.saveText((VirtualFile)buildGradle, (String)CreateModuleFromArchiveAction.getBuildGradleText(this.myArchivePath));
                if (this.mySettingsFile == null) {
                    this.mySettingsFile = GradleSettingsFile.getOrCreate(this.myProject);
                }
                this.mySettingsFile.addModule(this.myGradlePath, VfsUtilCore.virtualToIoFile((VirtualFile)moduleRoot));
                if (this.myMove && this.myContainingModule != null) {
                    this.addDependency(this.myContainingModule, this.myGradlePath);
                }
            }
        }
        catch (IOException e) {
            Logger.getInstance(WrapArchiveWizardPath.class).error((Throwable)e);
        }
    }

    protected boolean isGlobalUndoAction() {
        return true;
    }

    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
    }
}

