/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module;

import com.android.tools.idea.npw.WizardUtils;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.expressions.Expression;
import com.intellij.openapi.project.Project;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppNameToModuleNameExpression
extends Expression<String> {
    @Nullable
    private final Project myProject;
    @NotNull
    private final StringProperty myApplicationName;

    public AppNameToModuleNameExpression(@Nullable Project project, @NotNull StringProperty applicationName) {
        if (applicationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationName", "com/android/tools/idea/npw/module/AppNameToModuleNameExpression", "<init>"));
        }
        super(applicationName);
        this.myProject = project;
        this.myApplicationName = applicationName;
    }

    @Override
    @NotNull
    public String get() {
        String moduleName = ((String)this.myApplicationName.get()).toLowerCase(Locale.US).replaceAll("\\s", "");
        int i = 2;
        String uniqueModuleName = moduleName;
        while (!WizardUtils.isUniqueModuleName(uniqueModuleName, this.myProject)) {
            uniqueModuleName = moduleName + Integer.toString(i);
            ++i;
        }
        String string = uniqueModuleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/module/AppNameToModuleNameExpression", "get"));
        }
        return string;
    }
}

