/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module;

import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.OptionalProperty;
import com.android.tools.idea.ui.properties.core.OptionalValueProperty;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public final class NewModuleModel
extends WizardModel {
    private final StringProperty myApplicationName;
    private final StringProperty myModuleName;
    private final BoolProperty myIsLibrary;
    private final BoolProperty myInstAppEnabled;
    private final OptionalProperty<File> myTemplateFile;
    private final OptionalProperty<Map<String, Object>> myRenderTemplateValues;
    private final Map<String, Object> myTemplateValues;
    @NotNull
    private final StringProperty myPackageName;
    @NotNull
    private final OptionalProperty<Project> myProject;

    public NewModuleModel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/npw/module/NewModuleModel", "<init>"));
        }
        this.myApplicationName = new StringValueProperty();
        this.myModuleName = new StringValueProperty();
        this.myIsLibrary = new BoolValueProperty();
        this.myInstAppEnabled = new BoolValueProperty();
        this.myTemplateFile = new OptionalValueProperty<File>();
        this.myRenderTemplateValues = new OptionalValueProperty<Map<String, Object>>();
        this.myTemplateValues = Maps.newHashMap();
        this.myApplicationName.set(AndroidBundle.message("android.wizard.module.config.new.application", new Object[0]));
        this.myIsLibrary.addListener(sender -> this.myApplicationName.set(AndroidBundle.message((Boolean)this.myIsLibrary.get() != false ? "android.wizard.module.config.new.library" : "android.wizard.module.config.new.application", new Object[0])));
        this.myApplicationName.addConstraint(String::trim);
        this.myModuleName.addConstraint(String::trim);
        this.myProject = new OptionalValueProperty<Project>(project);
        this.myPackageName = new StringValueProperty();
    }

    public NewModuleModel(@NotNull OptionalProperty<Project> project, @NotNull StringProperty packageName, @NotNull File templateFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/npw/module/NewModuleModel", "<init>"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/android/tools/idea/npw/module/NewModuleModel", "<init>"));
        }
        if (templateFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateFile", "com/android/tools/idea/npw/module/NewModuleModel", "<init>"));
        }
        this.myApplicationName = new StringValueProperty();
        this.myModuleName = new StringValueProperty();
        this.myIsLibrary = new BoolValueProperty();
        this.myInstAppEnabled = new BoolValueProperty();
        this.myTemplateFile = new OptionalValueProperty<File>();
        this.myRenderTemplateValues = new OptionalValueProperty<Map<String, Object>>();
        this.myTemplateValues = Maps.newHashMap();
        this.myApplicationName.set(AndroidBundle.message("android.wizard.module.config.new.application", new Object[0]));
        this.myIsLibrary.addListener(sender -> this.myApplicationName.set(AndroidBundle.message((Boolean)this.myIsLibrary.get() != false ? "android.wizard.module.config.new.library" : "android.wizard.module.config.new.application", new Object[0])));
        this.myApplicationName.addConstraint(String::trim);
        this.myModuleName.addConstraint(String::trim);
        this.myProject = project;
        this.myPackageName = packageName;
        this.myTemplateFile.setValue(templateFile);
    }

    @NotNull
    public OptionalProperty<Project> getProject() {
        OptionalProperty<Project> optionalProperty = this.myProject;
        if (optionalProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/module/NewModuleModel", "getProject"));
        }
        return optionalProperty;
    }

    @NotNull
    public StringProperty applicationName() {
        StringProperty stringProperty = this.myApplicationName;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/module/NewModuleModel", "applicationName"));
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty moduleName() {
        StringProperty stringProperty = this.myModuleName;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/module/NewModuleModel", "moduleName"));
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty packageName() {
        StringProperty stringProperty = this.myPackageName;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/module/NewModuleModel", "packageName"));
        }
        return stringProperty;
    }

    @NotNull
    public BoolProperty isLibrary() {
        BoolProperty boolProperty = this.myIsLibrary;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/module/NewModuleModel", "isLibrary"));
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty isInstAppEnabled() {
        BoolProperty boolProperty = this.myInstAppEnabled;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/module/NewModuleModel", "isInstAppEnabled"));
        }
        return boolProperty;
    }

    @NotNull
    public OptionalProperty<File> templateFile() {
        OptionalProperty<File> optionalProperty = this.myTemplateFile;
        if (optionalProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/module/NewModuleModel", "templateFile"));
        }
        return optionalProperty;
    }

    @NotNull
    public Map<String, Object> getTemplateValues() {
        Map<String, Object> map = this.myTemplateValues;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/module/NewModuleModel", "getTemplateValues"));
        }
        return map;
    }

    @NotNull
    public OptionalProperty<Map<String, Object>> getRenderTemplateValues() {
        OptionalProperty<Map<String, Object>> optionalProperty = this.myRenderTemplateValues;
        if (optionalProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/module/NewModuleModel", "getRenderTemplateValues"));
        }
        return optionalProperty;
    }

    @Override
    protected void handleFinished() {
        if (this.myTemplateFile.getValueOrNull() == null) {
            return;
        }
        if (!((Optional)this.myProject.get()).isPresent()) {
            NewModuleModel.getLog().error("NewModuleModel did not collect expected information and will not complete. Please report this error.");
            return;
        }
        Map<String, Object> renderTemplateValues = this.myRenderTemplateValues.getValueOrNull();
        final HashMap<String, Object> templateValues = new HashMap<String, Object>();
        if (renderTemplateValues != null) {
            templateValues.putAll(renderTemplateValues);
        }
        templateValues.putAll(this.myTemplateValues);
        templateValues.put("isLibraryProject", this.myIsLibrary.get());
        final Project project = this.myProject.getValue();
        boolean canRender = this.renderModule(true, templateValues, project);
        if (!canRender) {
            return;
        }
        boolean success = (Boolean)new WriteCommandAction<Boolean>(project, "New Module", new PsiFile[0]){

            protected void run(@NotNull Result<Boolean> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/npw/module/NewModuleModel$1", "run"));
                }
                boolean success = NewModuleModel.this.renderModule(false, templateValues, project);
                result.setResult((Object)success);
            }
        }.execute().getResultObject();
        if (!success) {
            NewModuleModel.getLog().warn("A problem occurred while creating a new Module. Please check the log file for possible errors.");
        }
    }

    private boolean renderModule(boolean dryRun, @NotNull Map<String, Object> templateState, @NotNull Project project) {
        if (templateState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateState", "com/android/tools/idea/npw/module/NewModuleModel", "renderModule"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/npw/module/NewModuleModel", "renderModule"));
        }
        File projectRoot = new File(project.getBasePath());
        File moduleRoot = new File(projectRoot, (String)this.myModuleName.get());
        Template template = Template.createFromPath(this.myTemplateFile.getValue());
        RenderingContext context = RenderingContext.Builder.newContext(template, project).withCommandName("New Module").withDryRun(dryRun).withShowErrors(true).withOutputRoot(projectRoot).withModuleRoot(moduleRoot).withParams(templateState).build();
        return template.render(context);
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(NewModuleModel.class);
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/module/NewModuleModel", "getLog"));
        }
        return logger;
    }
}

