/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.builder.model.SourceProvider;
import com.google.common.collect.Iterables;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public final class AndroidProjectPaths {
    @Nullable
    private File myModuleRoot;
    @Nullable
    private File mySrcDirectory;
    @Nullable
    private File myTestDirectory;
    @Nullable
    private File myResDirectory;
    @Nullable
    private File myAidlDirectory;
    @Nullable
    private File myManifestDirectory;

    @NotNull
    static List<SourceProvider> getSourceProviders(@NotNull AndroidFacet androidFacet, @Nullable VirtualFile targetDirectory) {
        if (androidFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidFacet", "com/android/tools/idea/npw/project/AndroidProjectPaths", "getSourceProviders"));
        }
        if (targetDirectory != null) {
            List<SourceProvider> list = IdeaSourceProvider.getSourceProvidersForFile(androidFacet, targetDirectory, androidFacet.getMainSourceProvider());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/AndroidProjectPaths", "getSourceProviders"));
            }
            return list;
        }
        List<SourceProvider> list = IdeaSourceProvider.getAllSourceProviders(androidFacet);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/AndroidProjectPaths", "getSourceProviders"));
        }
        return list;
    }

    public AndroidProjectPaths(@NotNull File moduleRoot) {
        if (moduleRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRoot", "com/android/tools/idea/npw/project/AndroidProjectPaths", "<init>"));
        }
        this.myModuleRoot = moduleRoot;
        File baseSrcDir = new File(moduleRoot, "src");
        File baseFlavourDir = new File(baseSrcDir, "main");
        this.mySrcDirectory = new File(baseFlavourDir, "java");
        this.myTestDirectory = Paths.get(baseSrcDir.getPath(), "androidTest", "java").toFile();
        this.myResDirectory = new File(baseFlavourDir, "res");
        this.myAidlDirectory = new File(baseFlavourDir, "aidl");
        this.myManifestDirectory = baseFlavourDir;
    }

    public AndroidProjectPaths(@NotNull AndroidFacet androidFacet) {
        if (androidFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidFacet", "com/android/tools/idea/npw/project/AndroidProjectPaths", "<init>"));
        }
        this(androidFacet, AndroidProjectPaths.getSourceProviders(androidFacet, null).get(0));
    }

    public AndroidProjectPaths(@NotNull AndroidFacet androidFacet, @NotNull SourceProvider sourceProvider) {
        List testsRoot;
        if (androidFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidFacet", "com/android/tools/idea/npw/project/AndroidProjectPaths", "<init>"));
        }
        if (sourceProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProvider", "com/android/tools/idea/npw/project/AndroidProjectPaths", "<init>"));
        }
        this.init(sourceProvider);
        Module module = androidFacet.getModule();
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (roots.length > 0) {
            this.myModuleRoot = VfsUtilCore.virtualToIoFile((VirtualFile)roots[0]);
        }
        this.myTestDirectory = (testsRoot = ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.TESTS)).size() == 0 ? null : VfsUtilCore.virtualToIoFile((VirtualFile)((VirtualFile)testsRoot.get(0)));
    }

    public AndroidProjectPaths(@NotNull File moduleRoot, @NotNull File testDirectory, @NotNull SourceProvider sourceProvider) {
        if (moduleRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRoot", "com/android/tools/idea/npw/project/AndroidProjectPaths", "<init>"));
        }
        if (testDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testDirectory", "com/android/tools/idea/npw/project/AndroidProjectPaths", "<init>"));
        }
        if (sourceProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProvider", "com/android/tools/idea/npw/project/AndroidProjectPaths", "<init>"));
        }
        this.init(sourceProvider);
        this.myModuleRoot = moduleRoot;
        this.myTestDirectory = testDirectory;
    }

    private void init(@NotNull SourceProvider sourceProvider) {
        Collection aidlDirectories;
        if (sourceProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProvider", "com/android/tools/idea/npw/project/AndroidProjectPaths", "init"));
        }
        this.mySrcDirectory = (File)Iterables.getFirst((Iterable)sourceProvider.getJavaDirectories(), null);
        Collection resDirectories = sourceProvider.getResDirectories();
        if (!resDirectories.isEmpty()) {
            this.myResDirectory = (File)resDirectories.iterator().next();
        }
        if (!(aidlDirectories = sourceProvider.getAidlDirectories()).isEmpty()) {
            this.myAidlDirectory = (File)aidlDirectories.iterator().next();
        }
        this.myManifestDirectory = sourceProvider.getManifestFile().getParentFile();
    }

    @Nullable
    public File getModuleRoot() {
        return this.myModuleRoot;
    }

    @Nullable
    public File getSrcDirectory() {
        return this.mySrcDirectory;
    }

    @Nullable
    public File getTestDirectory() {
        return this.myTestDirectory;
    }

    @Nullable
    public File getResDirectory() {
        return this.myResDirectory;
    }

    @Nullable
    public File getAidlDirectory() {
        return this.myAidlDirectory;
    }

    @Nullable
    public File getManifestDirectory() {
        return this.myManifestDirectory;
    }
}

