/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.DeclareStyleableResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.res.AppResourceRepository;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class ResourceClassGenerator {
    private static final Logger LOG = Logger.getInstance(ResourceClassGenerator.class);
    private Map<ResourceType, TObjectIntHashMap<String>> myCache;
    private Map<String, List<Integer>> myStyleableCache;
    @NotNull
    private final AppResourceRepository myAppResources;

    private ResourceClassGenerator(@NotNull AppResourceRepository appResources) {
        if (appResources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appResources", "com/android/tools/idea/res/ResourceClassGenerator", "<init>"));
        }
        this.myAppResources = appResources;
    }

    @NotNull
    public static ResourceClassGenerator create(@NotNull AppResourceRepository appResources) {
        if (appResources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appResources", "com/android/tools/idea/res/ResourceClassGenerator", "create"));
        }
        ResourceClassGenerator resourceClassGenerator = new ResourceClassGenerator(appResources);
        if (resourceClassGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceClassGenerator", "create"));
        }
        return resourceClassGenerator;
    }

    @Nullable
    public byte[] generate(String fqcn) {
        String className = fqcn.replace('.', '/');
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("generate(%s)", LogAnonymizerUtil.anonymizeClassName(className)));
        }
        ClassWriter cw = new ClassWriter(0);
        cw.visit(50, 49, className, null, Type.getInternalName(Object.class), null);
        int index = className.lastIndexOf(36);
        if (index != -1) {
            String typeName = className.substring(index + 1);
            ResourceType type = ResourceType.getEnum((String)typeName);
            if (type == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("  type '%s' doesn't exist", typeName));
                }
                return null;
            }
            cw.visitInnerClass(className, className.substring(0, index), typeName, 25);
            if (this.myCache == null) {
                this.myCache = Maps.newHashMap();
            }
            if (type == ResourceType.STYLEABLE) {
                if (this.myStyleableCache == null) {
                    TObjectIntHashMap styleableIntCache = new TObjectIntHashMap();
                    this.myCache.put(type, (TObjectIntHashMap<String>)styleableIntCache);
                    this.myStyleableCache = Maps.newHashMap();
                    this.generateStyleable(cw, (TObjectIntHashMap<String>)styleableIntCache, className);
                } else {
                    TObjectIntHashMap<String> styleableIntCache = this.myCache.get(type);
                    assert (styleableIntCache != null);
                    ResourceClassGenerator.generateFields(cw, styleableIntCache);
                    ResourceClassGenerator.generateIntArrayFromCache(cw, className, this.myStyleableCache);
                }
            } else {
                TObjectIntHashMap typeCache = this.myCache.get(type);
                if (typeCache == null) {
                    typeCache = new TObjectIntHashMap();
                    this.myCache.put(type, (TObjectIntHashMap<String>)typeCache);
                    this.generateValuesForType(cw, type, (TObjectIntHashMap<String>)typeCache);
                } else {
                    ResourceClassGenerator.generateFields(cw, typeCache);
                }
            }
        } else {
            boolean styleableAdded = false;
            for (ResourceType t : this.myAppResources.getAvailableResourceTypes()) {
                if (t == ResourceType.DECLARE_STYLEABLE) {
                    t = ResourceType.STYLEABLE;
                }
                if (t == ResourceType.STYLEABLE) {
                    if (styleableAdded) continue;
                    styleableAdded = true;
                }
                cw.visitInnerClass(className + "$" + t.getName(), className, t.getName(), 25);
            }
        }
        ResourceClassGenerator.generateConstructor(cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void generateValuesForType(@NotNull ClassWriter cw, @NotNull ResourceType resType, @NotNull TObjectIntHashMap<String> cache) {
        if (cw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cw", "com/android/tools/idea/res/ResourceClassGenerator", "generateValuesForType"));
        }
        if (resType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resType", "com/android/tools/idea/res/ResourceClassGenerator", "generateValuesForType"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/android/tools/idea/res/ResourceClassGenerator", "generateValuesForType"));
        }
        Collection<String> keys = this.myAppResources.getItemsOfType(resType);
        for (String key : keys) {
            int initialValue = this.myAppResources.getResourceId(resType, key);
            key = AndroidResourceUtil.getFieldNameByResourceName(key);
            ResourceClassGenerator.generateField(cw, key, initialValue);
            cache.put((Object)key, initialValue);
        }
    }

    private void generateStyleable(@NotNull ClassWriter cw, @NotNull TObjectIntHashMap<String> styleableIntCache, String className) {
        List attributes;
        DeclareStyleableResourceValue dv;
        ResourceValue resourceValue;
        if (cw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cw", "com/android/tools/idea/res/ResourceClassGenerator", "generateStyleable"));
        }
        if (styleableIntCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleableIntCache", "com/android/tools/idea/res/ResourceClassGenerator", "generateStyleable"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("generateStyleable(%s)", LogAnonymizerUtil.anonymizeClassName(className)));
        }
        boolean debug = LOG.isDebugEnabled() && LogAnonymizerUtil.isPublicClass(className);
        Collection<String> declaredStyleables = this.myAppResources.getItemsOfType(ResourceType.DECLARE_STYLEABLE);
        for (String styleableName : declaredStyleables) {
            List items = this.myAppResources.getResourceItem(ResourceType.DECLARE_STYLEABLE, styleableName);
            if (items == null || items.isEmpty()) {
                if (!debug) continue;
                LOG.debug("  No items for " + styleableName);
                continue;
            }
            String fieldName = AndroidResourceUtil.getFieldNameByResourceName(styleableName);
            cw.visitField(25, fieldName, "[I", null, null);
            if (debug) {
                LOG.debug("  Defined styleable " + fieldName);
            }
            resourceValue = ((ResourceItem)items.get(0)).getResourceValue(false);
            assert (resourceValue instanceof DeclareStyleableResourceValue);
            dv = (DeclareStyleableResourceValue)resourceValue;
            attributes = dv.getAllAttributes();
            int idx = 0;
            for (AttrResourceValue value : attributes) {
                Integer initialValue = idx++;
                String styleableEntryName = ResourceClassGenerator.getResourceName(fieldName, value);
                cw.visitField(25, styleableEntryName, "I", null, (Object)initialValue);
                styleableIntCache.put((Object)styleableEntryName, initialValue.intValue());
                if (!debug) continue;
                LOG.debug("  Defined styleable " + styleableEntryName);
            }
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        for (String styleableName : declaredStyleables) {
            List items = this.myAppResources.getResourceItem(ResourceType.DECLARE_STYLEABLE, styleableName);
            if (items == null || items.isEmpty()) continue;
            resourceValue = ((ResourceItem)items.get(0)).getResourceValue(false);
            assert (resourceValue instanceof DeclareStyleableResourceValue);
            dv = (DeclareStyleableResourceValue)resourceValue;
            attributes = dv.getAllAttributes();
            if (attributes.isEmpty()) continue;
            Integer[] valuesArray = this.myAppResources.getDeclaredArrayValues(attributes, styleableName);
            if (valuesArray == null) {
                valuesArray = new Integer[attributes.size()];
            }
            List<Integer> values = Arrays.asList(valuesArray);
            String fieldName = AndroidResourceUtil.getFieldNameByResourceName(styleableName);
            this.myStyleableCache.put(fieldName, values);
            int idx = -1;
            for (AttrResourceValue value : attributes) {
                if (valuesArray[++idx] != null && value.isFramework()) continue;
                valuesArray[idx] = this.myAppResources.getResourceId(ResourceType.ATTR, value.getName());
            }
            ResourceClassGenerator.generateArrayInitialization(mv, className, fieldName, values);
        }
        mv.visitInsn(177);
        mv.visitMaxs(4, 0);
        mv.visitEnd();
    }

    private static void generateFields(final @NotNull ClassWriter cw, @NotNull TObjectIntHashMap<String> values) {
        if (cw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cw", "com/android/tools/idea/res/ResourceClassGenerator", "generateFields"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/android/tools/idea/res/ResourceClassGenerator", "generateFields"));
        }
        values.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

            public boolean execute(String name, int value) {
                ResourceClassGenerator.generateField(cw, name, value);
                return true;
            }
        });
    }

    private static void generateField(@NotNull ClassWriter cw, String name, int value) {
        if (cw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cw", "com/android/tools/idea/res/ResourceClassGenerator", "generateField"));
        }
        cw.visitField(25, name, "I", null, (Object)value).visitEnd();
    }

    private static void generateIntArrayFromCache(@NotNull ClassWriter cw, String className, Map<String, List<Integer>> styleableCache) {
        if (cw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cw", "com/android/tools/idea/res/ResourceClassGenerator", "generateIntArrayFromCache"));
        }
        for (String name : styleableCache.keySet()) {
            cw.visitField(25, name, "[I", null, null);
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        for (Map.Entry<String, List<Integer>> entry : styleableCache.entrySet()) {
            List<Integer> values = entry.getValue();
            if (values.isEmpty()) continue;
            ResourceClassGenerator.generateArrayInitialization(mv, className, entry.getKey(), values);
        }
        mv.visitInsn(177);
        mv.visitMaxs(4, 0);
        mv.visitEnd();
    }

    private static void generateArrayInitialization(@NotNull MethodVisitor mv, String className, String fieldName, @NotNull List<Integer> values) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "com/android/tools/idea/res/ResourceClassGenerator", "generateArrayInitialization"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/android/tools/idea/res/ResourceClassGenerator", "generateArrayInitialization"));
        }
        if (values.isEmpty()) {
            return;
        }
        mv.visitIntInsn(16, values.size());
        mv.visitIntInsn(188, 10);
        int idx = 0;
        for (Integer value : values) {
            mv.visitInsn(89);
            switch (idx) {
                case 0: {
                    mv.visitInsn(3);
                    break;
                }
                case 1: {
                    mv.visitInsn(4);
                    break;
                }
                case 2: {
                    mv.visitInsn(5);
                    break;
                }
                case 3: {
                    mv.visitInsn(6);
                    break;
                }
                case 4: {
                    mv.visitInsn(7);
                    break;
                }
                case 5: {
                    mv.visitInsn(8);
                    break;
                }
                default: {
                    mv.visitIntInsn(16, idx);
                }
            }
            mv.visitLdcInsn((Object)value);
            mv.visitInsn(79);
            ++idx;
        }
        mv.visitFieldInsn(179, className, fieldName, "[I");
    }

    private static void generateConstructor(@NotNull ClassWriter cw) {
        if (cw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cw", "com/android/tools/idea/res/ResourceClassGenerator", "generateConstructor"));
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public static String getResourceName(String styleableName, @NotNull AttrResourceValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/res/ResourceClassGenerator", "getResourceName"));
        }
        StringBuilder sb = new StringBuilder(30);
        sb.append(styleableName);
        sb.append('_');
        if (value.isFramework()) {
            sb.append("android_");
        }
        String v = value.getName();
        int n = v.length();
        for (int i = 0; i < n; ++i) {
            char c = v.charAt(i);
            if (c == '.' || c == ':' || c == '-') {
                sb.append('_');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

