/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeviceFutures {
    @NotNull
    private final List<AndroidDevice> myDevices;

    public DeviceFutures(@NotNull List<AndroidDevice> devices) {
        if (devices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "devices", "com/android/tools/idea/run/DeviceFutures", "<init>"));
        }
        this.myDevices = devices;
    }

    @NotNull
    public List<ListenableFuture<IDevice>> get() {
        ImmutableList.Builder futures = ImmutableList.builder();
        for (AndroidDevice device : this.myDevices) {
            futures.add(device.getLaunchedDevice());
        }
        ImmutableList immutableList = futures.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceFutures", "get"));
        }
        return immutableList;
    }

    @Nullable
    public List<IDevice> getIfReady() {
        List<ListenableFuture<IDevice>> devices = this.get();
        for (ListenableFuture<IDevice> deviceFuture : devices) {
            if (deviceFuture.isDone() && !deviceFuture.isCancelled()) continue;
            return null;
        }
        try {
            return (List)Futures.getChecked((Future)Futures.allAsList(devices), ExecutionException.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public List<AndroidDevice> getDevices() {
        List<AndroidDevice> list = this.myDevices;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceFutures", "getDevices"));
        }
        return list;
    }

    @NotNull
    public static DeviceFutures forDevices(@NotNull Iterable<IDevice> devices) {
        if (devices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "devices", "com/android/tools/idea/run/DeviceFutures", "forDevices"));
        }
        ImmutableList.Builder futures = ImmutableList.builder();
        for (IDevice device : devices) {
            futures.add((Object)new ConnectedAndroidDevice(device, null));
        }
        DeviceFutures deviceFutures = new DeviceFutures((List<AndroidDevice>)futures.build());
        if (deviceFutures == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceFutures", "forDevices"));
        }
        return deviceFutures;
    }
}

