/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.run.AndroidDebugState;
import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.run.AndroidRemoteDebugProcessHandler;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.tasks.ConnectDebuggerTask;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.intellij.debugger.ui.DebuggerPanelsManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ConnectJavaDebuggerTask
extends ConnectDebuggerTask {
    public ConnectJavaDebuggerTask(@NotNull Set<String> applicationIds, @NotNull AndroidDebugger debugger, @NotNull Project project, boolean monitorRemoteProcess) {
        if (applicationIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationIds", "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask", "<init>"));
        }
        if (debugger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugger", "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask", "<init>"));
        }
        super(applicationIds, debugger, project, monitorRemoteProcess);
    }

    @Override
    public ProcessHandler launchDebugger(@NotNull LaunchInfo currentLaunchInfo, @NotNull Client client, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ProcessHandlerConsolePrinter printer) {
        RunProfile runProfile;
        RunContentDescriptor debugDescriptor;
        if (currentLaunchInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentLaunchInfo", "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask", "launchDebugger"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask", "launchDebugger"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask", "launchDebugger"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask", "launchDebugger"));
        }
        String debugPort = Integer.toString(client.getDebuggerListenPort());
        final int pid = client.getClientData().getPid();
        Logger.getInstance(ConnectJavaDebuggerTask.class).info(String.format(Locale.US, "Attempting to connect debugger to port %1$s [client %2$d]", debugPort, pid));
        RunContentDescriptor descriptor = currentLaunchInfo.env.getContentToReuse();
        assert (descriptor != null) : "ConnectJavaDebuggerTask expects an existing descriptor that will be reused";
        ProcessHandler processHandler = descriptor.getProcessHandler();
        assert (processHandler != null);
        RemoteConnection connection = new RemoteConnection(true, "localhost", debugPort, false);
        final AndroidRemoteDebugProcessHandler debugProcessHandler = new AndroidRemoteDebugProcessHandler(this.myProject, this.myMonitorRemoteProcess);
        launchStatus.setProcessHandler(debugProcessHandler);
        printer.setProcessHandler(debugProcessHandler);
        processHandler.detachProcess();
        AndroidDebugState debugState = new AndroidDebugState(this.myProject, debugProcessHandler, connection, currentLaunchInfo.consoleProvider);
        try {
            ExecutionEnvironment debugEnv = new ExecutionEnvironmentBuilder(currentLaunchInfo.env).executor(currentLaunchInfo.executor).runner(currentLaunchInfo.runner).contentToReuse(descriptor).build();
            debugDescriptor = DebuggerPanelsManager.getInstance((Project)this.myProject).attachVirtualMachine(debugEnv, (RunProfileState)debugState, connection, false);
        }
        catch (ExecutionException e) {
            processHandler.notifyTextAvailable("ExecutionException: " + e.getMessage() + '.', ProcessOutputTypes.STDERR);
            return null;
        }
        if (debugDescriptor == null) {
            processHandler.notifyTextAvailable("Unable to connect debugger to Android application", ProcessOutputTypes.STDERR);
            return null;
        }
        AndroidProcessText oldText = AndroidProcessText.get(processHandler);
        if (oldText != null) {
            oldText.printTo(debugProcessHandler);
        }
        int uniqueId = (runProfile = currentLaunchInfo.env.getRunProfile()) instanceof RunConfigurationBase ? ((RunConfigurationBase)runProfile).getUniqueID() : -1;
        AndroidSessionInfo value = new AndroidSessionInfo(debugProcessHandler, debugDescriptor, uniqueId, currentLaunchInfo.executor.getId(), InstantRunUtils.isInstantRunEnabled(currentLaunchInfo.env));
        debugProcessHandler.putUserData(AndroidSessionInfo.KEY, value);
        debugProcessHandler.putUserData(AndroidSessionInfo.ANDROID_DEBUG_CLIENT, client);
        debugProcessHandler.putUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL, client.getDevice().getVersion());
        final String pkgName = client.getClientData().getClientDescription();
        final IDevice device = client.getDevice();
        debugProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                debugProcessHandler.removeProcessListener((ProcessListener)this);
                Client currentClient = device.getClient(pkgName);
                if (currentClient != null && currentClient.getClientData().getPid() != pid) {
                    return;
                }
                Logger.getInstance(ConnectJavaDebuggerTask.class).info("Debugger terminating, so terminating process: " + pkgName);
                try {
                    device.executeShellCommand("am force-stop " + pkgName, (IShellOutputReceiver)new NullOutputReceiver());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return debugProcessHandler;
    }
}

