/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class DeployIapkTask
implements LaunchTask {
    @NotNull
    private final Collection<ApkInfo> myApks;

    public DeployIapkTask(@NotNull Collection<ApkInfo> apks) {
        if (apks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apks", "com/android/tools/idea/run/tasks/DeployIapkTask", "<init>"));
        }
        this.myApks = apks;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Uploading and registering IAPK" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/tasks/DeployIapkTask", "getDescription"));
        }
        return "Uploading and registering IAPK";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/tasks/DeployIapkTask", "perform"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/tasks/DeployIapkTask", "perform"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/tasks/DeployIapkTask", "perform"));
        }
        if (!this.myApks.iterator().hasNext()) {
            printer.stderr("No Iapk provided.");
            return false;
        }
        ApkInfo iapk = this.myApks.iterator().next();
        File localFile = iapk.getFile();
        if (!localFile.exists()) {
            String message = "The APK file " + localFile.getPath() + " does not exist on disk.";
            printer.stderr(message);
            return false;
        }
        String remotePath = "/sdcard/instantapps/" + localFile.getName();
        printer.stdout("$ adb push " + localFile + " " + remotePath);
        try {
            device.pushFile(localFile.getPath(), remotePath);
            CountDownLatch latch = new CountDownLatch(3);
            CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
            printer.stdout("Starting / refreshing Instant App services");
            device.executeShellCommand("am startservice -a \"com.google.android.instantapps.devman.iapk.LOAD\" --es \"com.google.android.instantapps.devman.iapk.IAPK_PATH\" \"" + remotePath + "\" -n \"com.google.android.instantapps.devman\"/.iapk.IapkLoadService", (IShellOutputReceiver)receiver);
            device.executeShellCommand("pm clear com.google.android.instantapps.supervisor", (IShellOutputReceiver)receiver);
            device.executeShellCommand("am force-stop com.google.android.instantapps.supervisor", (IShellOutputReceiver)receiver);
            latch.await(3000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            printer.stderr(e.toString());
            return false;
        }
        printer.stdout("IAPK upload complete");
        return true;
    }
}

