/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard.legacy;

import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.InstallerFactory;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.repository.util.InstallerUtil;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.sdklib.repository.legacy.descriptors.IPkgDesc;
import com.android.sdklib.repository.legacy.descriptors.PkgType;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SdkLoggerIntegration;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.install.StudioSdkInstallerUtil;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithDescription;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmwOldApiDirectInstall
extends DynamicWizardStepWithDescription {
    private JBLabel myLabelSdkPath;
    private JTextArea mySdkManagerOutput;
    private JBLabel myLabelProgress1;
    private JProgressBar myProgressBar;
    private JBLabel myLabelProgress2;
    private JLabel myErrorLabel;
    private JPanel myContentPanel;
    private boolean myInstallFinished;

    public SmwOldApiDirectInstall(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/android/tools/idea/sdk/wizard/legacy/SmwOldApiDirectInstall", "<init>"));
        }
        super(disposable);
        this.$$$setupUI$$$();
        this.setBodyComponent(this.myContentPanel);
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        this.mySdkManagerOutput.setText("");
        this.startSdkInstallUsingNonSwtOldApi();
    }

    @Override
    public boolean isStepVisible() {
        return this.myState.listSize(WizardConstants.INSTALL_REQUESTS_KEY) > 0;
    }

    @Override
    public boolean validate() {
        return this.myInstallFinished;
    }

    @Override
    public boolean canGoPrevious() {
        return this.myInstallFinished;
    }

    private void startSdkInstallUsingNonSwtOldApi() {
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        if (sdkHandler.getLocation() == null) {
            this.myErrorLabel.setText("Error: can't get SDK instance.");
            this.myErrorLabel.setIcon(AllIcons.General.BalloonError);
            return;
        }
        File androidSdkPath = IdeSdks.getInstance().getAndroidSdkPath();
        if (androidSdkPath != null && androidSdkPath.exists() && !androidSdkPath.canWrite()) {
            this.myErrorLabel.setText(String.format("SDK folder is read-only: '%1$s'", androidSdkPath.getPath()));
            this.myErrorLabel.setIcon(AllIcons.General.BalloonError);
            return;
        }
        this.myLabelSdkPath.setText(sdkHandler.getLocation().getPath());
        CustomLogger logger = new CustomLogger();
        StudioLoggerProgressIndicator repoProgress = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager.RepoLoadedCallback onComplete = arg_0 -> this.lambda$startSdkInstallUsingNonSwtOldApi$1((com.android.repository.api.ProgressIndicator)repoProgress, sdkHandler, logger, arg_0);
        StudioProgressRunner runner = new StudioProgressRunner(false, false, "Updating SDK", false, null);
        sdkHandler.getSdkManager((com.android.repository.api.ProgressIndicator)repoProgress).load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, (List)ImmutableList.of((Object)onComplete), null, (ProgressRunner)runner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("InstallingSDKComponentsStep" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/legacy/SmwOldApiDirectInstall", "getStepName"));
        }
        return "InstallingSDKComponentsStep";
    }

    @Override
    @NotNull
    protected String getStepTitle() {
        if ("Installing Requested Components" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/legacy/SmwOldApiDirectInstall", "getStepTitle"));
        }
        return "Installing Requested Components";
    }

    @Override
    @Nullable
    protected String getStepDescription() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    private void checkForUpgrades(@Nullable List completedChanges) {
        if (completedChanges == null) {
            return;
        }
        int highestNewApiLevel = 0;
        for (Object o : completedChanges) {
            AndroidVersion version;
            IPkgDesc pkgDesc;
            if (!(o instanceof IPkgDesc) || !(pkgDesc = (IPkgDesc)o).getType().equals((Object)PkgType.PKG_PLATFORM) || (version = pkgDesc.getAndroidVersion()) == null || version.getApiLevel() <= highestNewApiLevel) continue;
            highestNewApiLevel = version.getApiLevel();
        }
        if (highestNewApiLevel > 0) {
            this.myState.put(WizardConstants.NEWLY_INSTALLED_API_KEY, highestNewApiLevel);
        }
    }

    private /* synthetic */ void lambda$startSdkInstallUsingNonSwtOldApi$1(com.android.repository.api.ProgressIndicator repoProgress, AndroidSdkHandler sdkHandler, CustomLogger logger, RepositoryPackages packages) {
        UIUtil.invokeLaterIfNeeded(() -> {
            List<String> requestedChanges = this.myState.get(WizardConstants.INSTALL_REQUESTS_KEY);
            if (requestedChanges == null) {
                assert (false) : "Shouldn't be in installer with no requests";
                this.myInstallFinished = true;
                this.invokeUpdate(null);
                return;
            }
            Map remotes = packages.getRemotePackages();
            List<RemotePackage> requestedPackages = Lists.newArrayList();
            boolean notFound = false;
            for (String path : requestedChanges) {
                RemotePackage remotePackage = (RemotePackage)remotes.get(path);
                if (remotePackage != null) {
                    requestedPackages.add(remotePackage);
                    continue;
                }
                notFound = true;
            }
            if (requestedPackages.isEmpty()) {
                this.myInstallFinished = true;
                this.invokeUpdate(null);
            } else if ((requestedPackages = InstallerUtil.computeRequiredPackages((Collection)requestedPackages, (RepositoryPackages)packages, (com.android.repository.api.ProgressIndicator)repoProgress)) == null) {
                notFound = true;
            } else {
                InstallTask task = new InstallTask(sdkHandler, requestedPackages, (ILogger)logger);
                BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator((Task.Backgroundable)task);
                logger.setIndicator(indicator);
                ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, (ProgressIndicator)indicator);
            }
            if (notFound) {
                this.myErrorLabel.setText("Problem: Some required packages could not be installed. Check internet connection.");
                this.myErrorLabel.setIcon(AllIcons.General.BalloonError);
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JLabel jLabel;
        JBLabel jBLabel;
        JProgressBar jProgressBar;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("SDK Path:");
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myLabelSdkPath = jBLabel3 = new JBLabel();
        jBLabel3.setText("<placeholder path>");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myLabelProgress1 = jBLabel2 = new JBLabel();
        jBLabel2.setText("");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jPanel.add((Component)jProgressBar, new GridConstraints(3, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        this.myLabelProgress2 = jBLabel = new JBLabel();
        jBLabel.setHorizontalTextPosition(10);
        jBLabel.setBackground(new Color(-3355444));
        jBLabel.setText("");
        jBLabel.setVerticalAlignment(1);
        jPanel.add((Component)jBLabel, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 2, null, null, null));
        this.myErrorLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(5, 0, 1, 2, 0, 1, 2, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setVerticalScrollBarPolicy(22);
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        this.mySdkManagerOutput = jTextArea = new JTextArea();
        jTextArea.setText("");
        jBScrollPane.setViewportView(jTextArea);
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private final class CustomLogger
    extends SdkLoggerIntegration {
        private CustomLogger() {
        }

        @Override
        protected void setProgress(int progress) {
            SmwOldApiDirectInstall.this.myProgressBar.setValue(progress);
        }

        @Override
        protected void setDescription(String description) {
            SmwOldApiDirectInstall.this.myLabelProgress2.setText(description);
        }

        @Override
        protected void setTitle(String title) {
            SmwOldApiDirectInstall.this.myLabelProgress1.setText(title);
        }

        @Override
        protected void lineAdded(String string) {
            String current = SmwOldApiDirectInstall.this.mySdkManagerOutput.getText();
            if (current == null) {
                current = "";
            }
            SmwOldApiDirectInstall.this.mySdkManagerOutput.setText(current + "\n" + string);
        }
    }

    private class InstallTask
    extends Task.Backgroundable {
        @NotNull
        private final AndroidSdkHandler mySdkHandler;
        @NotNull
        private final List<RemotePackage> myRequestedPackages;
        @NotNull
        private final ILogger myLogger;

        private InstallTask(@NotNull AndroidSdkHandler sdkHandler, @NotNull List<RemotePackage> requestedPackages, ILogger logger) {
            if (sdkHandler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHandler", "com/android/tools/idea/sdk/wizard/legacy/SmwOldApiDirectInstall$InstallTask", "<init>"));
            }
            if (requestedPackages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestedPackages", "com/android/tools/idea/sdk/wizard/legacy/SmwOldApiDirectInstall$InstallTask", "<init>"));
            }
            if (logger == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/sdk/wizard/legacy/SmwOldApiDirectInstall$InstallTask", "<init>"));
            }
            super(null, "Installing Android SDK", false, PerformInBackgroundOption.ALWAYS_BACKGROUND);
            this.mySdkHandler = sdkHandler;
            this.myRequestedPackages = requestedPackages;
            this.myLogger = logger;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/sdk/wizard/legacy/SmwOldApiDirectInstall$InstallTask", "run"));
            }
            LoggerProgressIndicatorWrapper repoProgress = new LoggerProgressIndicatorWrapper(this.myLogger);
            RepoManager sdkManager = this.mySdkHandler.getSdkManager((com.android.repository.api.ProgressIndicator)repoProgress);
            InstallerFactory factory = StudioSdkInstallerUtil.createInstallerFactory(this.mySdkHandler);
            for (RemotePackage p : this.myRequestedPackages) {
                FileOp fop;
                Installer installer = factory.createInstaller(p, sdkManager, (Downloader)new StudioDownloader(indicator), fop = FileOpUtils.create());
                if (!installer.prepare((com.android.repository.api.ProgressIndicator)repoProgress)) continue;
                installer.complete((com.android.repository.api.ProgressIndicator)repoProgress);
            }
            sdkManager.loadSynchronously(0L, (com.android.repository.api.ProgressIndicator)repoProgress, null, null);
            SmwOldApiDirectInstall.this.myState.remove(WizardConstants.INSTALL_REQUESTS_KEY);
            UIUtil.invokeLaterIfNeeded(() -> {
                SmwOldApiDirectInstall.this.myProgressBar.setValue(100);
                SmwOldApiDirectInstall.this.myLabelProgress1.setText("");
                SmwOldApiDirectInstall.this.myLabelProgress2.setText("Done");
                List<String> requestedChanges = SmwOldApiDirectInstall.this.myState.get(WizardConstants.INSTALL_REQUESTS_KEY);
                SmwOldApiDirectInstall.this.checkForUpgrades(requestedChanges);
                SmwOldApiDirectInstall.this.myState.remove(WizardConstants.INSTALL_REQUESTS_KEY);
                SmwOldApiDirectInstall.this.myInstallFinished = true;
                SmwOldApiDirectInstall.this.invokeUpdate(null);
                VirtualFile sdkDir = LocalFileSystem.getInstance().findFileByIoFile(this.mySdkHandler.getLocation());
                if (sdkDir != null) {
                    sdkDir.refresh(true, true);
                }
                sdkManager.markInvalid();
            });
        }
    }
}

