/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.junit;

import com.android.tools.idea.testartifacts.junit.AndroidJUnitConsoleProperties;
import com.android.tools.idea.testartifacts.junit.AndroidTestObject;
import com.android.tools.idea.testartifacts.junit.AndroidTestPackage;
import com.android.tools.idea.testartifacts.junit.AndroidTestsPattern;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit2.configuration.JUnitConfigurable;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AndroidJUnitConfiguration
extends JUnitConfiguration {
    public AndroidJUnitConfiguration(@NotNull String name, @NotNull Project project, @NotNull ConfigurationFactory configurationFactory) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/testartifacts/junit/AndroidJUnitConfiguration", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/testartifacts/junit/AndroidJUnitConfiguration", "<init>"));
        }
        if (configurationFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationFactory", "com/android/tools/idea/testartifacts/junit/AndroidJUnitConfiguration", "<init>"));
        }
        super(name, project, new JUnitConfiguration.Data(){

            public TestObject getTestObject(@NotNull JUnitConfiguration configuration) {
                if (configuration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/testartifacts/junit/AndroidJUnitConfiguration$1", "getTestObject"));
                }
                AndroidTestObject testObject = AndroidJUnitConfiguration.fromString(this.TEST_OBJECT, configuration, ExecutionEnvironmentBuilder.create((Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunConfiguration)configuration).build());
                return testObject != null ? testObject : super.getTestObject(configuration);
            }
        }, configurationFactory);
    }

    public TestObject getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/testartifacts/junit/AndroidJUnitConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/testartifacts/junit/AndroidJUnitConfiguration", "getState"));
        }
        AndroidTestObject testObject = AndroidJUnitConfiguration.fromString(this.getPersistentData().TEST_OBJECT, this, env);
        return testObject != null ? testObject : super.getState(executor, env);
    }

    public SMTRunnerConsoleProperties createTestConsoleProperties(Executor executor) {
        return new AndroidJUnitConsoleProperties(this, executor);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new JUnitConfigurable(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/junit/AndroidJUnitConfiguration", "getConfigurationEditor"));
        }
        return settingsEditorGroup;
    }

    @NotNull
    public Module[] getModulesToCompile() {
        if ("package".equals(this.getPersistentData().TEST_OBJECT) && this.getPersistentData().getScope() == TestSearchScope.WHOLE_PROJECT) {
            Collection modules = this.getAllModules();
            Module[] moduleArray = modules.toArray(new Module[modules.size()]);
            if (moduleArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/junit/AndroidJUnitConfiguration", "getModulesToCompile"));
            }
            return moduleArray;
        }
        Module[] moduleArray = this.getModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/junit/AndroidJUnitConfiguration", "getModulesToCompile"));
        }
        return moduleArray;
    }

    private static AndroidTestObject fromString(String id, @NotNull JUnitConfiguration configuration, @NotNull ExecutionEnvironment environment) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/testartifacts/junit/AndroidJUnitConfiguration", "fromString"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/android/tools/idea/testartifacts/junit/AndroidJUnitConfiguration", "fromString"));
        }
        if ("package".equals(id)) {
            return new AndroidTestObject((TestObject)new AndroidTestPackage(configuration, environment));
        }
        if ("pattern".equals(id)) {
            return new AndroidTestObject((TestObject)new AndroidTestsPattern(configuration, environment));
        }
        return null;
    }
}

