/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.actions.BlueprintModeAction;
import com.android.tools.idea.actions.BothModeAction;
import com.android.tools.idea.actions.DesignModeAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationMenuAction;
import com.android.tools.idea.configurations.DeviceMenuAction;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.configurations.OrientationMenuAction;
import com.android.tools.idea.configurations.TargetMenuAction;
import com.android.tools.idea.configurations.ThemeMenuAction;
import com.android.tools.idea.uibuilder.actions.LintNotificationAction;
import com.android.tools.idea.uibuilder.actions.SetZoomAction;
import com.android.tools.idea.uibuilder.actions.TogglePanningDialogAction;
import com.android.tools.idea.uibuilder.actions.ZoomLabelAction;
import com.android.tools.idea.uibuilder.editor.NlEditorPanel;
import com.android.tools.idea.uibuilder.model.ModelListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.DesignSurfaceListener;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.uibuilder.surface.ZoomType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.IdeBorderFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlActionsToolbar
implements DesignSurfaceListener,
ModelListener {
    private final DesignSurface mySurface;
    private NlModel myModel;
    private JComponent myToolbarComponent;
    private final DefaultActionGroup myDynamicGroup;
    private ActionToolbar myActionToolbar;

    public NlActionsToolbar(@NotNull DesignSurface surface) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/editor/NlActionsToolbar", "<init>"));
        }
        this.myDynamicGroup = new DefaultActionGroup();
        this.mySurface = surface;
    }

    @NotNull
    public JComponent getToolbarComponent() {
        if (this.myToolbarComponent == null) {
            this.myToolbarComponent = this.createToolbarComponent();
        }
        JComponent jComponent = this.myToolbarComponent;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlActionsToolbar", "getToolbarComponent"));
        }
        return jComponent;
    }

    private JComponent createToolbarComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(IdeBorderFactory.createBorder((int)8));
        NlEditorPanel.NlConfigurationHolder context = new NlEditorPanel.NlConfigurationHolder(this.mySurface);
        DefaultActionGroup configGroup = NlActionsToolbar.createConfigActions(context, this.mySurface);
        ActionManager actionManager = ActionManager.getInstance();
        this.myActionToolbar = actionManager.createActionToolbar("NlConfigToolbar", (ActionGroup)configGroup, true);
        this.myActionToolbar.getComponent().setName("NlConfigToolbar");
        this.myActionToolbar.setLayoutPolicy(1);
        JComponent actionToolbarComponent = this.myActionToolbar.getComponent();
        actionToolbarComponent.setBorder(IdeBorderFactory.createBorder((int)8));
        panel.add((Component)actionToolbarComponent, "North");
        ActionToolbar layoutToolBar = actionManager.createActionToolbar("NlLayoutToolbar", (ActionGroup)this.myDynamicGroup, true);
        layoutToolBar.getComponent().setName("NlLayoutToolbar");
        layoutToolBar.setLayoutPolicy(1);
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.add((Component)layoutToolBar.getComponent(), "West");
        JPanel combined = new JPanel(new BorderLayout());
        ActionToolbar zoomToolBar = actionManager.createActionToolbar("NlRhsToolbar", NlActionsToolbar.getRhsActions(this.mySurface), true);
        combined.add((Component)zoomToolBar.getComponent(), "West");
        bottom.add((Component)combined, "East");
        panel.add((Component)bottom, "South");
        this.mySurface.addListener(this);
        this.updateViewActions();
        return panel;
    }

    private static ActionGroup getRhsActions(DesignSurface surface) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new SetZoomAction(surface, ZoomType.OUT));
        group.add((AnAction)new ZoomLabelAction(surface));
        group.add((AnAction)new SetZoomAction(surface, ZoomType.IN));
        group.add((AnAction)new SetZoomAction(surface, ZoomType.FIT));
        group.add((AnAction)new TogglePanningDialogAction(surface));
        group.addSeparator();
        group.add((AnAction)new LintNotificationAction(surface));
        return group;
    }

    private static DefaultActionGroup createConfigActions(ConfigurationHolder configurationHolder, DesignSurface surface) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new DesignModeAction(surface));
        group.add((AnAction)new BlueprintModeAction(surface));
        group.add((AnAction)new BothModeAction(surface));
        group.addSeparator();
        OrientationMenuAction orientationAction = new OrientationMenuAction(configurationHolder);
        group.add((AnAction)orientationAction);
        group.addSeparator();
        DeviceMenuAction deviceAction = new DeviceMenuAction(configurationHolder);
        group.add((AnAction)deviceAction);
        TargetMenuAction targetMenuAction = new TargetMenuAction(configurationHolder);
        group.add((AnAction)targetMenuAction);
        ThemeMenuAction themeAction = new ThemeMenuAction(configurationHolder);
        group.add((AnAction)themeAction);
        group.addSeparator();
        LocaleMenuAction localeAction = new LocaleMenuAction(configurationHolder);
        group.add((AnAction)localeAction);
        group.addSeparator();
        ConfigurationMenuAction configAction = new ConfigurationMenuAction(surface);
        group.add((AnAction)configAction);
        return group;
    }

    @Nullable
    private static NlComponent findSharedParent(@NotNull List<NlComponent> newSelection) {
        if (newSelection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSelection", "com/android/tools/idea/uibuilder/editor/NlActionsToolbar", "findSharedParent"));
        }
        NlComponent parent = null;
        for (NlComponent selected : newSelection) {
            if (parent == null) {
                parent = selected.getParent();
                if (newSelection.size() != 1 || !selected.isRoot() || parent != null && !parent.isRoot()) continue;
                return selected;
            }
            if (parent == selected.getParent()) continue;
            parent = null;
            break;
        }
        return parent;
    }

    public void updateViewActions() {
        ScreenView view = this.mySurface.getCurrentScreenView();
        if (view != null) {
            SelectionModel selectionModel = view.getSelectionModel();
            List<NlComponent> selection = selectionModel.getSelection();
            if (selection.isEmpty()) {
                List<NlComponent> roots = view.getModel().getComponents();
                if (roots.size() == 1) {
                    selection = Collections.singletonList(roots.get(0));
                } else {
                    this.myModel.addListener(this);
                    return;
                }
            }
            this.updateViewActions(selection);
        }
    }

    private void updateViewActions(@NotNull List<NlComponent> newSelection) {
        if (newSelection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSelection", "com/android/tools/idea/uibuilder/editor/NlActionsToolbar", "updateViewActions"));
        }
        ScreenView screenView = this.mySurface.getCurrentScreenView();
        if (screenView == null) {
            return;
        }
        this.myActionToolbar.getComponent().setVisible(this.mySurface.getLayoutType().isSupportedByDesigner());
        this.myDynamicGroup.removeAll();
        NlComponent parent = NlActionsToolbar.findSharedParent(newSelection);
        if (parent != null) {
            this.mySurface.getActionManager().addViewActions(this.myDynamicGroup, null, parent, newSelection, true);
        }
    }

    public void setModel(NlModel model) {
        this.myModel = model;
    }

    @Override
    public void componentSelectionChanged(@NotNull DesignSurface surface, @NotNull List<NlComponent> newSelection) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/editor/NlActionsToolbar", "componentSelectionChanged"));
        }
        if (newSelection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSelection", "com/android/tools/idea/uibuilder/editor/NlActionsToolbar", "componentSelectionChanged"));
        }
        assert (surface == this.mySurface);
        if (!newSelection.isEmpty()) {
            this.updateViewActions(newSelection);
        } else {
            this.updateViewActions();
        }
    }

    @Override
    public void screenChanged(@NotNull DesignSurface surface, @Nullable ScreenView screenView) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/editor/NlActionsToolbar", "screenChanged"));
        }
        this.myActionToolbar.updateActionsImmediately();
        this.updateViewActions();
    }

    @Override
    public void modelChanged(@NotNull DesignSurface surface, @Nullable NlModel model) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/editor/NlActionsToolbar", "modelChanged"));
        }
        if (this.myDynamicGroup.getChildrenCount() == 0) {
            this.myModel = model;
            this.updateViewActions();
        }
    }

    @Override
    public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/editor/NlActionsToolbar", "activatePreferredEditor"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/editor/NlActionsToolbar", "activatePreferredEditor"));
        }
        return false;
    }

    @Override
    public void modelChanged(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/editor/NlActionsToolbar", "modelChanged"));
        }
    }

    @Override
    public void modelRendered(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/editor/NlActionsToolbar", "modelRendered"));
        }
        this.updateViewActions();
        model.removeListener(this);
    }

    @Override
    public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/editor/NlActionsToolbar", "modelChangedOnLayout"));
        }
    }
}

