/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.backgroundremove.RemoveBackgroundPanel;
import com.android.tools.idea.uibuilder.mockup.editor.creators.ResourcesUtil;
import com.android.tools.idea.uibuilder.mockup.editor.creators.SimpleViewCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.WidgetCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.forms.ExtractBackgroundForm;
import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageViewCreator
extends SimpleViewCreator {
    public static final Logger LOGGER = Logger.getInstance(ImageViewCreator.class);
    public static final String DRAWABLE_TYPE = "png";
    private final Rectangle mySelection;
    private RemoveBackgroundPanel myRemoveBackgroundPanel;
    private ExtractBackgroundForm myExtractBackgroundForm;
    @Nullable
    private String myDrawableName;

    public ImageViewCreator(@NotNull Mockup mockup, @NotNull NlModel model, @NotNull ScreenView screenView, @NotNull Rectangle selection) {
        if (mockup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mockup", "com/android/tools/idea/uibuilder/mockup/editor/creators/ImageViewCreator", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/mockup/editor/creators/ImageViewCreator", "<init>"));
        }
        if (screenView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/mockup/editor/creators/ImageViewCreator", "<init>"));
        }
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/android/tools/idea/uibuilder/mockup/editor/creators/ImageViewCreator", "<init>"));
        }
        super(mockup, model, screenView, selection);
        this.mySelection = selection;
        this.myRemoveBackgroundPanel = new RemoveBackgroundPanel();
        this.myExtractBackgroundForm = new ExtractBackgroundForm(this.myRemoveBackgroundPanel);
    }

    @Override
    @NotNull
    public String getAndroidViewTag() {
        if ("ImageView" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/mockup/editor/creators/ImageViewCreator", "getAndroidViewTag"));
        }
        return "ImageView";
    }

    @Override
    public boolean hasOptionsComponent() {
        return true;
    }

    @Override
    @Nullable
    public JComponent getOptionsComponent(@NotNull WidgetCreator.DoneCallback doneCallback) {
        if (doneCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doneCallback", "com/android/tools/idea/uibuilder/mockup/editor/creators/ImageViewCreator", "getOptionsComponent"));
        }
        Mockup mockup = this.getMockup();
        BufferedImage image = mockup.getImage();
        if (image == null) {
            return null;
        }
        this.myExtractBackgroundForm.setOKListener(actionEvent -> {
            if (doneCallback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doneCallback", "com/android/tools/idea/uibuilder/mockup/editor/creators/ImageViewCreator", "lambda$getOptionsComponent$0"));
            }
            BufferedImage extractedImage = this.myRemoveBackgroundPanel.getImage();
            if (extractedImage == null) {
                doneCallback.done(0);
                return;
            }
            this.myDrawableName = this.myExtractBackgroundForm.getDrawableName();
            if (ResourcesUtil.checkDrawableExist(this.myDrawableName, DRAWABLE_TYPE, this.getModel().getFacet())) {
                this.myExtractBackgroundForm.setErrorText(String.format("A drawable resource named <i>%s</i> already exists and will be overwritten.", this.myDrawableName));
                return;
            }
            ResourcesUtil.createDrawable(this.myDrawableName, DRAWABLE_TYPE, doneCallback, this.getModel(), extractedImage, this);
        });
        Rectangle realCropping = mockup.getComputedCropping();
        BufferedImage subimage = image.getSubimage(realCropping.x + this.mySelection.x, realCropping.y + this.mySelection.y, this.mySelection.width, this.mySelection.height);
        this.myRemoveBackgroundPanel.setImage(subimage);
        this.myRemoveBackgroundPanel.setPreferredSize(new Dimension(300, 300));
        return this.myExtractBackgroundForm.getComponent();
    }

    @Override
    protected void addAttributes(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/android/tools/idea/uibuilder/mockup/editor/creators/ImageViewCreator", "addAttributes"));
        }
        super.addAttributes(transaction);
        if (this.getDrawableName() != null) {
            transaction.setAttribute(null, "android:src", "@drawable/" + this.getDrawableName());
        }
    }

    @Nullable
    public String getDrawableName() {
        return this.myDrawableName;
    }
}

