/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.tools.idea.uibuilder.model.DnDTransferComponent;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.SelectionHandle;
import com.android.tools.idea.uibuilder.model.SelectionHandles;
import com.android.tools.idea.uibuilder.model.SelectionListener;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionModel {
    private List<NlComponent> mySelection = Collections.emptyList();
    private NlComponent myPrimary;
    private List<SelectionListener> myListeners;
    private Map<NlComponent, SelectionHandles> myHandles;

    @NotNull
    public List<NlComponent> getSelection() {
        List<NlComponent> list = Collections.unmodifiableList(this.mySelection);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/SelectionModel", "getSelection"));
        }
        return list;
    }

    @Nullable
    public NlComponent getPrimary() {
        return this.myPrimary;
    }

    public void setSelection(@NotNull Collection<NlComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/model/SelectionModel", "setSelection"));
        }
        this.setSelection(components, components.isEmpty() ? null : components.iterator().next());
    }

    public void setSelection(@NotNull Collection<NlComponent> components, @Nullable NlComponent primary) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/model/SelectionModel", "setSelection"));
        }
        if (components.equals(this.mySelection)) {
            return;
        }
        this.myHandles = null;
        this.mySelection = Lists.newArrayList(components);
        this.myPrimary = primary;
        this.updateListeners();
    }

    public void clear() {
        if (this.mySelection == null || this.mySelection.isEmpty()) {
            return;
        }
        this.myHandles = null;
        this.mySelection = Collections.emptyList();
        this.myPrimary = null;
        this.updateListeners();
    }

    public void toggle(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/model/SelectionModel", "toggle"));
        }
        this.myHandles = null;
        if (this.mySelection.contains(component)) {
            this.mySelection.remove(component);
            if (this.myPrimary == component) {
                this.myPrimary = null;
            }
        } else if (this.mySelection.isEmpty()) {
            this.mySelection = Lists.newArrayList((Object[])new NlComponent[]{component});
            this.myPrimary = component;
        } else {
            this.mySelection.add(component);
        }
        this.updateListeners();
    }

    public void updateListeners() {
        if (this.myListeners != null) {
            List<NlComponent> selection = this.getSelection();
            for (SelectionListener listener : this.myListeners) {
                listener.selectionChanged(this, selection);
            }
        }
    }

    public void addListener(@NotNull SelectionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/model/SelectionModel", "addListener"));
        }
        if (this.myListeners == null) {
            this.myListeners = Lists.newArrayList();
        } else {
            this.myListeners.remove(listener);
        }
        this.myListeners.add(listener);
    }

    public void removeListener(@NotNull SelectionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/model/SelectionModel", "removeListener"));
        }
        if (this.myListeners != null) {
            this.myListeners.remove(listener);
        }
    }

    public boolean isEmpty() {
        return this.mySelection.isEmpty();
    }

    @Nullable
    public SelectionHandle findHandle(int x, int y, int maxDistance) {
        if (this.myHandles == null) {
            return null;
        }
        for (SelectionHandles handles : this.myHandles.values()) {
            SelectionHandle handle = handles.findHandle(x, y, maxDistance);
            if (handle == null) continue;
            return handle;
        }
        return null;
    }

    @Nullable
    public NlComponent findComponent(int x, int y) {
        for (NlComponent component : this.mySelection) {
            if (component.x > x || component.y > y || component.x + component.w < x || component.y + component.h < y) continue;
            return component;
        }
        return null;
    }

    @NotNull
    public SelectionHandles getHandles(@NotNull NlComponent component) {
        SelectionHandles handles;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/model/SelectionModel", "getHandles"));
        }
        if (this.myHandles == null) {
            this.myHandles = Maps.newHashMap();
        }
        if ((handles = this.myHandles.get(component)) == null) {
            handles = new SelectionHandles(component);
            this.myHandles.put(component, handles);
        }
        SelectionHandles selectionHandles = handles;
        if (selectionHandles == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/SelectionModel", "getHandles"));
        }
        return selectionHandles;
    }

    public void selectAll(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/model/SelectionModel", "selectAll"));
        }
        ArrayList all = Lists.newArrayList();
        for (NlComponent component : model.getComponents()) {
            SelectionModel.addComponent(all, component);
        }
        this.setSelection(all);
    }

    private static void addComponent(List<NlComponent> all, NlComponent component) {
        all.add(component);
        for (NlComponent child : component.getChildren()) {
            SelectionModel.addComponent(all, child);
        }
    }

    public boolean isSelected(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/model/SelectionModel", "isSelected"));
        }
        return this.mySelection.contains(component);
    }

    public Transferable getTransferable(long modelId) {
        ArrayList<DnDTransferComponent> components = new ArrayList<DnDTransferComponent>(this.mySelection.size());
        for (NlComponent component : this.mySelection) {
            components.add(new DnDTransferComponent(component.getTagName(), component.getTag().getText(), component.w, component.h));
        }
        return new ItemTransferable(new DnDTransferItem(modelId, components));
    }
}

