/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EnumSupport {
    protected final NlProperty myProperty;

    public EnumSupport(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/support/EnumSupport", "<init>"));
        }
        this.myProperty = property;
    }

    @NotNull
    public abstract List<ValueWithDisplayString> getAllValues();

    @NotNull
    public ValueWithDisplayString createValue(@NotNull String editorValue) {
        String resolvedValue;
        if (editorValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorValue", "com/android/tools/idea/uibuilder/property/editors/support/EnumSupport", "createValue"));
        }
        if (editorValue.isEmpty()) {
            editorValue = null;
        }
        if (StringUtil.isEmpty((String)(resolvedValue = this.myProperty.resolveValue(editorValue)))) {
            ValueWithDisplayString valueWithDisplayString = ValueWithDisplayString.UNSET;
            if (valueWithDisplayString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/support/EnumSupport", "createValue"));
            }
            return valueWithDisplayString;
        }
        String hint = editorValue == null ? "default" : (!editorValue.equals(resolvedValue) ? editorValue : null);
        ValueWithDisplayString valueWithDisplayString = this.createFromResolvedValue(resolvedValue, editorValue, hint);
        if (valueWithDisplayString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/support/EnumSupport", "createValue"));
        }
        return valueWithDisplayString;
    }

    @NotNull
    protected ValueWithDisplayString createFromResolvedValue(@NotNull String resolvedValue, @Nullable String value, @Nullable String hint) {
        if (resolvedValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedValue", "com/android/tools/idea/uibuilder/property/editors/support/EnumSupport", "createFromResolvedValue"));
        }
        ValueWithDisplayString valueWithDisplayString = new ValueWithDisplayString(resolvedValue, value, hint);
        if (valueWithDisplayString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/support/EnumSupport", "createFromResolvedValue"));
        }
        return valueWithDisplayString;
    }
}

