/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.resources.ResourceType;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.support.AttributeDefinitionEnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.IdEnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.OnClickEnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.SimpleEnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.SimpleQuantityEnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.StyleEnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.StyleFilter;
import com.android.tools.idea.uibuilder.property.editors.support.TextAppearanceEnumSupport;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;

public class EnumSupportFactory {
    static final String TEXT_APPEARANCE_SUFFIX = "TextAppearance";
    static final List<String> AVAILABLE_TEXT_SIZES = ImmutableList.of((Object)"8sp", (Object)"10sp", (Object)"12sp", (Object)"14sp", (Object)"18sp", (Object)"24sp", (Object)"30sp", (Object)"36sp");
    static final List<String> AVAILABLE_LINE_SPACINGS = AVAILABLE_TEXT_SIZES;
    static final List<String> AVAILABLE_TYPEFACES = ImmutableList.of((Object)"normal", (Object)"sans", (Object)"serif", (Object)"monospace");
    static final List<String> AVAILABLE_SIZES = ImmutableList.of((Object)"match_parent", (Object)"wrap_content");

    public static boolean supportsProperty(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/support/EnumSupportFactory", "supportsProperty"));
        }
        switch (property.getName()) {
            case "fontFamily": 
            case "typeface": 
            case "textSize": 
            case "lineSpacingExtra": 
            case "textAppearance": 
            case "layout_height": 
            case "layout_width": 
            case "dropDownHeight": 
            case "dropDownWidth": 
            case "onClick": {
                return true;
            }
            case "id": {
                return false;
            }
            case "style": {
                String tagName = property.getTagName();
                return tagName != null && StyleFilter.hasWidgetStyles(property.getModel().getProject(), property.getResolver(), tagName);
            }
        }
        if (property.getName().endsWith(TEXT_APPEARANCE_SUFFIX)) {
            return true;
        }
        if (AndroidDomUtil.SPECIAL_RESOURCE_TYPES.get(property.getName()) == ResourceType.ID) {
            return true;
        }
        AttributeDefinition definition = property.getDefinition();
        Set<Object> formats = definition != null ? definition.getFormats() : Collections.emptySet();
        return formats.contains((Object)AttributeFormat.Enum);
    }

    public static EnumSupport create(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/support/EnumSupportFactory", "create"));
        }
        switch (property.getName()) {
            case "fontFamily": {
                return new SimpleEnumSupport(property, AndroidDomUtil.AVAILABLE_FAMILIES);
            }
            case "typeface": {
                return new SimpleEnumSupport(property, AVAILABLE_TYPEFACES);
            }
            case "textSize": {
                return new SimpleQuantityEnumSupport(property, AVAILABLE_TEXT_SIZES);
            }
            case "lineSpacingExtra": {
                return new SimpleQuantityEnumSupport(property, AVAILABLE_LINE_SPACINGS);
            }
            case "textAppearance": {
                return new TextAppearanceEnumSupport(property);
            }
            case "layout_height": 
            case "layout_width": 
            case "dropDownHeight": 
            case "dropDownWidth": {
                return new SimpleQuantityEnumSupport(property, AVAILABLE_SIZES);
            }
            case "onClick": {
                return new OnClickEnumSupport(property);
            }
            case "style": {
                return new StyleEnumSupport(property);
            }
        }
        if (property.getName().endsWith(TEXT_APPEARANCE_SUFFIX)) {
            return new TextAppearanceEnumSupport(property);
        }
        if (AndroidDomUtil.SPECIAL_RESOURCE_TYPES.get(property.getName()) == ResourceType.ID) {
            return new IdEnumSupport(property);
        }
        return new AttributeDefinitionEnumSupport(property);
    }
}

