/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.ptable;

import com.android.tools.idea.uibuilder.property.ptable.PTableItem;
import com.android.tools.idea.uibuilder.property.ptable.StarState;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PTableGroupItem
extends PTableItem {
    private List<PTableItem> myItems;
    private boolean myExpanded;

    public void setChildren(@NotNull List<PTableItem> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/android/tools/idea/uibuilder/property/ptable/PTableGroupItem", "setChildren"));
        }
        this.myItems = items;
        for (PTableItem item : items) {
            item.setParent(this);
        }
    }

    public void addChild(@NotNull PTableItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/property/ptable/PTableGroupItem", "addChild"));
        }
        this.addChild(item, null);
    }

    public void addChild(@NotNull PTableItem item, @Nullable PTableItem after) {
        int index;
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/property/ptable/PTableGroupItem", "addChild"));
        }
        item.setParent(this);
        if (this.myItems == null) {
            this.myItems = Lists.newArrayList();
        }
        int n = index = after != null ? this.myItems.indexOf(after) : -1;
        if (index != -1) {
            this.myItems.add(index + 1, item);
        } else {
            this.myItems.add(item);
        }
    }

    public void deleteChild(@NotNull PTableItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/property/ptable/PTableGroupItem", "deleteChild"));
        }
        assert (this == item.getParent());
        item.setParent(null);
        this.myItems.remove(item);
    }

    @Override
    public List<PTableItem> getChildren() {
        return this.myItems == null ? Collections.emptyList() : this.myItems;
    }

    @Nullable
    public PTableItem getItemByName(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/android/tools/idea/uibuilder/property/ptable/PTableGroupItem", "getItemByName"));
        }
        for (PTableItem item : this.myItems) {
            if (!item.getName().equals(propertyName)) continue;
            return item;
        }
        return null;
    }

    @Override
    public boolean hasChildren() {
        return this.myItems != null && !this.myItems.isEmpty();
    }

    @Override
    public boolean isExpanded() {
        return this.myExpanded;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.myExpanded = expanded;
    }

    @Override
    @NotNull
    public StarState getStarState() {
        StarState starState = StarState.NOT_STAR_ABLE;
        if (starState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/ptable/PTableGroupItem", "getStarState"));
        }
        return starState;
    }

    @Override
    public void setStarState(@NotNull StarState starState) {
        if (starState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "starState", "com/android/tools/idea/uibuilder/property/ptable/PTableGroupItem", "setStarState"));
        }
        throw new IllegalStateException();
    }

    @Override
    @Nullable
    public String getValue() {
        throw new IllegalStateException();
    }

    @Override
    @Nullable
    public String getResolvedValue() {
        throw new IllegalStateException();
    }

    @Override
    public boolean isDefaultValue(@Nullable String value) {
        throw new IllegalStateException();
    }

    @Override
    public void setValue(@Nullable Object value) {
        throw new IllegalStateException();
    }
}

