/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import com.android.tools.idea.uibuilder.scene.Scene;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import java.awt.Graphics2D;
import org.jetbrains.annotations.NotNull;

public class Display {
    private long mTime;
    private DisplayList myDisplayList = new DisplayList();
    private boolean myNeedsDisplayListRebuild;
    double myScale = 0.0;

    void reLayout() {
        this.myNeedsDisplayListRebuild = true;
    }

    public void draw(@NotNull SceneContext sceneContext, @NotNull Graphics2D g, @NotNull Scene scene) {
        DesignSurface designSurface;
        if (sceneContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneContext", "com/android/tools/idea/uibuilder/scene/Display", "draw"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/uibuilder/scene/Display", "draw"));
        }
        if (scene == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scene", "com/android/tools/idea/uibuilder/scene/Display", "draw"));
        }
        this.mTime = System.currentTimeMillis();
        if (scene.getNeedsDisplayListRebuilt()) {
            this.myNeedsDisplayListRebuild = true;
        }
        if (sceneContext.getScale() != this.myScale) {
            this.myScale = sceneContext.getScale();
            this.myNeedsDisplayListRebuild = true;
        }
        this.myNeedsDisplayListRebuild |= this.myDisplayList.getCommands().size() == 0;
        if (this.myNeedsDisplayListRebuild) {
            this.myDisplayList.clear();
            this.myNeedsDisplayListRebuild = scene.buildDisplayList(this.myDisplayList, this.mTime, sceneContext);
            scene.clearNeedsRebuildList();
        }
        this.draw(sceneContext, g, this.myDisplayList);
        if (this.myNeedsDisplayListRebuild && (designSurface = sceneContext.getSurface()) != null) {
            designSurface.repaint();
        }
    }

    public void draw(@NotNull SceneContext sceneContext, @NotNull Graphics2D g, @NotNull DisplayList list) {
        if (sceneContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneContext", "com/android/tools/idea/uibuilder/scene/Display", "draw"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/uibuilder/scene/Display", "draw"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/Display", "draw"));
        }
        sceneContext.setTime(System.currentTimeMillis());
        list.paint(g, sceneContext);
    }
}

