/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.decorator;

import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.decorator.SceneDecorator;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.DrawTextRegion;
import com.android.tools.sherpa.drawing.ColorSet;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import org.jetbrains.annotations.NotNull;

public class SwitchDecorator
extends SceneDecorator {
    /*
     * WARNING - void declaration
     */
    @Override
    public void addContent(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent sceneComponent) {
        void component;
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/decorator/SwitchDecorator", "addContent"));
        }
        if (sceneContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneContext", "com/android/tools/idea/uibuilder/scene/decorator/SwitchDecorator", "addContent"));
        }
        if (sceneComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/decorator/SwitchDecorator", "addContent"));
        }
        super.addContent(list, time, sceneContext, (SceneComponent)component);
        Rectangle rect = new Rectangle();
        component.fillDrawRect(time, rect);
        int l = sceneContext.getSwingX(rect.x);
        int t = sceneContext.getSwingY(rect.y);
        int w = sceneContext.getSwingDimension(rect.width);
        int h = sceneContext.getSwingDimension(rect.height);
        int baseLineOffset = sceneContext.getSwingDimension(component.getBaseline());
        String text = ConstraintUtilities.getResolvedText(component.getNlComponent());
        if (text == null) {
            text = "";
        }
        list.add(new DrawSwitch(l, t, w, h, baseLineOffset, text));
    }

    public static class DrawSwitch
    extends DrawTextRegion {
        private static final int MARGIN = 4;

        @Override
        public int getLevel() {
            return 20;
        }

        DrawSwitch(int x, int y, int width, int height, int baseLineOffset, String string) {
            super(x, y, width, height, baseLineOffset, string);
        }

        public DrawSwitch(String string) {
            String[] sp = string.split(",");
            int c = super.parse(sp, 0);
            this.myBaseLineOffset = Integer.parseInt(sp[c++]);
            this.mSingleLine = Boolean.parseBoolean(sp[c++]);
            this.mToUpperCase = Boolean.parseBoolean(sp[c++]);
            this.mAlignmentX = Integer.parseInt(sp[c++]);
            this.mAlignmentY = Integer.parseInt(sp[c++]);
            this.mText = string.substring(string.indexOf(34) + 1, string.lastIndexOf(34));
            super.parse(sp, 0);
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            super.paint(g, sceneContext);
            ColorSet colorSet = sceneContext.getColorSet();
            if (colorSet.drawBackground()) {
                Shape origClip = g.getClip();
                g.clipRect(this.x, this.y, this.width, this.height);
                g.setColor(colorSet.getFakeUI());
                int sHeight = this.mFont.getSize() / 2;
                int sWidth = sHeight * 4;
                int sx = this.x + this.width - sWidth - 4;
                int sy = this.y + (this.height - sHeight) / 2;
                g.drawRoundRect(sx, sy, sWidth, sHeight, sHeight, sHeight);
                int bh = sHeight * 2;
                int bx = sx - bh / 2;
                int by = sy + sHeight / 2 - bh / 2;
                g.fillRoundRect(bx, by, bh, bh, bh, bh);
                g.setClip(origClip);
            }
        }
    }
}

