/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.draw;

import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.DrawHorizontalNotch;
import com.android.tools.idea.uibuilder.scene.draw.DrawVerticalNotch;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Notch {
    SceneComponent myOwner;
    int myNotchValue;
    int myDisplayValue;
    int myGap;
    Action myAction;
    boolean myDidApply;

    private Notch() {
        this.myGap = 8;
        this.myDidApply = false;
    }

    private Notch(@NotNull SceneComponent owner, int value, int displayValue) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/android/tools/idea/uibuilder/scene/draw/Notch", "<init>"));
        }
        this.myGap = 8;
        this.myDidApply = false;
        this.myOwner = owner;
        this.myNotchValue = value;
        this.myDisplayValue = displayValue;
    }

    private Notch(@NotNull SceneComponent owner, int value, int displayValue, @NotNull Action action) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/android/tools/idea/uibuilder/scene/draw/Notch", "<init>"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/uibuilder/scene/draw/Notch", "<init>"));
        }
        this.myGap = 8;
        this.myDidApply = false;
        this.myOwner = owner;
        this.myNotchValue = value;
        this.myDisplayValue = displayValue;
        this.myAction = action;
    }

    public void setAction(@Nullable Action action) {
        this.myAction = action;
    }

    public void apply(AttributesTransaction attributes) {
        if (this.myDidApply && this.myAction != null) {
            this.myAction.apply(attributes);
        }
    }

    public boolean didApply() {
        return this.myDidApply;
    }

    public int apply(int value) {
        this.myDidApply = false;
        if (Math.abs(value - this.myNotchValue) <= this.myGap) {
            this.myDidApply = true;
            return this.myNotchValue;
        }
        return value;
    }

    public abstract void render(@NotNull DisplayList var1, @NotNull SceneContext var2, @NotNull SceneComponent var3);

    public static class SmallVertical
    extends Notch {
        public SmallVertical(@NotNull SceneComponent owner, int value, int displayValue) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/android/tools/idea/uibuilder/scene/draw/Notch$SmallVertical", "<init>"));
            }
            super(owner, value, displayValue);
            this.myGap = 6;
        }

        public SmallVertical(@NotNull SceneComponent owner, int value, int displayValue, @NotNull Action action) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/android/tools/idea/uibuilder/scene/draw/Notch$SmallVertical", "<init>"));
            }
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/uibuilder/scene/draw/Notch$SmallVertical", "<init>"));
            }
            super(owner, value, displayValue, action);
            this.myGap = 6;
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/draw/Notch$SmallVertical", "render"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/uibuilder/scene/draw/Notch$SmallVertical", "render"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/draw/Notch$SmallVertical", "render"));
            }
            int gap = 16;
            int x1 = Math.min(this.myOwner.getDrawX(), component.getDrawX()) - gap;
            int x2 = Math.max(this.myOwner.getDrawX() + this.myOwner.getDrawWidth(), component.getDrawX() + component.getDrawWidth()) + gap;
            DrawHorizontalNotch.add(list, context, x1, this.myDisplayValue, x2);
        }
    }

    public static class SmallHorizontal
    extends Notch {
        public SmallHorizontal(@NotNull SceneComponent owner, int value, int displayValue) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/android/tools/idea/uibuilder/scene/draw/Notch$SmallHorizontal", "<init>"));
            }
            super(owner, value, displayValue);
            this.myGap = 6;
        }

        public SmallHorizontal(@NotNull SceneComponent owner, int value, int displayValue, @NotNull Action action) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/android/tools/idea/uibuilder/scene/draw/Notch$SmallHorizontal", "<init>"));
            }
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/uibuilder/scene/draw/Notch$SmallHorizontal", "<init>"));
            }
            super(owner, value, displayValue, action);
            this.myGap = 6;
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/draw/Notch$SmallHorizontal", "render"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/uibuilder/scene/draw/Notch$SmallHorizontal", "render"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/draw/Notch$SmallHorizontal", "render"));
            }
            SceneComponent parent = component.getParent();
            int gap = 16;
            int y1 = Math.min(this.myOwner.getDrawY(), component.getDrawY()) - gap;
            int y2 = Math.max(this.myOwner.getDrawY() + this.myOwner.getDrawHeight(), component.getDrawY() + component.getDrawHeight()) + gap;
            DrawVerticalNotch.add(list, context, this.myDisplayValue, y1, y2);
        }
    }

    public static class Vertical
    extends Notch {
        public Vertical(@NotNull SceneComponent owner, int value, int displayValue) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/android/tools/idea/uibuilder/scene/draw/Notch$Vertical", "<init>"));
            }
            super(owner, value, displayValue);
        }

        public Vertical(@NotNull SceneComponent owner, int value, int displayValue, @NotNull Action action) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/android/tools/idea/uibuilder/scene/draw/Notch$Vertical", "<init>"));
            }
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/uibuilder/scene/draw/Notch$Vertical", "<init>"));
            }
            super(owner, value, displayValue, action);
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/draw/Notch$Vertical", "render"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/uibuilder/scene/draw/Notch$Vertical", "render"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/draw/Notch$Vertical", "render"));
            }
            SceneComponent parent = component.getParent();
            DrawHorizontalNotch.add(list, context, parent.getDrawX(), this.myDisplayValue, parent.getDrawX() + parent.getDrawWidth());
        }
    }

    public static class Horizontal
    extends Notch {
        public Horizontal(@NotNull SceneComponent owner, int value, int displayValue) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/android/tools/idea/uibuilder/scene/draw/Notch$Horizontal", "<init>"));
            }
            super(owner, value, displayValue);
        }

        public Horizontal(@NotNull SceneComponent owner, int value, int displayValue, @NotNull Action action) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/android/tools/idea/uibuilder/scene/draw/Notch$Horizontal", "<init>"));
            }
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/uibuilder/scene/draw/Notch$Horizontal", "<init>"));
            }
            super(owner, value, displayValue, action);
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/draw/Notch$Horizontal", "render"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/uibuilder/scene/draw/Notch$Horizontal", "render"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/draw/Notch$Horizontal", "render"));
            }
            SceneComponent parent = component.getParent();
            DrawVerticalNotch.add(list, context, this.myDisplayValue, parent.getDrawY(), parent.getDrawY() + parent.getDrawHeight());
        }
    }

    public static interface Provider {
        public void fill(@NotNull SceneComponent var1, @NotNull SceneComponent var2, @NotNull ArrayList<Notch> var3, @NotNull ArrayList<Notch> var4);
    }

    public static interface Action {
        public void apply(@NotNull AttributesTransaction var1);
    }
}

