/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.DrawLasso;
import com.android.tools.idea.uibuilder.scene.target.BaseTarget;
import com.android.tools.idea.uibuilder.scene.target.Target;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LassoTarget
extends BaseTarget {
    private static final boolean DEBUG_RENDERER = false;
    private float myOriginX;
    private float myOriginY;
    private float myLastX;
    private float myLastY;
    private boolean myShowRect;

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        if (sceneTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneTransform", "com/android/tools/idea/uibuilder/scene/target/LassoTarget", "layout"));
        }
        this.myLeft = l;
        this.myTop = t;
        this.myRight = r;
        this.myBottom = b;
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/target/LassoTarget", "render"));
        }
        if (sceneContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneContext", "com/android/tools/idea/uibuilder/scene/target/LassoTarget", "render"));
        }
        if (this.myShowRect) {
            float x1 = Math.min(this.myOriginX, this.myLastX);
            float x2 = Math.max(this.myOriginX, this.myLastX);
            float y1 = Math.min(this.myOriginY, this.myLastY);
            float y2 = Math.max(this.myOriginY, this.myLastY);
            DrawLasso.add(list, sceneContext, x1, y1, x2, y2);
        }
    }

    @Override
    public int getPreferenceLevel() {
        return 10;
    }

    @Override
    public void mouseDown(int x, int y) {
        this.myOriginX = x;
        this.myOriginY = y;
        this.myLastX = x;
        this.myLastY = y;
        this.myShowRect = true;
        this.myComponent.getScene().needsRebuildList();
    }

    @Override
    public void mouseDrag(int x, int y, @Nullable Target closestTarget) {
        this.myLastX = x;
        this.myLastY = y;
        this.myComponent.getScene().needsRebuildList();
    }

    @Override
    public void mouseRelease(int x, int y, @Nullable Target closestTarget) {
        this.myShowRect = false;
        this.myComponent.getScene().needsRebuildList();
    }

    public void fillSelectedComponents(ArrayList<SceneComponent> components) {
        components.clear();
        int count = this.myComponent.getChildCount();
        float x1 = Math.min(this.myOriginX, this.myLastX);
        float x2 = Math.max(this.myOriginX, this.myLastX);
        float y1 = Math.min(this.myOriginY, this.myLastY);
        float y2 = Math.max(this.myOriginY, this.myLastY);
        if ((int)(x2 - x1) == 0 && (int)(y2 - y1) == 0) {
            return;
        }
        Rectangle bounds = new Rectangle((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
        for (int i = 0; i < count; ++i) {
            SceneComponent component = this.myComponent.getChild(i);
            if (!component.intersects(bounds)) continue;
            components.add(component);
        }
    }
}

