/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.Interaction;
import com.android.tools.idea.uibuilder.surface.Layer;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragDropInteraction
extends Interaction {
    private final DesignSurface myDesignSurface;
    private final List<NlComponent> myDraggedComponents;
    private ViewGroupHandler myCurrentHandler;
    private DragHandler myDragHandler;
    private NlComponent myDragReceiver;
    private DragType myType;
    private ScreenView myScreenView;
    private DnDTransferItem myTransferItem;
    private ViewGroupHandler myCachedHandler;
    private NlComponent myCachedComponent;

    public DragDropInteraction(@NotNull DesignSurface designSurface, @NotNull List<NlComponent> dragged) {
        if (designSurface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designSurface", "com/android/tools/idea/uibuilder/surface/DragDropInteraction", "<init>"));
        }
        if (dragged == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dragged", "com/android/tools/idea/uibuilder/surface/DragDropInteraction", "<init>"));
        }
        this.myType = DragType.MOVE;
        this.myDesignSurface = designSurface;
        this.myDraggedComponents = dragged;
    }

    public void setType(DragType type) {
        this.myType = type;
        if (this.myDragHandler != null) {
            this.myDragHandler.setDragType(type);
        }
    }

    public void setTransferItem(@NotNull DnDTransferItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/surface/DragDropInteraction", "setTransferItem"));
        }
        this.myTransferItem = item;
    }

    @Nullable
    public DnDTransferItem getTransferItem() {
        return this.myTransferItem;
    }

    @Override
    public void begin(int x, int y, @JdkConstants.InputEventMask int modifiers) {
        super.begin(x, y, modifiers);
        this.moveTo(x, y, modifiers, false);
        this.myDesignSurface.startDragDropInteraction();
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiers) {
        super.update(x, y, modifiers);
        this.moveTo(x, y, modifiers, false);
    }

    @Override
    public void end(int x, int y, @JdkConstants.InputEventMask int modifiers, boolean canceled) {
        super.end(x, y, modifiers, canceled);
        this.moveTo(x, y, modifiers, !canceled);
        this.myScreenView = this.myDesignSurface.getScreenView(x, y);
        if (this.myScreenView != null && !canceled) {
            this.myScreenView.getModel().notifyModified(NlModel.ChangeType.DND_END);
        }
        if (canceled && this.myDragHandler != null) {
            this.myDragHandler.cancel();
        }
        this.myDesignSurface.stopDragDropInteraction();
    }

    private void moveTo(int x, int y, final @JdkConstants.InputEventMask int modifiers, boolean commit) {
        String error;
        this.myScreenView = this.myDesignSurface.getScreenView(x, y);
        if (this.myScreenView == null) {
            return;
        }
        this.myDesignSurface.getLayeredPane().scrollRectToVisible(new Rectangle(x - 50, y - 50, 100, 100));
        final int ax = Coordinates.getAndroidX(this.myScreenView, x);
        final int ay = Coordinates.getAndroidY(this.myScreenView, y);
        Project project = this.myScreenView.getModel().getProject();
        ViewGroupHandler handler = this.findViewGroupHandlerAt(ax, ay);
        if (handler != this.myCurrentHandler) {
            if (this.myDragHandler != null) {
                this.myDragHandler.cancel();
                this.myDragHandler = null;
                this.myScreenView.getSurface().repaint();
            }
            this.myCurrentHandler = handler;
            if (this.myCurrentHandler != null) {
                assert (this.myDragReceiver != null);
                error = null;
                ViewHandlerManager viewHandlerManager = ViewHandlerManager.get(project);
                for (NlComponent component : this.myDraggedComponents) {
                    if (!this.myCurrentHandler.acceptsChild(this.myDragReceiver, component, ax, ay)) {
                        error = String.format("<%1$s> does not accept <%2$s> as a child", this.myDragReceiver.getTagName(), component.getTagName());
                        break;
                    }
                    ViewHandler viewHandler = viewHandlerManager.getHandler(component);
                    if (viewHandler == null || viewHandler.acceptsParent(this.myDragReceiver, component)) continue;
                    error = String.format("<%1$s> does not accept <%2$s> as a parent", component.getTagName(), this.myDragReceiver.getTagName());
                    break;
                }
                if (error == null) {
                    this.myDragHandler = this.myCurrentHandler.createDragHandler(new ViewEditorImpl(this.myScreenView), this.myDragReceiver, this.myDraggedComponents, this.myType);
                    if (this.myDragHandler != null) {
                        this.myDragHandler.start(Coordinates.getAndroidX(this.myScreenView, this.myStartX), Coordinates.getAndroidY(this.myScreenView, this.myStartY), this.myStartMask);
                    }
                } else {
                    this.myCurrentHandler = null;
                }
            }
        }
        if (this.myDragHandler != null && this.myCurrentHandler != null) {
            error = this.myDragHandler.update(ax, ay, modifiers);
            ArrayList added = Lists.newArrayList();
            if (commit && error == null) {
                added.addAll(this.myDraggedComponents);
                final NlModel model = this.myScreenView.getModel();
                XmlFile file = model.getFile();
                String label = this.myType.getDescription();
                WriteCommandAction action = new WriteCommandAction(project, label, new PsiFile[]{file}){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/surface/DragDropInteraction$1", "run"));
                        }
                        InsertType insertType = model.determineInsertType(DragDropInteraction.this.myType, DragDropInteraction.this.myTransferItem, false);
                        DragDropInteraction.this.myDragHandler.commit(ax, ay, modifiers, insertType);
                    }
                };
                action.execute();
                model.notifyModified(NlModel.ChangeType.DND_COMMIT);
                model.getSelectionModel().setSelection(added);
            }
            this.myScreenView.getSurface().repaint();
        }
    }

    @Nullable
    private ViewGroupHandler findViewGroupHandlerAt(int x, int y) {
        ScreenView screenView = this.myDesignSurface.getScreenView(x, y);
        if (screenView == null) {
            return null;
        }
        NlModel model = screenView.getModel();
        NlComponent component = model.findLeafAt(x, y, true);
        if ((component = this.excludeDraggedComponents(component)) == this.myCachedComponent && this.myCachedHandler != null) {
            return this.myCachedHandler;
        }
        this.myCachedComponent = component;
        this.myCachedHandler = null;
        ViewHandlerManager handlerManager = ViewHandlerManager.get(model.getFacet());
        while (component != null) {
            ViewHandler handler = handlerManager.getHandler(component);
            if (handler instanceof ViewGroupHandler && this.acceptsDrop(component, (ViewGroupHandler)handler, x, y)) {
                this.myCachedHandler = (ViewGroupHandler)handlerManager.getHandler(component);
                this.myDragReceiver = component;
                return this.myCachedHandler;
            }
            component = component.getParent();
        }
        return null;
    }

    @Nullable
    private NlComponent excludeDraggedComponents(@Nullable NlComponent component) {
        NlComponent receiver = component;
        while (component != null) {
            if (this.myDraggedComponents.contains(component)) {
                receiver = component.getParent();
            }
            component = component.getParent();
        }
        return receiver;
    }

    private boolean acceptsDrop(@NotNull NlComponent parent, @NotNull ViewGroupHandler parentHandler, int x, int y) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/uibuilder/surface/DragDropInteraction", "acceptsDrop"));
        }
        if (parentHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentHandler", "com/android/tools/idea/uibuilder/surface/DragDropInteraction", "acceptsDrop"));
        }
        ScreenView view = this.myDesignSurface.getScreenView(x, y);
        assert (view != null);
        ViewHandlerManager manager = ViewHandlerManager.get(view.getModel().getFacet());
        Predicate<NlComponent> acceptsChild = child -> {
            if (parentHandler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentHandler", "com/android/tools/idea/uibuilder/surface/DragDropInteraction", "lambda$acceptsDrop$0"));
            }
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/uibuilder/surface/DragDropInteraction", "lambda$acceptsDrop$0"));
            }
            return parentHandler.acceptsChild(parent, (NlComponent)child, x, y);
        };
        Predicate<NlComponent> acceptsParent = child -> {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/uibuilder/surface/DragDropInteraction", "lambda$acceptsDrop$1"));
            }
            ViewHandler childHandler = manager.getHandler((NlComponent)child);
            return childHandler != null && childHandler.acceptsParent(parent, (NlComponent)child);
        };
        return this.myDraggedComponents.stream().allMatch(acceptsChild.and(acceptsParent));
    }

    @Override
    public List<Layer> createOverlays() {
        return Collections.singletonList(new DragLayer());
    }

    @NotNull
    public List<NlComponent> getDraggedComponents() {
        List<NlComponent> list = this.myDraggedComponents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/DragDropInteraction", "getDraggedComponents"));
        }
        return list;
    }

    private class DragLayer
    extends Layer {
        @Override
        public void create() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void paint(@NotNull Graphics2D gc) {
            if (gc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gc", "com/android/tools/idea/uibuilder/surface/DragDropInteraction$DragLayer", "paint"));
            }
            if (DragDropInteraction.this.myDragHandler != null) {
                DragDropInteraction.this.myDragHandler.paint(new NlGraphics(gc, DragDropInteraction.this.myScreenView));
            }
        }
    }
}

