/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.builder.model.SourceProvider;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceNameValidator;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.actions.CreateResourceDialogUtils;
import org.jetbrains.android.actions.CreateXmlResourceDialog;
import org.jetbrains.android.actions.CreateXmlResourcePanel;
import org.jetbrains.android.actions.CreateXmlResourceSubdirPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateXmlResourcePanelImpl
implements CreateXmlResourcePanel,
CreateXmlResourceSubdirPanel.Parent {
    private JPanel myPanel;
    private JTextField myNameField;
    private ModulesComboBox myModuleCombo;
    private JBLabel myModuleLabel;
    private JTextField myValueField;
    private JBLabel myValueLabel;
    private JBLabel myNameLabel;
    private JComboBox myFileNameCombo;
    private JBLabel mySourceSetLabel;
    private JComboBox mySourceSetCombo;
    private JBLabel myFileNameLabel;
    @Nullable
    private final Module myModule;
    @NotNull
    private final ResourceType myResourceType;
    @NotNull
    private final ResourceFolderType myFolderType;
    private JPanel myDirectoriesPanel;
    private JBLabel myDirectoriesLabel;
    private CreateXmlResourceSubdirPanel mySubdirPanel;
    private ResourceNameValidator myResourceNameValidator;

    public CreateXmlResourcePanelImpl(@NotNull Module module, @NotNull ResourceType resourceType, @NotNull ResourceFolderType folderType, @Nullable String resourceName, @Nullable String resourceValue, boolean chooseName, boolean chooseValue, boolean chooseFilename, @Nullable VirtualFile defaultFile, @Nullable VirtualFile contextFile, @NotNull Function<Module, ResourceNameValidator> nameValidatorFactory) {
        String defaultFileName;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/actions/CreateXmlResourcePanelImpl", "<init>"));
        }
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/actions/CreateXmlResourcePanelImpl", "<init>"));
        }
        if (folderType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderType", "org/jetbrains/android/actions/CreateXmlResourcePanelImpl", "<init>"));
        }
        if (nameValidatorFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameValidatorFactory", "org/jetbrains/android/actions/CreateXmlResourcePanelImpl", "<init>"));
        }
        this.$$$setupUI$$$();
        this.setChangeNameVisible(false);
        this.setChangeValueVisible(false);
        this.setChangeFileNameVisible(chooseFilename);
        this.myFolderType = folderType;
        if (chooseName) {
            this.setChangeNameVisible(true);
            resourceName = ResourceHelper.prependResourcePrefix(module, resourceName, folderType);
        }
        if (!StringUtil.isEmpty((String)resourceName)) {
            this.myNameField.setText(resourceName);
        }
        if (chooseValue) {
            this.setChangeValueVisible(true);
            if (!StringUtil.isEmpty((String)resourceValue)) {
                this.myValueField.setText(resourceValue);
            }
        }
        this.myResourceType = resourceType;
        HashSet<Module> modulesSet = new HashSet<Module>();
        modulesSet.add(module);
        for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(module, true)) {
            modulesSet.add(depFacet.getModule());
        }
        assert (modulesSet.size() > 0);
        if (modulesSet.size() == 1) {
            this.myModule = module;
            this.setChangeModuleVisible(false);
        } else {
            this.myModule = null;
            this.myModuleCombo.setModules(modulesSet);
            this.myModuleCombo.setSelectedModule(module);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        CreateResourceDialogUtils.updateSourceSetCombo((JComponent)this.mySourceSetLabel, this.mySourceSetCombo, modulesSet.size() == 1 ? AndroidFacet.getInstance((Module)modulesSet.iterator().next()) : null);
        if (defaultFile == null && (defaultFileName = AndroidResourceUtil.getDefaultResourceFileName(this.myResourceType)) != null) {
            this.myFileNameCombo.getEditor().setItem(defaultFileName);
        }
        this.myDirectoriesLabel.setLabelFor((Component)this.myDirectoriesPanel);
        this.mySubdirPanel = new CreateXmlResourceSubdirPanel(module.getProject(), folderType, this.myDirectoriesPanel, this);
        this.myResourceNameValidator = nameValidatorFactory.apply(this.getModule());
        this.myModuleCombo.addActionListener(e -> {
            if (nameValidatorFactory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameValidatorFactory", "org/jetbrains/android/actions/CreateXmlResourcePanelImpl", "lambda$new$0"));
            }
            this.mySubdirPanel.updateDirectories(true, this.getResourceDirectory());
            this.myResourceNameValidator = (ResourceNameValidator)nameValidatorFactory.apply(this.getModule());
        });
        if (defaultFile != null) {
            this.resetFromFile(defaultFile, module.getProject());
        }
    }

    @Override
    public void resetToDefault() {
        String defaultFileName;
        if (this.myModule == null) {
            this.myModuleCombo.setSelectedModule(this.getRootModule());
        }
        if ((defaultFileName = AndroidResourceUtil.getDefaultResourceFileName(this.myResourceType)) != null) {
            this.myFileNameCombo.getEditor().setItem(defaultFileName);
        }
        this.mySubdirPanel.resetToDefault();
    }

    @NotNull
    private Module getRootModule() {
        assert (this.myModule == null);
        ComboBoxModel model = this.myModuleCombo.getModel();
        Module root = null;
        int moduleDependencyCount = -1;
        for (int c = 0; c < model.getSize(); ++c) {
            Module otherModule = (Module)model.getElementAt(c);
            int otherModuleDependencyCount = AndroidUtils.getAllAndroidDependencies(otherModule, true).size();
            if (otherModuleDependencyCount <= moduleDependencyCount) continue;
            moduleDependencyCount = otherModuleDependencyCount;
            root = otherModule;
        }
        assert (root != null);
        Module module = root;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateXmlResourcePanelImpl", "getRootModule"));
        }
        return module;
    }

    @Override
    public void resetFromFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/actions/CreateXmlResourcePanelImpl", "resetFromFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/actions/CreateXmlResourcePanelImpl", "resetFromFile"));
        }
        Module moduleForFile = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (moduleForFile == null) {
            return;
        }
        VirtualFile parent = file.getParent();
        if (parent == null) {
            return;
        }
        if (this.myModule == null) {
            Module prev = this.myModuleCombo.getSelectedModule();
            this.myModuleCombo.setSelectedItem((Object)moduleForFile);
            if (!moduleForFile.equals(this.myModuleCombo.getSelectedItem())) {
                this.myModuleCombo.setSelectedModule(prev);
                return;
            }
        } else if (!this.myModule.equals(moduleForFile)) {
            return;
        }
        this.mySubdirPanel.resetFromFile(parent);
        this.myFileNameCombo.getEditor().setItem(file.getName());
        this.myPanel.repaint();
    }

    @Override
    public ValidationInfo doValidate() {
        String resourceName = this.getResourceName();
        Module selectedModule = this.getModule();
        VirtualFile resourceDir = this.getResourceDirectory();
        List<String> directoryNames = this.getDirNames();
        String fileName = this.getFileName();
        if (this.myNameField.isVisible() && resourceName.isEmpty()) {
            return new ValidationInfo("specify resource name", (JComponent)this.myNameField);
        }
        if (this.myNameField.isVisible() && !AndroidResourceUtil.isCorrectAndroidResourceName(resourceName)) {
            return new ValidationInfo(resourceName + " is not correct resource name", (JComponent)this.myNameField);
        }
        if (fileName.isEmpty()) {
            return new ValidationInfo("specify file name", (JComponent)this.myFileNameCombo);
        }
        if (selectedModule == null) {
            return new ValidationInfo("specify module", (JComponent)this.myModuleCombo);
        }
        if (resourceDir == null) {
            return new ValidationInfo("specify a module with resources", (JComponent)this.myModuleCombo);
        }
        if (directoryNames.isEmpty()) {
            return new ValidationInfo("choose directories", (JComponent)this.myDirectoriesPanel);
        }
        if (resourceName.equals(ResourceHelper.prependResourcePrefix(this.myModule, null, this.myFolderType))) {
            return new ValidationInfo("specify more than resource prefix", (JComponent)this.myNameField);
        }
        return CreateXmlResourceDialog.checkIfResourceAlreadyExists(selectedModule.getProject(), resourceDir, resourceName, this.myResourceType, directoryNames, fileName);
    }

    @Override
    @NotNull
    public ResourceNameValidator getResourceNameValidator() {
        ResourceNameValidator resourceNameValidator = this.myResourceNameValidator;
        if (resourceNameValidator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateXmlResourcePanelImpl", "getResourceNameValidator"));
        }
        return resourceNameValidator;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        String name = this.myNameField.getText();
        if (name.isEmpty() || name.equals(ResourceHelper.prependResourcePrefix(this.myModule, null, this.myFolderType))) {
            return this.myNameField;
        }
        if (this.myValueField.isVisible()) {
            return this.myValueField;
        }
        if (this.myModuleCombo.isVisible()) {
            return this.myModuleCombo;
        }
        return this.myFileNameCombo;
    }

    @Override
    @NotNull
    public String getResourceName() {
        String string = this.myNameField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateXmlResourcePanelImpl", "getResourceName"));
        }
        return string;
    }

    @Override
    @NotNull
    public ResourceType getType() {
        ResourceType resourceType = this.myResourceType;
        if (resourceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateXmlResourcePanelImpl", "getType"));
        }
        return resourceType;
    }

    @Override
    @NotNull
    public List<String> getDirNames() {
        List<String> list = this.mySubdirPanel.getDirNames();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateXmlResourcePanelImpl", "getDirNames"));
        }
        return list;
    }

    @Override
    @NotNull
    public String getFileName() {
        String string = ((String)this.myFileNameCombo.getEditor().getItem()).trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateXmlResourcePanelImpl", "getFileName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getValue() {
        String string = this.myValueField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateXmlResourcePanelImpl", "getValue"));
        }
        return string;
    }

    @Nullable
    private SourceProvider getSourceProvider() {
        return CreateResourceDialogUtils.getSourceProvider(this.mySourceSetCombo);
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.myModule != null ? this.myModule : this.myModuleCombo.getSelectedModule();
    }

    @Override
    @Nullable
    public VirtualFile getResourceDirectory() {
        Module module = this.getModule();
        if (module == null) {
            return null;
        }
        PsiDirectory resDirectory = CreateResourceDialogUtils.getResourceDirectory(this.getSourceProvider(), module, true);
        return resDirectory != null ? resDirectory.getVirtualFile() : null;
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    private void setChangeFileNameVisible(boolean isVisible) {
        this.myFileNameLabel.setVisible(isVisible);
        this.myFileNameCombo.setVisible(isVisible);
    }

    private void setChangeValueVisible(boolean isVisible) {
        this.myValueField.setVisible(isVisible);
        this.myValueLabel.setVisible(isVisible);
    }

    private void setChangeNameVisible(boolean isVisible) {
        this.myNameField.setVisible(isVisible);
        this.myNameLabel.setVisible(isVisible);
    }

    private void setChangeModuleVisible(boolean isVisible) {
        this.myModuleLabel.setVisible(isVisible);
        this.myModuleCombo.setVisible(isVisible);
    }

    @Override
    public void updateFilesCombo(List<VirtualFile> directories) {
        Object oldItem = this.myFileNameCombo.getEditor().getItem();
        HashSet<String> fileNameSet = new HashSet<String>();
        for (VirtualFile dir : directories) {
            for (VirtualFile file : dir.getChildren()) {
                fileNameSet.add(file.getName());
            }
        }
        ArrayList fileNames = new ArrayList(fileNameSet);
        Collections.sort(fileNames);
        this.myFileNameCombo.setModel(new DefaultComboBoxModel<Object>(fileNames.toArray()));
        this.myFileNameCombo.getEditor().setItem(oldItem);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JBLabel jBLabel;
        JComboBox jComboBox2;
        JTextField jTextField;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPanel jPanel;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        ModulesComboBox modulesComboBox;
        JTextField jTextField2;
        JBLabel jBLabel6;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 5, 0), -1, -1, false, false));
        this.myNameLabel = jBLabel6 = new JBLabel();
        jBLabel6.setText("Resource name:");
        jBLabel6.setDisplayedMnemonic('N');
        jBLabel6.setDisplayedMnemonicIndex(9);
        jPanel2.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myModuleCombo = modulesComboBox = new ModulesComboBox();
        jPanel2.add((Component)modulesComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myModuleLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("Module:");
        jBLabel5.setDisplayedMnemonic('M');
        jBLabel5.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFileNameLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("File name:");
        jBLabel4.setDisplayedMnemonic('F');
        jBLabel4.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDirectoriesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDirectoriesLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Create the resource in directories:");
        jBLabel3.setDisplayedMnemonic('C');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel3, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myValueLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Resource value:");
        jBLabel2.setDisplayedMnemonic('V');
        jBLabel2.setDisplayedMnemonicIndex(9);
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myValueField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myFileNameCombo = jComboBox2 = new JComboBox();
        jComboBox2.setEditable(true);
        jPanel2.add(jComboBox2, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.mySourceSetLabel = jBLabel = new JBLabel();
        jBLabel.setText("Source set:");
        jBLabel.setDisplayedMnemonic('S');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySourceSetCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jBLabel6.setLabelFor(jTextField2);
        jBLabel5.setLabelFor((Component)modulesComboBox);
        jBLabel4.setLabelFor(jComboBox2);
        jBLabel2.setLabelFor(jTextField);
        jBLabel.setLabelFor((Component)modulesComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

