/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.android.resources.ResourceType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.augment.AndroidLightClass;
import org.jetbrains.android.augment.PermissionClass;
import org.jetbrains.android.augment.PermissionGroupClass;
import org.jetbrains.android.augment.ResourceTypeClass;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidPsiAugmentProvider
extends PsiAugmentProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.augment.AndroidPsiAugmentProvider");

    @NotNull
    public <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type) {
        String resClassName;
        PsiClass parentClass;
        boolean rClassAugment;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/augment/AndroidPsiAugmentProvider", "getAugments"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/augment/AndroidPsiAugmentProvider", "getAugments"));
        }
        if (type != PsiClass.class && type != PsiField.class || !(element instanceof PsiExtensibleClass)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/augment/AndroidPsiAugmentProvider", "getAugments"));
            }
            return list;
        }
        PsiExtensibleClass aClass = (PsiExtensibleClass)element;
        String className = aClass.getName();
        boolean bl = rClassAugment = "R".equals(className) && type == PsiClass.class;
        if (DumbService.isDumb((Project)element.getProject())) {
            if (rClassAugment) {
                LOG.debug("R_CLASS_AUGMENT: empty because of dumb mode");
            }
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/augment/AndroidPsiAugmentProvider", "getAugments"));
            }
            return list;
        }
        AndroidFacet facet = AndroidFacet.getInstance(element);
        if (facet == null) {
            if (rClassAugment) {
                LOG.debug("R_CLASS_AUGMENT: empty because no facet");
            }
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/augment/AndroidPsiAugmentProvider", "getAugments"));
            }
            return list;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            if (rClassAugment) {
                LOG.debug("R_CLASS_AUGMENT: empty because of no containing file");
            }
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/augment/AndroidPsiAugmentProvider", "getAugments"));
            }
            return list;
        }
        if (type == PsiClass.class) {
            if ("R".equals(className) && AndroidResourceUtil.isRJavaFile(facet, containingFile)) {
                Set<String> existingInnerClasses = AndroidPsiAugmentProvider.getOwnInnerClasses(aClass);
                Set<ResourceType> types = ResourceReferenceConverter.getResourceTypesInCurrentModule(facet);
                ArrayList<ResourceTypeClass> result = new ArrayList<ResourceTypeClass>();
                for (ResourceType resType : types) {
                    if (existingInnerClasses.contains(resType.getName())) continue;
                    ResourceTypeClass resClass = new ResourceTypeClass(facet, resType.getName(), (PsiClass)aClass);
                    result.add(resClass);
                }
                if (rClassAugment) {
                    LOG.debug("R_CLASS_AUGMENT: " + result.size() + " classes added");
                }
                ArrayList<ResourceTypeClass> arrayList = result;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/augment/AndroidPsiAugmentProvider", "getAugments"));
                }
                return arrayList;
            }
            if ("Manifest".equals(className) && AndroidResourceUtil.isManifestJavaFile(facet, containingFile)) {
                List<PsiElement> list = Arrays.asList(new PsiElement[]{new PermissionClass(facet, (PsiClass)aClass), new PermissionGroupClass(facet, (PsiClass)aClass)});
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/augment/AndroidPsiAugmentProvider", "getAugments"));
                }
                return list;
            }
            if (rClassAugment) {
                LOG.debug("R_CLASS_AUGMENT: empty because containing file is not actual R.java file");
            }
        } else if (type == PsiField.class && !(aClass instanceof AndroidLightClass) && (parentClass = aClass.getContainingClass()) != null && "R".equals(parentClass.getName()) && AndroidResourceUtil.isRJavaFile(facet, containingFile) && (resClassName = aClass.getName()) != null && ResourceType.getEnum((String)resClassName) != null) {
            Set<String> existingFields = AndroidPsiAugmentProvider.getOwnFields(aClass);
            PsiField[] newFields = ResourceTypeClass.buildLocalResourceFields(facet, resClassName, (PsiClass)aClass);
            ArrayList<PsiField> result = new ArrayList<PsiField>();
            for (PsiField field : newFields) {
                if (existingFields.contains(field.getName())) continue;
                result.add(field);
            }
            ArrayList<PsiField> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/augment/AndroidPsiAugmentProvider", "getAugments"));
            }
            return arrayList;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/augment/AndroidPsiAugmentProvider", "getAugments"));
        }
        return list;
    }

    @NotNull
    private static Set<String> getOwnInnerClasses(@NotNull PsiExtensibleClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/android/augment/AndroidPsiAugmentProvider", "getOwnInnerClasses"));
        }
        HashSet result = new HashSet();
        for (PsiClass innerClass : aClass.getOwnInnerClasses()) {
            result.add(innerClass.getName());
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/augment/AndroidPsiAugmentProvider", "getOwnInnerClasses"));
        }
        return hashSet;
    }

    @NotNull
    private static Set<String> getOwnFields(@NotNull PsiExtensibleClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/android/augment/AndroidPsiAugmentProvider", "getOwnFields"));
        }
        HashSet result = new HashSet();
        for (PsiField field : aClass.getOwnFields()) {
            result.add(field.getName());
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/augment/AndroidPsiAugmentProvider", "getOwnFields"));
        }
        return hashSet;
    }
}

