/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceType;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.codeInspection.magicConstant.MagicCompletionContributor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.ResourceTypeInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceTypeCompletionContributor
extends CompletionContributor {
    private static final ElementPattern<PsiElement> IN_METHOD_CALL_ARGUMENT = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).inside((ElementPattern)PlatformPatterns.psiElement(PsiExpressionList.class).withParent(PsiCall.class)));
    private static final ElementPattern<PsiElement> IN_BINARY_COMPARISON = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).inside((ElementPattern)PlatformPatterns.psiElement(PsiBinaryExpression.class)));
    private static final ElementPattern<PsiElement> IN_ASSIGNMENT = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).inside((ElementPattern)PlatformPatterns.psiElement(PsiAssignmentExpression.class)));
    private static final ElementPattern<PsiElement> IN_RETURN = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).inside((ElementPattern)PlatformPatterns.psiElement(PsiReturnStatement.class)));
    private static final ElementPattern<PsiElement> IN_ANNOTATION_INITIALIZER = ((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(new String[]{"="})).withParent(PsiReferenceExpression.class)).withSuperParent(2, PsiNameValuePair.class)).withSuperParent(3, PsiAnnotationParameterList.class)).withSuperParent(4, PsiAnnotation.class);
    private static final int PRIORITY = 100;

    public void fillCompletionVariants(final @NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/android/inspections/ResourceTypeCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/inspections/ResourceTypeCompletionContributor", "fillCompletionVariants"));
        }
        PsiElement pos = parameters.getPosition();
        if (JavaKeywordCompletion.AFTER_DOT.accepts((Object)pos)) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(pos);
        if (facet == null) {
            return;
        }
        ResourceTypeInspection.Constraints allowedValues = ResourceTypeCompletionContributor.getAllowedValues(pos);
        if (allowedValues == null) {
            return;
        }
        THashSet allowed = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<PsiElement>(){

            public int computeHashCode(PsiElement object) {
                return 0;
            }

            public boolean equals(PsiElement o1, PsiElement o2) {
                return parameters.getOriginalFile().getManager().areElementsEquivalent(o1, o2);
            }
        });
        if (allowedValues instanceof ResourceTypeInspection.ResourceTypeAllowedValues) {
            for (ResourceType resourceType : ((ResourceTypeInspection.ResourceTypeAllowedValues)allowedValues).types) {
                if (resourceType == ResourceEvaluator.COLOR_INT_MARKER_TYPE || resourceType == ResourceEvaluator.DIMENSION_MARKER_TYPE) continue;
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)pos.getProject());
                String code = "R." + resourceType.getName();
                String fqcn = MergedManifest.get(facet).getPackage();
                String qualifiedCode = fqcn + "." + code;
                Project project = facet.getModule().getProject();
                PsiClass cls = JavaPsiFacade.getInstance((Project)project).findClass(qualifiedCode, GlobalSearchScope.allScope((Project)project));
                if (cls != null) {
                    result.addElement((LookupElement)new JavaPsiClassReferenceElement(cls));
                    continue;
                }
                PsiExpression type = factory.createExpressionFromText(code, pos);
                result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)type, (String)code), (double)99.0));
                allowed.add(type);
            }
        } else if (allowedValues instanceof ResourceTypeInspection.AllowedValues) {
            ResourceTypeInspection.AllowedValues a = (ResourceTypeInspection.AllowedValues)allowedValues;
            if (a.canBeOred) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)pos.getProject());
                PsiExpression zero = factory.createExpressionFromText("0", pos);
                result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)zero, (String)"0"), (double)99.0));
                PsiExpression minusOne = factory.createExpressionFromText("-1", pos);
                result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)minusOne, (String)"-1"), (double)99.0));
                allowed.add(zero);
                allowed.add(minusOne);
            }
            List<ExpectedTypeInfo> types = Arrays.asList(JavaSmartCompletionContributor.getExpectedTypes((CompletionParameters)parameters));
            for (PsiAnnotationMemberValue value : a.values) {
                PsiElement resolved;
                if (value instanceof PsiReference && (resolved = ((PsiReference)value).resolve()) instanceof PsiNamedElement) {
                    LookupElement lookupElement = LookupItemUtil.objectToLookupItem((Object)resolved);
                    if (lookupElement instanceof VariableLookupItem) {
                        ((VariableLookupItem)lookupElement).setSubstitutor(PsiSubstitutor.EMPTY);
                    }
                    LookupElement element = PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)100.0);
                    element = ResourceTypeCompletionContributor.decorate(parameters, types, element);
                    result.addElement(element);
                    allowed.add(resolved);
                    continue;
                }
                LookupElementBuilder element = LookupElementBuilder.create((Object)value, (String)value.getText());
                element = ResourceTypeCompletionContributor.decorate(parameters, types, (LookupElement)element);
                result.addElement((LookupElement)element);
                allowed.add(value);
            }
        }
        result.runRemainingContributors(parameters, (Consumer)new Consumer<CompletionResult>((Set)allowed, result){
            final /* synthetic */ Set val$allowed;
            final /* synthetic */ CompletionResultSet val$result;
            {
                this.val$allowed = set;
                this.val$result = completionResultSet;
            }

            public void consume(CompletionResult completionResult) {
                LookupElement element = completionResult.getLookupElement();
                Object object = element.getObject();
                if (object instanceof PsiElement && this.val$allowed.contains(object)) {
                    return;
                }
                this.val$result.passResult(completionResult);
            }
        });
    }

    @Nullable
    private static ResourceTypeInspection.Constraints getAllowedValues(@NotNull PsiElement pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "org/jetbrains/android/inspections/ResourceTypeCompletionContributor", "getAllowedValues"));
        }
        ResourceTypeInspection.Constraints allowedValues = null;
        for (Pair pair : MagicCompletionContributor.getMembersWithAllowedValues((PsiElement)pos)) {
            ResourceTypeInspection.Constraints values = ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)pair.first, (PsiType)pair.second, null);
            if (values == null) continue;
            if (allowedValues == null) {
                allowedValues = values;
                continue;
            }
            if (allowedValues.equals(values)) continue;
            return null;
        }
        return allowedValues;
    }

    private static LookupElement decorate(CompletionParameters parameters, List<ExpectedTypeInfo> types, LookupElement element) {
        if (!types.isEmpty() && parameters.getCompletionType() == CompletionType.SMART) {
            element = JavaSmartCompletionContributor.decorate((LookupElement)element, types);
        }
        return element;
    }
}

