/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.Service;
import org.jetbrains.android.intentions.AbstractRegisterComponentAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AddServiceToManifest
extends AbstractRegisterComponentAction {
    @Nls
    @NotNull
    public String getText() {
        if ("Add service to manifest" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/intentions/AddServiceToManifest", "getText"));
        }
        return "Add service to manifest";
    }

    @Override
    boolean isAvailable(@NotNull PsiClass psiClass, @NotNull Manifest manifest) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/android/intentions/AddServiceToManifest", "isAvailable"));
        }
        if (manifest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifest", "org/jetbrains/android/intentions/AddServiceToManifest", "isAvailable"));
        }
        if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (boolean)true, (String)"android.app.Service")) {
            return false;
        }
        return !AddServiceToManifest.isRegisteredService(psiClass, manifest.getApplication());
    }

    @Override
    void invoke(@NotNull PsiClass psiClass, @NotNull Manifest manifest) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/android/intentions/AddServiceToManifest", "invoke"));
        }
        if (manifest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifest", "org/jetbrains/android/intentions/AddServiceToManifest", "invoke"));
        }
        Application application = manifest.getApplication();
        application.addService().getServiceClass().setValue(psiClass);
    }

    private static boolean isRegisteredService(PsiClass psiClass, Application application) {
        for (Service service : application.getServices()) {
            if (!psiClass.isEquivalentTo((PsiElement)service.getServiceClass().getValue())) continue;
            return true;
        }
        return false;
    }
}

