/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPlatform {
    @NotNull
    private final AndroidSdkData mySdkData;
    @NotNull
    private final IAndroidTarget myTarget;

    public AndroidPlatform(@NotNull AndroidSdkData sdkData, @NotNull IAndroidTarget target) {
        if (sdkData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkData", "org/jetbrains/android/sdk/AndroidPlatform", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidPlatform", "<init>"));
        }
        this.mySdkData = sdkData;
        this.myTarget = target;
    }

    @Nullable
    public static AndroidPlatform getInstance(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/sdk/AndroidPlatform", "getInstance"));
        }
        if (module.isDisposed()) {
            return null;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        return sdk != null ? AndroidPlatform.getInstance(sdk) : null;
    }

    @Nullable
    public static AndroidPlatform getInstance(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/android/sdk/AndroidPlatform", "getInstance"));
        }
        AndroidSdkAdditionalData data = AndroidSdks.getInstance().getAndroidSdkAdditionalData(sdk);
        return data != null ? data.getAndroidPlatform() : null;
    }

    @NotNull
    public AndroidSdkData getSdkData() {
        AndroidSdkData androidSdkData = this.mySdkData;
        if (androidSdkData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidPlatform", "getSdkData"));
        }
        return androidSdkData;
    }

    @NotNull
    public IAndroidTarget getTarget() {
        IAndroidTarget iAndroidTarget = this.myTarget;
        if (iAndroidTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidPlatform", "getTarget"));
        }
        return iAndroidTarget;
    }

    @Nullable
    public static AndroidPlatform parse(@NotNull Sdk sdk) {
        IAndroidTarget target;
        SdkAdditionalData data;
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/android/sdk/AndroidPlatform", "parse"));
        }
        if (!AndroidSdks.getInstance().isAndroidSdk(sdk)) {
            return null;
        }
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
        if (sdkData != null && (data = sdk.getSdkAdditionalData()) instanceof AndroidSdkAdditionalData && (target = ((AndroidSdkAdditionalData)data).getBuildTarget(sdkData)) != null) {
            return new AndroidPlatform(sdkData, target);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static AndroidPlatform parse(@NotNull Library library, @Nullable Library.ModifiableModel model, @Nullable Map<String, AndroidSdkData> parsedSdks) {
        VirtualFile sdkDir;
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/android/sdk/AndroidPlatform", "parse"));
        }
        VirtualFile[] files = model != null ? model.getFiles(OrderRootType.CLASSES) : library.getFiles(OrderRootType.CLASSES);
        HashSet jarPaths = Sets.newHashSet();
        VirtualFile frameworkLibrary = null;
        for (VirtualFile file : files) {
            VirtualFile vFile = JarFileSystem.getInstance().getVirtualFileForJar(file);
            if (vFile == null) continue;
            if (vFile.getName().equals("android.jar")) {
                frameworkLibrary = vFile;
            }
            jarPaths.add(vFile.getPath());
        }
        if (frameworkLibrary != null && (sdkDir = frameworkLibrary.getParent()) != null) {
            AndroidSdkData sdkData;
            VirtualFile platformsDir = sdkDir.getParent();
            if (platformsDir != null && platformsDir.getName().equals("platforms") && (sdkDir = platformsDir.getParent()) == null) {
                return null;
            }
            String sdkPath = sdkDir.getPath();
            AndroidSdkData androidSdkData = sdkData = parsedSdks != null ? parsedSdks.get(sdkPath) : null;
            if (sdkData == null) {
                sdkData = AndroidSdkData.getSdkData(sdkPath);
                if (sdkData == null) {
                    return null;
                }
                if (parsedSdks != null) {
                    parsedSdks.put(sdkPath, sdkData);
                }
            }
            IAndroidTarget resultTarget = null;
            for (IAndroidTarget target : sdkData.getTargets()) {
                String targetsFrameworkLibPath = PathUtil.getCanonicalPath((String)target.getPath(1));
                if (!frameworkLibrary.getPath().equals(targetsFrameworkLibPath)) continue;
                if (target.isPlatform()) {
                    if (resultTarget != null) continue;
                    resultTarget = target;
                    continue;
                }
                boolean ok = true;
                List libraries = target.getAdditionalLibraries();
                if (libraries.isEmpty()) {
                    ok = false;
                } else {
                    for (IAndroidTarget.OptionalLibrary optionalLibrary : libraries) {
                        if (jarPaths.contains(PathUtil.getCanonicalPath((String)optionalLibrary.getJar().getAbsolutePath()))) continue;
                        ok = false;
                    }
                }
                if (!ok) continue;
                resultTarget = target;
            }
            if (resultTarget != null) {
                return new AndroidPlatform(sdkData, resultTarget);
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidPlatform platform = (AndroidPlatform)o;
        if (!this.mySdkData.equals(platform.mySdkData)) {
            return false;
        }
        return this.myTarget.equals(platform.myTarget);
    }

    public int hashCode() {
        int result = this.mySdkData.hashCode();
        result = 31 * result + this.myTarget.hashCode();
        return result;
    }

    public boolean needToAddAnnotationsJarToClasspath() {
        return AndroidSdks.getInstance().needsAnnotationsJarInClasspath(this.myTarget);
    }

    public int getApiLevel() {
        return this.myTarget.getVersion().getApiLevel();
    }

    @NotNull
    public AndroidVersion getApiVersion() {
        AndroidVersion androidVersion = this.myTarget.getVersion();
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidPlatform", "getApiVersion"));
        }
        return androidVersion;
    }
}

