/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.klint.checks.ApiLookup;
import com.android.tools.klint.checks.RtlDetector;
import com.android.tools.klint.client.api.IssueRegistry;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.client.api.LintDriver;
import com.android.tools.klint.client.api.UastLintUtils;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.ClassContext;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.DefaultPosition;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Position;
import com.android.tools.klint.detector.api.ResourceXmlDetector;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.inspections.klint.IntellijLintUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApiDetector
extends ResourceXmlDetector
implements Detector.ClassScanner,
Detector.UastScanner {
    private static final String ATTR_WIDTH = "width";
    private static final String ATTR_HEIGHT = "height";
    private static final String ATTR_SUPPORTS_RTL = "supportsRtl";
    public static final String REQUIRES_API_ANNOTATION = "android.support.annotation.RequiresApi";
    public static final Issue UNSUPPORTED = Issue.create("NewApi", "Calling new methods on older versions", "This check scans through all the Android API calls in the application and warns about any calls that are not available on *all* versions targeted by this application (according to its minimum SDK attribute in the manifest).\n\nIf you really want to use this API and don't need to support older devices just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` files.\n\nIf your code is *deliberately* accessing newer APIs, and you have ensured (e.g. with conditional execution) that this code will only ever be called on a supported platform, then you can annotate your class or method with the `@TargetApi` annotation specifying the local minimum SDK to apply, such as `@TargetApi(11)`, such that this check considers 11 rather than your manifest file's minimum SDK as the required API level.\n\nIf you are deliberately setting `android:` attributes in style definitions, make sure you place this in a `values-vNN` folder in order to avoid running into runtime conflicts on certain devices where manufacturers have added custom attributes whose ids conflict with the new ones on later platforms.\n\nSimilarly, you can use tools:targetApi=\"11\" in an XML file to indicate that the element will only be inflated in an adequate context.", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(ApiDetector.class, EnumSet.of(Scope.JAVA_FILE, Scope.RESOURCE_FILE, Scope.MANIFEST), Scope.JAVA_FILE_SCOPE, Scope.RESOURCE_FILE_SCOPE, Scope.MANIFEST_SCOPE));
    public static final Issue INLINED = Issue.create("InlinedApi", "Using inlined constants on older versions", "This check scans through all the Android API field references in the application and flags certain constants, such as static final integers and Strings, which were introduced in later versions. These will actually be copied into the class files rather than being referenced, which means that the value is available even when running on older devices. In some cases that's fine, and in other cases it can result in a runtime crash or incorrect behavior. It depends on the context, so consider the code carefully and device whether it's safe and can be suppressed or whether the code needs tbe guarded.\n\nIf you really want to use this API and don't need to support older devices just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` files.\nIf your code is *deliberately* accessing newer APIs, and you have ensured (e.g. with conditional execution) that this code will only ever be called on a supported platform, then you can annotate your class or method with the `@TargetApi` annotation specifying the local minimum SDK to apply, such as `@TargetApi(11)`, such that this check considers 11 rather than your manifest file's minimum SDK as the required API level.\n", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(ApiDetector.class, Scope.JAVA_FILE_SCOPE));
    public static final Issue OVERRIDE = Issue.create("Override", "Method conflicts with new inherited method", "Suppose you are building against Android API 8, and you've subclassed Activity. In your subclass you add a new method called `isDestroyed`(). At some later point, a method of the same name and signature is added to Android. Your method will now override the Android method, and possibly break its contract. Your method is not calling `super.isDestroyed()`, since your compilation target doesn't know about the method.\n\nThe above scenario is what this lint detector looks for. The above example is real, since `isDestroyed()` was added in API 17, but it will be true for *any* method you have added to a subclass of an Android class where your build target is lower than the version the method was introduced in.\n\nTo fix this, either rename your method, or if you are really trying to augment the builtin method if available, switch to a higher build target where you can deliberately add `@Override` on your overriding method, and call `super` if appropriate etc.\n", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(ApiDetector.class, Scope.CLASS_FILE_SCOPE));
    public static final Issue UNUSED = Issue.create("UnusedAttribute", "Attribute unused on older versions", "This check finds attributes set in XML files that were introduced in a version newer than the oldest version targeted by your application (with the `minSdkVersion` attribute).\n\nThis is not an error; the application will simply ignore the attribute. However, if the attribute is important to the appearance of functionality of your application, you should consider finding an alternative way to achieve the same result with only available attributes, and then you can optionally create a copy of the layout in a layout-vNN folder which will be used on API NN or higher where you can take advantage of the newer attribute.\n\nNote: This check does not only apply to attributes. For example, some tags can be unused too, such as the new `<tag>` element in layouts introduced in API 21.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(ApiDetector.class, Scope.RESOURCE_FILE_SCOPE));
    private static final String TAG_RIPPLE = "ripple";
    private static final String TAG_VECTOR = "vector";
    private static final String TAG_ANIMATED_VECTOR = "animated-vector";
    private static final String TAG_ANIMATED_SELECTOR = "animated-selector";
    private static final String SDK_INT = "SDK_INT";
    private static final String REFLECTIVE_OPERATION_EXCEPTION = "java.lang.ReflectiveOperationException";
    public static final String ERROR = "error";
    private ApiLookup mApiDatabase;
    private boolean mWarnedMissingDb;
    private int mMinApi = -1;

    @Override
    public void beforeCheckProject(Context context) {
        if (this.mApiDatabase == null) {
            this.mApiDatabase = ApiLookup.get(context.getClient());
            if (this.mApiDatabase == null && !this.mWarnedMissingDb) {
                this.mWarnedMissingDb = true;
                context.report(IssueRegistry.LINT_ERROR, Location.create(context.file), "Can't find API database; API check not performed");
            } else {
                Location location;
                AndroidSdkHandler sdk = context.getClient().getSdk();
                if (sdk == null) {
                    return;
                }
                LocalPackage pkgInfo = sdk.getLocalPackage("platform-tools", context.getClient().getRepositoryLogger());
                if (pkgInfo == null) {
                    return;
                }
                Revision revision = pkgInfo.getVersion();
                int compileSdkVersion = context.getProject().getBuildSdk();
                if (compileSdkVersion == 23 ? revision.getMajor() > 23 || revision.getMajor() == 23 && (revision.getMinor() > 0 || revision.getMicro() > 0) : compileSdkVersion <= revision.getMajor()) {
                    return;
                }
                List<File> currentFiles = context.getProject().getSubset();
                if (currentFiles != null && currentFiles.size() == 1) {
                    File file = currentFiles.get(0);
                    String contents = context.getClient().readFile(file);
                    int firstLineEnd = contents.indexOf(10);
                    if (firstLineEnd == -1) {
                        firstLineEnd = contents.length();
                    }
                    location = Location.create(file, new DefaultPosition(0, 0, 0), new DefaultPosition(0, firstLineEnd, firstLineEnd));
                } else {
                    location = Location.create(context.file);
                }
                context.report(UNSUPPORTED, location, String.format("The SDK platform-tools version (%1$s) is too old  to check APIs compiled with API %2$d; please update", revision.toShortString(), compileSdkVersion));
            }
        }
    }

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return true;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return ALL;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    @Override
    public void visitAttribute(XmlContext context, Attr attribute) {
        int api;
        int minSdk;
        String prefix;
        String message;
        Location location;
        String owner;
        if (this.mApiDatabase == null) {
            return;
        }
        int attributeApiLevel = -1;
        if ("http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
            int minSdk2;
            String name = attribute.getLocalName();
            if (!(name.equals("layout_width") && !name.equals("layout_height") && !name.equals("id") || (attributeApiLevel = this.mApiDatabase.getFieldVersion(owner = "android/R$attr", name)) <= (minSdk2 = this.getMinSdk(context)) || attributeApiLevel <= context.getFolderVersion() || attributeApiLevel <= ApiDetector.getLocalMinSdk(attribute.getOwnerElement()) || ApiDetector.isBenignUnusedAttribute(name) || ApiDetector.isAlreadyWarnedDrawableFile(context, attribute, attributeApiLevel))) {
                if (RtlDetector.isRtlAttributeName(name) || ATTR_SUPPORTS_RTL.equals(name)) {
                    if (name.equals("paddingStart")) {
                        boolean isOldBuildTools;
                        BuildToolInfo buildToolInfo = context.getProject().getBuildTools();
                        Revision buildTools = buildToolInfo != null ? buildToolInfo.getRevision() : null;
                        boolean bl = isOldBuildTools = buildTools != null && (buildTools.getMajor() < 23 || buildTools.getMajor() == 23 && buildTools.getMinor() == 0 && buildTools.getMicro() == 0);
                        if ((buildTools == null || isOldBuildTools) && ApiDetector.viewMayExtendTextView(attribute.getOwnerElement())) {
                            location = context.getLocation(attribute);
                            message = String.format("Attribute `%1$s` referenced here can result in a crash on some specific devices older than API %2$d (current min is %3$d)", attribute.getLocalName(), attributeApiLevel, minSdk2);
                            if (buildTools != null) {
                                message = String.format("Upgrade `buildToolsVersion` from `%1$s` to at least `23.0.1`; if not, ", buildTools.toShortString()) + Character.toLowerCase(message.charAt(0)) + message.substring(1);
                            }
                            context.report(UNSUPPORTED, attribute, location, message);
                        }
                    }
                } else {
                    Location location2 = context.getLocation(attribute);
                    String message2 = String.format("Attribute `%1$s` is only used in API level %2$d and higher (current min is %3$d)", attribute.getLocalName(), attributeApiLevel, minSdk2);
                    context.report(UNUSED, attribute, location2, message2);
                }
            }
            if (name.equals("divider")) {
                return;
            }
        }
        String value2 = attribute.getValue();
        owner = null;
        String name = null;
        if (value2.startsWith("@android:")) {
            prefix = "@android:";
        } else if (value2.startsWith("?android:")) {
            int api2;
            prefix = "?android:";
            if (context.getResourceFolderType() == ResourceFolderType.DRAWABLE && (api2 = 21) > (minSdk = this.getMinSdk(context)) && api2 > context.getFolderVersion() && api2 > ApiDetector.getLocalMinSdk(attribute.getOwnerElement())) {
                location = context.getLocation(attribute);
                message = String.format("Using theme references in XML drawables requires API level %1$d (current min is %2$d)", api2, minSdk);
                context.report(UNSUPPORTED, attribute, location, message);
                return;
            }
        } else if (value2.startsWith("android:") && "name".equals(attribute.getName()) && "item".equals(attribute.getOwnerElement().getTagName()) && attribute.getOwnerElement().getParentNode() != null && "style".equals(attribute.getOwnerElement().getParentNode().getNodeName())) {
            owner = "android/R$attr";
            name = value2.substring("android:".length());
            prefix = null;
        } else if (value2.startsWith("android:") && "parent".equals(attribute.getName()) && "style".equals(attribute.getOwnerElement().getTagName())) {
            owner = "android/R$style";
            name = SdkUtils.getResourceFieldName((String)value2.substring("android:".length()));
            prefix = null;
        } else {
            return;
        }
        if (owner == null) {
            int index = value2.indexOf(47, prefix.length());
            if (index != -1) {
                owner = "android/R$" + value2.substring(prefix.length(), index);
                name = SdkUtils.getResourceFieldName((String)value2.substring(index + 1));
            } else if (value2.startsWith("?android:")) {
                owner = "android/R$attr";
                name = value2.substring("?android:".length());
            } else {
                return;
            }
        }
        if ((api = this.mApiDatabase.getFieldVersion(owner, name)) > (minSdk = this.getMinSdk(context)) && api > context.getFolderVersion() && api > ApiDetector.getLocalMinSdk(attribute.getOwnerElement())) {
            if ("http://schemas.android.com/tools".equals(attribute.getNamespaceURI())) {
                return;
            }
            if (attributeApiLevel < api) {
                if (attributeApiLevel > minSdk) {
                    String attributeName = attribute.getLocalName();
                    Location location3 = context.getLocation(attribute);
                    String message3 = String.format("`%1$s` requires API level %2$d (current min is %3$d), but note that attribute `%4$s` is only used in API level %5$d and higher", name, api, minSdk, attributeName, attributeApiLevel);
                    context.report(UNSUPPORTED, attribute, location3, message3);
                } else {
                    location = context.getLocation(attribute);
                    message = String.format("`%1$s` requires API level %2$d (current min is %3$d)", value2, api, minSdk);
                    context.report(UNSUPPORTED, attribute, location, message);
                }
            }
        }
    }

    private static boolean viewMayExtendTextView(Element element) {
        String tag = element.getTagName();
        if (tag.equals("view") && ((tag = element.getAttribute("class")) == null || tag.isEmpty())) {
            return false;
        }
        if (tag.indexOf(46) != -1) {
            return true;
        }
        return tag.contains("Text") || tag.contains("Button") || tag.equals("DigitalClock") || tag.equals("Chronometer") || tag.equals("CheckBox") || tag.equals("Switch");
    }

    private static boolean isAlreadyWarnedDrawableFile(XmlContext context, Attr attribute, int attributeApiLevel) {
        String root;
        return context.getResourceFolderType() == ResourceFolderType.DRAWABLE && attributeApiLevel == 21 && (TAG_RIPPLE.equals(root = attribute.getOwnerDocument().getDocumentElement().getTagName()) || TAG_VECTOR.equals(root) || TAG_ANIMATED_VECTOR.equals(root) || TAG_ANIMATED_SELECTOR.equals(root));
    }

    private static boolean isBenignUnusedAttribute(String name) {
        return "labelFor".equals(name) || "textIsSelectable".equals(name) || "textAlignment".equals(name) || "fullBackupContent".equals(name);
    }

    @Override
    public void visitElement(XmlContext context, Element element) {
        if (this.mApiDatabase == null) {
            return;
        }
        String tag = element.getTagName();
        ResourceFolderType folderType = context.getResourceFolderType();
        if (folderType != ResourceFolderType.LAYOUT) {
            if (folderType == ResourceFolderType.DRAWABLE) {
                this.checkElement(context, element, TAG_VECTOR, 21, "1.4", UNSUPPORTED);
                this.checkElement(context, element, TAG_RIPPLE, 21, null, UNSUPPORTED);
                this.checkElement(context, element, TAG_ANIMATED_SELECTOR, 21, null, UNSUPPORTED);
                this.checkElement(context, element, TAG_ANIMATED_VECTOR, 21, null, UNSUPPORTED);
                this.checkElement(context, element, "drawable", 24, null, UNSUPPORTED);
                if ("layer-list".equals(tag)) {
                    this.checkLevelList(context, element);
                } else if (tag.contains(".")) {
                    this.checkElement(context, element, tag, 24, null, UNSUPPORTED);
                }
            }
            if (element.getParentNode().getNodeType() != 1) {
                return;
            }
            NodeList childNodes = element.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                int minSdk;
                String name;
                String owner;
                int api;
                String typeString;
                int index;
                String text;
                Node textNode = childNodes.item(i);
                if (textNode.getNodeType() != 3 || !(text = textNode.getNodeValue()).contains("@android:") || (index = (text = text.trim()).indexOf(47, "@android:".length())) == -1 || ResourceType.getEnum((String)(typeString = text.substring("@android:".length(), index))) == null || (api = this.mApiDatabase.getFieldVersion(owner = "android/R$" + typeString, name = SdkUtils.getResourceFieldName((String)text.substring(index + 1)))) <= (minSdk = this.getMinSdk(context)) || api <= context.getFolderVersion() || api <= ApiDetector.getLocalMinSdk(element)) continue;
                Location location = context.getLocation(textNode);
                String message = String.format("`%1$s` requires API level %2$d (current min is %3$d)", text, api, minSdk);
                context.report(UNSUPPORTED, element, location, message);
            }
        } else {
            int minSdk;
            int api;
            if ("view".equals(tag)) {
                tag = element.getAttribute("class");
                if (tag == null || tag.isEmpty()) {
                    return;
                }
            } else {
                this.checkElement(context, element, "tag", 21, null, UNUSED);
            }
            if (tag.indexOf(46) != -1) {
                return;
            }
            String fqn = "android/widget/" + tag;
            if (tag.equals("TextureView")) {
                fqn = "android/view/TextureView";
            }
            if ((api = this.mApiDatabase.getClassVersion(fqn)) > (minSdk = this.getMinSdk(context)) && api > context.getFolderVersion() && api > ApiDetector.getLocalMinSdk(element)) {
                Location location = context.getLocation(element);
                String message = String.format("View requires API level %1$d (current min is %2$d): `<%3$s>`", api, minSdk, tag);
                context.report(UNSUPPORTED, element, location, message);
            }
        }
    }

    private void checkLevelList(XmlContext context, Element element) {
        for (Node curr = element.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
            int minSdk;
            int attributeApiLevel;
            Element e;
            if (curr.getNodeType() != 1 || !"item".equals(curr.getNodeName()) || !(e = (Element)curr).hasAttributeNS("http://schemas.android.com/apk/res/android", ATTR_WIDTH) && !e.hasAttributeNS("http://schemas.android.com/apk/res/android", ATTR_HEIGHT) || (attributeApiLevel = 23) <= (minSdk = this.getMinSdk(context)) || attributeApiLevel <= context.getFolderVersion() || attributeApiLevel <= ApiDetector.getLocalMinSdk(element)) continue;
            for (String attributeName : new String[]{ATTR_WIDTH, ATTR_HEIGHT}) {
                Attr attribute = e.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
                if (attribute == null) continue;
                Location location = context.getLocation(attribute);
                String message = String.format("Attribute `%1$s` is only used in API level %2$d and higher (current min is %3$d)", attribute.getLocalName(), attributeApiLevel, minSdk);
                context.report(UNUSED, attribute, location, message);
            }
        }
    }

    private void checkElement(XmlContext context, Element element, String tag, int api, String gradleVersion, Issue issue) {
        int minSdk;
        if (tag.equals(element.getTagName()) && api > (minSdk = this.getMinSdk(context)) && api > context.getFolderVersion() && api > ApiDetector.getLocalMinSdk(element) && !ApiDetector.featureProvidedByGradle(context, gradleVersion)) {
            String message;
            Location location = context.getLocation(element);
            if ("drawable".equals(tag)) {
                Attr attribute = element.getAttributeNode("class");
                if (attribute == null) {
                    return;
                }
                location = context.getLocation(attribute);
                tag = "class";
            }
            if (issue == UNSUPPORTED) {
                message = String.format("`<%1$s>` requires API level %2$d (current min is %3$d)", tag, api, minSdk);
                if (gradleVersion != null) {
                    message = message + String.format(" or building with Android Gradle plugin %1$s or higher", gradleVersion);
                } else if (tag.contains(".")) {
                    message = String.format("Custom drawables requires API level %1$d (current min is %2$d)", api, minSdk);
                }
            } else {
                assert (issue == UNUSED) : issue;
                message = String.format("`<%1$s>` is only used in API level %2$d and higher (current min is %3$d)", tag, api, minSdk);
            }
            context.report(issue, element, location, message);
        }
    }

    protected int getMinSdk(Context context) {
        if (this.mMinApi == -1) {
            AndroidVersion minSdkVersion = context.getMainProject().getMinSdkVersion();
            this.mMinApi = minSdkVersion.getFeatureLevel();
        }
        return this.mMinApi;
    }

    private static int getLocalMinSdk(Element element) {
        while (element != null) {
            String targetApi = element.getAttributeNS("http://schemas.android.com/tools", "targetApi");
            if (targetApi != null && !targetApi.isEmpty()) {
                if (Character.isDigit(targetApi.charAt(0))) {
                    try {
                        return Integer.parseInt(targetApi);
                    }
                    catch (NumberFormatException e) {
                        break;
                    }
                }
                return SdkVersionInfo.getApiByBuildCode((String)targetApi, (boolean)true);
            }
            Node parent = element.getParentNode();
            if (parent == null || parent.getNodeType() != 1) break;
            element = (Element)parent;
        }
        return -1;
    }

    private static boolean featureProvidedByGradle(XmlContext context, String minGradleVersionString) {
        GradleVersion minVersion;
        if (minGradleVersionString == null) {
            return false;
        }
        GradleVersion gradleModelVersion = context.getProject().getGradleModelVersion();
        return gradleModelVersion != null && (minVersion = GradleVersion.tryParse((String)minGradleVersionString)) != null && gradleModelVersion.compareIgnoringQualifiers(minVersion) >= 0;
    }

    @Override
    public UastVisitor createUastVisitor(JavaContext context) {
        if (this.mApiDatabase == null) {
            return new AbstractUastVisitor(){

                public boolean visitElement(@NotNull UElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/klint/checks/ApiDetector$1", "visitElement"));
                    }
                    return super.visitElement(element);
                }
            };
        }
        return new ApiVisitor(context);
    }

    @Override
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        ArrayList<Class<? extends UElement>> types = new ArrayList<Class<? extends UElement>>(9);
        types.add(UImportStatement.class);
        types.add(USimpleNameReferenceExpression.class);
        types.add(UVariable.class);
        types.add(UTryExpression.class);
        types.add(UBinaryExpressionWithType.class);
        types.add(UBinaryExpression.class);
        types.add(UCallExpression.class);
        types.add(UClass.class);
        types.add(UTypeReferenceExpression.class);
        types.add(UClassLiteralExpression.class);
        types.add(UMethod.class);
        return types;
    }

    private static boolean isBenignConstantUsage(UElement node, String name, String owner) {
        if (owner.equals("android/os/Build$VERSION_CODES")) {
            return true;
        }
        if (owner.equals("android/view/ViewGroup$LayoutParams") && name.equals("MATCH_PARENT")) {
            return true;
        }
        if (owner.equals("android/widget/AbsListView") && (name.equals("CHOICE_MODE_NONE") || name.equals("CHOICE_MODE_MULTIPLE") || name.equals("CHOICE_MODE_SINGLE"))) {
            return true;
        }
        if ("android/view/Gravity".equals(owner) && ("START".equals(name) || "END".equals(name))) {
            return true;
        }
        if (node == null) {
            return false;
        }
        for (UElement curr = node.getUastParent(); curr != null; curr = curr.getUastParent()) {
            if (curr instanceof USwitchClauseExpression) {
                List caseValues2 = ((USwitchClauseExpression)curr).getCaseValues();
                if (caseValues2 != null) {
                    for (UExpression condition2 : caseValues2) {
                        if (condition2 == null || !UastUtils.isChildOf((UElement)node, (UElement)condition2, (boolean)false)) continue;
                        return true;
                    }
                }
                return false;
            }
            if (curr instanceof UIfExpression) {
                UExpression condition3 = ((UIfExpression)curr).getCondition();
                return UastUtils.isChildOf((UElement)node, (UElement)condition3, (boolean)false);
            }
            if (curr instanceof UMethod || curr instanceof UClass) break;
        }
        return false;
    }

    public static int getRequiredVersion(String errorMessage) {
        Pattern pattern = Pattern.compile("\\s(\\d+)\\s");
        Matcher matcher = pattern.matcher(errorMessage);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    private static boolean isSuppressed(int api, UElement element, int minSdk, JavaContext context, Issue issue) {
        if (api <= minSdk) {
            return true;
        }
        int target = ApiDetector.getTargetApi(element);
        if (target != -1 && api <= target) {
            return true;
        }
        LintDriver driver = context.getDriver();
        if (driver.isSuppressed(context, issue, element)) {
            return true;
        }
        if (ApiDetector.isWithinVersionCheckConditional(element, api, context)) {
            return true;
        }
        return ApiDetector.isPrecededByVersionCheckExit(element, api, context);
    }

    private static int getTargetApi(UElement scope) {
        while (scope != null) {
            PsiModifierList modifierList;
            int targetApi;
            if (scope instanceof PsiModifierListOwner && (targetApi = ApiDetector.getTargetApi(modifierList = ((PsiModifierListOwner)scope).getModifierList())) != -1) {
                return targetApi;
            }
            if (!((scope = scope.getUastParent()) instanceof PsiFile)) continue;
            break;
        }
        return -1;
    }

    public static int getTargetApi(PsiModifierList modifierList) {
        if (modifierList == null) {
            return -1;
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            String fqcn = annotation.getQualifiedName();
            if (fqcn == null || !fqcn.equals("android.annotation.TargetApi") && !fqcn.equals(REQUIRES_API_ANNOTATION) && !fqcn.equals("TargetApi")) continue;
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            for (PsiNameValuePair pair : parameterList.getAttributes()) {
                PsiAnnotationMemberValue v = pair.getValue();
                if (v instanceof PsiLiteral) {
                    PsiLiteral literal = (PsiLiteral)v;
                    Object value2 = literal.getValue();
                    if (value2 instanceof Integer) {
                        return (Integer)value2;
                    }
                    if (!(value2 instanceof String)) continue;
                    return ApiDetector.codeNameToApi((String)value2);
                }
                if (v instanceof PsiArrayInitializerMemberValue) {
                    PsiArrayInitializerMemberValue mv = (PsiArrayInitializerMemberValue)v;
                    for (PsiAnnotationMemberValue mmv : mv.getInitializers()) {
                        if (!(mmv instanceof PsiLiteral)) continue;
                        PsiLiteral literal = (PsiLiteral)mmv;
                        Object value3 = literal.getValue();
                        if (value3 instanceof Integer) {
                            return (Integer)value3;
                        }
                        if (!(value3 instanceof String)) continue;
                        return ApiDetector.codeNameToApi((String)value3);
                    }
                    continue;
                }
                if (!(v instanceof PsiExpression)) continue;
                if (v instanceof PsiReferenceExpression) {
                    String name = ((PsiReferenceExpression)v).getQualifiedName();
                    return ApiDetector.codeNameToApi(name);
                }
                return ApiDetector.codeNameToApi(v.getText());
            }
        }
        return -1;
    }

    private static int codeNameToApi(String text) {
        int dotIndex = text.lastIndexOf(46);
        if (dotIndex != -1) {
            text = text.substring(dotIndex + 1);
        }
        return SdkVersionInfo.getApiByBuildCode((String)text, (boolean)true);
    }

    private static boolean isPrecededByVersionCheckExit(UElement element, int api, JavaContext context) {
        UExpression currentExpression = (UExpression)UastUtils.getParentOfType((UElement)element, UExpression.class, (boolean)true, (Class[])new Class[]{UMethod.class, UClass.class});
        while (currentExpression != null) {
            VersionCheckWithExitFinder visitor = new VersionCheckWithExitFinder(currentExpression, element, api, context);
            currentExpression.accept((UastVisitor)visitor);
            if (visitor.found()) {
                return true;
            }
            element = currentExpression;
            currentExpression = (UExpression)UastUtils.getParentOfType((UElement)currentExpression, UExpression.class, (boolean)true, (Class[])new Class[]{UMethod.class, UClass.class});
        }
        return false;
    }

    private static boolean isUnconditionalReturn(UExpression expression2) {
        if (expression2 instanceof UBlockExpression) {
            List expressions2 = ((UBlockExpression)expression2).getExpressions();
            return !expressions2.isEmpty() && ApiDetector.isUnconditionalReturn((UExpression)expressions2.get(expressions2.size() - 1));
        }
        return expression2 instanceof UReturnExpression || expression2 instanceof UThrowExpression || expression2 instanceof UCallExpression && ERROR.equals(((UCallExpression)expression2).getMethodName());
    }

    private static boolean isWithinVersionCheckConditional(UElement element, int api, JavaContext context) {
        UElement prev = element;
        for (UElement current = element.getUastParent(); current != null; current = current.getUastParent()) {
            if (current instanceof UIfExpression) {
                UIfExpression ifStatement = (UIfExpression)current;
                Boolean isConditional = ApiDetector.isVersionCheckConditional(api, prev, ifStatement, context);
                if (isConditional != null) {
                    return isConditional;
                }
            } else if (current instanceof UBinaryExpression) {
                if (ApiDetector.isAndedWithConditional(current, api, prev) || ApiDetector.isOredWithConditional(current, api, prev)) {
                    return true;
                }
            } else if (current instanceof UMethod || current instanceof UFile) {
                return false;
            }
            prev = current;
        }
        return false;
    }

    private static Boolean isVersionCheckConditional(int api, UElement prev, UIfExpression ifStatement, JavaContext context) {
        Boolean isConditional;
        UReturnExpression returnStatement;
        UExpression returnValue;
        UExpression statement;
        UExpression body2;
        List expressions2;
        UCallExpression call;
        PsiMethod method;
        UExpression condition2 = ifStatement.getCondition();
        if (condition2 != prev && condition2 instanceof UBinaryExpression) {
            Boolean isConditional2 = ApiDetector.isVersionCheckConditional(api, prev, ifStatement, (UBinaryExpression)condition2);
            if (isConditional2 != null) {
                return isConditional2;
            }
        } else if (condition2 instanceof UCallExpression && (method = (call = (UCallExpression)condition2).resolve()) != null && !method.hasModifierProperty("abstract") && (expressions2 = (body2 = context.getUastContext().getMethodBody(method)) instanceof UBlockExpression ? ((UBlockExpression)body2).getExpressions() : Collections.singletonList(body2)).size() == 1 && (statement = (UExpression)expressions2.get(0)) instanceof UReturnExpression && (returnValue = (returnStatement = (UReturnExpression)statement).getReturnExpression()) instanceof UBinaryExpression && (isConditional = ApiDetector.isVersionCheckConditional(api, null, null, (UBinaryExpression)returnValue)) != null) {
            return isConditional;
        }
        return null;
    }

    private static Boolean isVersionCheckConditional(int api, UElement prev, UIfExpression ifStatement, UBinaryExpression binary) {
        UastBinaryOperator tokenType = binary.getOperator();
        if (tokenType == UastBinaryOperator.GREATER || tokenType == UastBinaryOperator.GREATER_OR_EQUALS || tokenType == UastBinaryOperator.LESS_OR_EQUALS || tokenType == UastBinaryOperator.LESS || tokenType == UastBinaryOperator.EQUALS || tokenType == UastBinaryOperator.IDENTITY_EQUALS) {
            UReferenceExpression ref;
            UExpression left = binary.getLeftOperand();
            if (left instanceof UReferenceExpression && SDK_INT.equals((ref = (UReferenceExpression)left).getResolvedName())) {
                ULiteralExpression lit;
                Object value2;
                UExpression right = binary.getRightOperand();
                int level = -1;
                if (right instanceof UReferenceExpression) {
                    UReferenceExpression ref2 = (UReferenceExpression)right;
                    String codeName = ref2.getResolvedName();
                    if (codeName == null) {
                        return false;
                    }
                    level = SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)true);
                } else if (right instanceof ULiteralExpression && (value2 = (lit = (ULiteralExpression)right).getValue()) instanceof Integer) {
                    level = (Integer)value2;
                }
                if (level != -1) {
                    boolean fromElse;
                    boolean fromThen = ifStatement == null || prev == ifStatement.getThenExpression();
                    boolean bl = fromElse = ifStatement != null && prev == ifStatement.getElseExpression();
                    assert (fromThen == !fromElse);
                    if (tokenType == UastBinaryOperator.GREATER_OR_EQUALS) {
                        return level >= api && fromThen;
                    }
                    if (tokenType == UastBinaryOperator.GREATER) {
                        return level >= api - 1 && fromThen;
                    }
                    if (tokenType == UastBinaryOperator.LESS_OR_EQUALS) {
                        return level >= api - 1 && fromElse;
                    }
                    if (tokenType == UastBinaryOperator.LESS) {
                        return level >= api && fromElse;
                    }
                    if (tokenType == UastBinaryOperator.EQUALS || tokenType == UastBinaryOperator.IDENTITY_EQUALS) {
                        return level >= api && fromThen;
                    }
                    assert (false) : tokenType;
                }
            }
        } else if (tokenType == UastBinaryOperator.LOGICAL_AND && ifStatement != null && prev == ifStatement.getThenExpression() && ApiDetector.isAndedWithConditional((UElement)ifStatement.getCondition(), api, prev)) {
            return true;
        }
        return null;
    }

    private static Location getCatchParametersLocation(JavaContext context, UCatchClause catchClause) {
        List types = catchClause.getTypeReferences();
        if (types.isEmpty()) {
            return Location.NONE;
        }
        Location first = context.getUastLocation((UElement)types.get(0));
        if (types.size() < 2) {
            return first;
        }
        Location last = context.getUastLocation((UElement)types.get(types.size() - 1));
        File file = first.getFile();
        Position start = first.getStart();
        Position end = last.getEnd();
        if (start == null) {
            return Location.create(file);
        }
        return Location.create(file, start, end);
    }

    private static boolean isMultiCatchReflectiveOperationException(UCatchClause catchClause) {
        List types = catchClause.getTypes();
        if (types.size() < 2) {
            return false;
        }
        for (PsiType t : types) {
            if (ApiDetector.isSubclassOfReflectiveOperationException(t)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAndedWithConditional(UElement element, int api, UElement target) {
        if (element instanceof UBinaryExpression) {
            UBinaryExpression inner = (UBinaryExpression)element;
            if (inner.getOperator() == UastBinaryOperator.LOGICAL_AND) {
                return ApiDetector.isAndedWithConditional((UElement)inner.getLeftOperand(), api, target) || inner.getRightOperand() != target && ApiDetector.isAndedWithConditional((UElement)inner.getRightOperand(), api, target);
            }
            if (inner.getLeftOperand() instanceof UReferenceExpression && SDK_INT.equals(((UReferenceExpression)inner.getLeftOperand()).getResolvedName())) {
                UastBinaryOperator tokenType = inner.getOperator();
                UExpression right = inner.getRightOperand();
                int level = ApiDetector.getApiLevel((UElement)right);
                if (level != -1) {
                    if (tokenType == UastBinaryOperator.GREATER_OR_EQUALS) {
                        return level >= api;
                    }
                    if (tokenType == UastBinaryOperator.GREATER) {
                        return level >= api - 1;
                    }
                    if (tokenType == UastBinaryOperator.EQUALS || tokenType == UastBinaryOperator.IDENTITY_EQUALS) {
                        return level >= api;
                    }
                }
            }
        }
        return false;
    }

    private static boolean isOredWithConditional(UElement element, int api, UElement target) {
        if (element instanceof UBinaryExpression) {
            UBinaryExpression inner = (UBinaryExpression)element;
            if (inner.getOperator() == UastBinaryOperator.LOGICAL_OR) {
                return ApiDetector.isOredWithConditional((UElement)inner.getLeftOperand(), api, target) || inner.getRightOperand() != target && ApiDetector.isOredWithConditional((UElement)inner.getRightOperand(), api, target);
            }
            if (inner.getLeftOperand() instanceof UReferenceExpression && SDK_INT.equals(((UReferenceExpression)inner.getLeftOperand()).getResolvedName())) {
                UastBinaryOperator tokenType = inner.getOperator();
                UExpression right = inner.getRightOperand();
                int level = ApiDetector.getApiLevel((UElement)right);
                if (level != -1) {
                    if (tokenType == UastBinaryOperator.LESS_OR_EQUALS) {
                        return level >= api - 1;
                    }
                    if (tokenType == UastBinaryOperator.LESS) {
                        return level >= api;
                    }
                    if (tokenType == UastBinaryOperator.NOT_EQUALS) {
                        return level == api;
                    }
                }
            }
        }
        return false;
    }

    private static int getApiLevel(UElement apiLevelElement) {
        ULiteralExpression lit;
        Object value2;
        if (apiLevelElement instanceof UReferenceExpression) {
            UReferenceExpression ref2 = (UReferenceExpression)apiLevelElement;
            String codeName = ref2.getResolvedName();
            if (codeName == null) {
                return -1;
            }
            return SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)true);
        }
        if (apiLevelElement instanceof ULiteralExpression && (value2 = (lit = (ULiteralExpression)apiLevelElement).getValue()) instanceof Integer) {
            return (Integer)value2;
        }
        return -1;
    }

    private static boolean isSubclassOfReflectiveOperationException(PsiType type2) {
        for (PsiType t : type2.getSuperTypes()) {
            if (!REFLECTIVE_OPERATION_EXCEPTION.equals(t.getCanonicalText())) continue;
            return true;
        }
        return false;
    }

    private static class VersionCheckWithExitFinder
    extends AbstractUastVisitor {
        private final UExpression mExpression;
        private final UElement mEndElement;
        private final int mApi;
        private final JavaContext mContext;
        private boolean mFound = false;
        private boolean mDone = false;

        public VersionCheckWithExitFinder(UExpression expression2, UElement endElement, int api, JavaContext context) {
            this.mExpression = expression2;
            this.mEndElement = endElement;
            this.mApi = api;
            this.mContext = context;
        }

        public boolean visitElement(@NotNull UElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/ApiDetector$VersionCheckWithExitFinder", "visitElement"));
            }
            if (this.mDone) {
                return true;
            }
            if (node.equals(this.mEndElement)) {
                this.mDone = true;
            }
            return this.mDone || !this.mExpression.equals(node);
        }

        public boolean visitIfExpression(@NotNull UIfExpression ifStatement) {
            Boolean level;
            if (ifStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/android/tools/klint/checks/ApiDetector$VersionCheckWithExitFinder", "visitIfExpression"));
            }
            if (this.mDone) {
                return true;
            }
            UExpression thenBranch = ifStatement.getThenExpression();
            UExpression elseBranch = ifStatement.getElseExpression();
            if (thenBranch != null && (level = ApiDetector.isVersionCheckConditional(this.mApi, (UElement)thenBranch, ifStatement, this.mContext)) != null && ApiDetector.isUnconditionalReturn(thenBranch)) {
                this.mFound = true;
                this.mDone = true;
            }
            if (elseBranch != null && (level = ApiDetector.isVersionCheckConditional(this.mApi, (UElement)elseBranch, ifStatement, this.mContext)) != null && ApiDetector.isUnconditionalReturn(elseBranch)) {
                this.mFound = true;
                this.mDone = true;
            }
            return true;
        }

        public boolean found() {
            return this.mFound;
        }
    }

    private final class ApiVisitor
    extends AbstractUastVisitor {
        private final JavaContext mContext;

        private ApiVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitTypeReferenceExpression(@NotNull UTypeReferenceExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/ApiDetector$ApiVisitor", "visitTypeReferenceExpression"));
            }
            this.checkType(node.getType(), (UElement)node);
            return super.visitTypeReferenceExpression(node);
        }

        public boolean visitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/ApiDetector$ApiVisitor", "visitClassLiteralExpression"));
            }
            this.checkType(node.getType(), (UElement)node);
            return super.visitClassLiteralExpression(node);
        }

        public boolean visitImportStatement(@NotNull UImportStatement statement) {
            PsiElement resolved;
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/android/tools/klint/checks/ApiDetector$ApiVisitor", "visitImportStatement"));
            }
            if (!statement.isOnDemand() && (resolved = statement.resolve()) instanceof PsiField) {
                this.checkField((UElement)statement, (PsiField)resolved);
            }
            return super.visitImportStatement(statement);
        }

        public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/ApiDetector$ApiVisitor", "visitSimpleNameReferenceExpression"));
            }
            PsiElement resolved = node.resolve();
            if (resolved instanceof PsiField) {
                this.checkField((UElement)node, (PsiField)resolved);
            }
            return super.visitSimpleNameReferenceExpression(node);
        }

        public boolean visitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/ApiDetector$ApiVisitor", "visitBinaryExpressionWithType"));
            }
            this.visitTypeCastExpression(node);
            return super.visitBinaryExpressionWithType(node);
        }

        private void visitTypeCastExpression(UBinaryExpressionWithType expression2) {
            UExpression operand2 = expression2.getOperand();
            PsiType operandType = operand2.getExpressionType();
            PsiType castType = expression2.getType();
            if (castType.equals(operandType)) {
                return;
            }
            if (!(operandType instanceof PsiClassType)) {
                return;
            }
            if (!(castType instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)operandType;
            PsiClassType interfaceType = (PsiClassType)castType;
            this.checkCast((UElement)expression2, classType, interfaceType);
        }

        private void checkCast(UElement node, PsiClassType classType, PsiClassType interfaceType) {
            if (classType.equals((Object)interfaceType)) {
                return;
            }
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            String classTypeInternal = evaluator.getInternalName(classType);
            String interfaceTypeInternal = evaluator.getInternalName(interfaceType);
            if ("java/lang/Object".equals(interfaceTypeInternal)) {
                return;
            }
            int api = ApiDetector.this.mApiDatabase.getValidCastVersion(classTypeInternal, interfaceTypeInternal);
            if (api == -1) {
                return;
            }
            int minSdk = ApiDetector.this.getMinSdk(this.mContext);
            if (api <= minSdk) {
                return;
            }
            if (ApiDetector.isSuppressed(api, node, minSdk, this.mContext, UNSUPPORTED)) {
                return;
            }
            Location location = this.mContext.getUastLocation(node);
            String message = String.format("Cast from %1$s to %2$s requires API level %3$d (current min is %4$d)", UastLintUtils.getClassName(classType), UastLintUtils.getClassName(interfaceType), api, minSdk);
            this.mContext.report(UNSUPPORTED, location, message);
        }

        public boolean visitMethod(@NotNull UMethod method) {
            int minSdk;
            int api;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/android/tools/klint/checks/ApiDetector$ApiVisitor", "visitMethod"));
            }
            if (method.getModifierList().hasExplicitModifier("default") && !ApiDetector.isSuppressed(api = 24, (UElement)method, minSdk = ApiDetector.this.getMinSdk(this.mContext), this.mContext, UNSUPPORTED)) {
                Location location = this.mContext.getLocation((PsiElement)method);
                String message = String.format("Default method requires API level %1$d (current min is %2$d)", api, minSdk);
                this.mContext.reportUast(UNSUPPORTED, (UElement)method, location, message);
            }
            return super.visitMethod(method);
        }

        public boolean visitClass(@NotNull UClass aClass) {
            block8: {
                block7: {
                    if (aClass == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/android/tools/klint/checks/ApiDetector$ApiVisitor", "visitClass"));
                    }
                    if (!aClass.isAnnotationType()) break block7;
                    PsiModifierList modifierList = aClass.getModifierList();
                    if (modifierList == null) break block8;
                    for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                        PsiNameValuePair[] attributes;
                        String name = annotation.getQualifiedName();
                        if ("java.lang.annotation.Repeatable".equals(name)) {
                            int api = 24;
                            int minSdk = ApiDetector.this.getMinSdk(this.mContext);
                            if (ApiDetector.isSuppressed(api, (UElement)aClass, minSdk, this.mContext, UNSUPPORTED)) continue;
                            Location location = this.mContext.getLocation((PsiElement)annotation);
                            String message = String.format("Repeatable annotation requires API level %1$d (current min is %2$d)", api, minSdk);
                            this.mContext.report(UNSUPPORTED, (PsiElement)annotation, location, message);
                            continue;
                        }
                        if (!"java.lang.annotation.Target".equals(name)) continue;
                        for (PsiNameValuePair pair : attributes = annotation.getParameterList().getAttributes()) {
                            PsiAnnotationMemberValue value2 = pair.getValue();
                            if (value2 instanceof PsiArrayInitializerMemberValue) {
                                PsiArrayInitializerMemberValue array = (PsiArrayInitializerMemberValue)value2;
                                for (PsiAnnotationMemberValue t : array.getInitializers()) {
                                    this.checkAnnotationTarget(t, modifierList);
                                }
                                continue;
                            }
                            if (value2 == null) continue;
                            this.checkAnnotationTarget(value2, modifierList);
                        }
                    }
                    break block8;
                }
                for (UTypeReferenceExpression t : aClass.getUastSuperTypes()) {
                    this.checkType(t.getType(), (UElement)t);
                }
            }
            return super.visitClass(aClass);
        }

        private void checkAnnotationTarget(PsiAnnotationMemberValue element, PsiModifierList modifierList) {
            PsiAnnotation retention;
            UReferenceExpression ref;
            String referenceName;
            if (element instanceof UReferenceExpression && ("TYPE_PARAMETER".equals(referenceName = UastLintUtils.getReferenceName(ref = (UReferenceExpression)element)) || "TYPE_USE".equals(referenceName)) && ((retention = modifierList.findAnnotation("java.lang.annotation.Retention")) == null || retention.getText().contains("RUNTIME"))) {
                Location location = this.mContext.getLocation((PsiElement)element);
                String message = String.format("Type annotations are not supported in Android: %1$s", referenceName);
                this.mContext.report(UNSUPPORTED, (PsiElement)element, location, message);
            }
        }

        public boolean visitCallExpression(@NotNull UCallExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/android/tools/klint/checks/ApiDetector$ApiVisitor", "visitCallExpression"));
            }
            this.checkMethodCallExpression(expression2);
            return super.visitCallExpression(expression2);
        }

        private void checkMethodCallExpression(@NotNull UCallExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/android/tools/klint/checks/ApiDetector$ApiVisitor", "checkMethodCallExpression"));
            }
            PsiMethod method = expression2.resolve();
            if (method != null) {
                PsiMethod containingMethod;
                int minSdk;
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() > 0) {
                    PsiParameter[] parameters2 = parameterList.getParameters();
                    List arguments = expression2.getValueArguments();
                    for (int i = 0; i < parameters2.length; ++i) {
                        PsiType parameterType = parameters2[i].getType();
                        if (!(parameterType instanceof PsiClassType)) continue;
                        if (i >= arguments.size()) break;
                        UExpression argument = (UExpression)arguments.get(i);
                        PsiType argumentType = argument.getExpressionType();
                        if (argumentType == null || parameterType.equals(argumentType) || !(argumentType instanceof PsiClassType)) continue;
                        this.checkCast((UElement)argument, (PsiClassType)argumentType, (PsiClassType)parameterType);
                    }
                }
                JavaEvaluator evaluator = this.mContext.getEvaluator();
                String fqcn = containingClass.getQualifiedName();
                String owner = evaluator.getInternalName(containingClass);
                if (owner == null) {
                    return;
                }
                String name = IntellijLintUtils.getInternalMethodName(method);
                String desc = IntellijLintUtils.getInternalDescription(method, false, false);
                if (desc == null) {
                    return;
                }
                boolean hasApiAnnotation = false;
                int api = ApiDetector.this.mApiDatabase.getCallVersion(owner, name, desc);
                if (api == -1) {
                    api = ApiDetector.getTargetApi(method.getModifierList());
                    if (api == -1 && method.isConstructor()) {
                        api = ApiDetector.getTargetApi(method.getContainingClass().getModifierList());
                    }
                    if (api == -1) {
                        return;
                    }
                    hasApiAnnotation = true;
                }
                if (api <= (minSdk = ApiDetector.this.getMinSdk(this.mContext))) {
                    return;
                }
                if (!hasApiAnnotation && UastExpressionUtils.isMethodCall((UElement)expression2)) {
                    UExpression qualifier = expression2.getReceiver();
                    if (qualifier != null && !(qualifier instanceof UThisExpression) && !(qualifier instanceof USuperExpression)) {
                        String expressionOwner;
                        PsiType type2 = qualifier.getExpressionType();
                        if (type2 != null && type2 instanceof PsiClassType && (expressionOwner = evaluator.getInternalName((PsiClassType)type2)) != null && !expressionOwner.equals(owner)) {
                            int specificApi = ApiDetector.this.mApiDatabase.getCallVersion(expressionOwner, name, desc);
                            if (specificApi == -1) {
                                if (ApiLookup.isRelevantOwner(expressionOwner)) {
                                    return;
                                }
                            } else {
                                if (specificApi <= minSdk) {
                                    return;
                                }
                                if (specificApi < api) {
                                    api = specificApi;
                                    fqcn = expressionOwner.replace('/', '.');
                                }
                                api = Math.min(specificApi, api);
                            }
                        }
                    } else {
                        PsiClass cls = null;
                        PsiType receiverType2 = expression2.getReceiverType();
                        if (receiverType2 instanceof PsiClassType) {
                            cls = ((PsiClassType)receiverType2).resolve();
                        }
                        while (cls != null) {
                            String expressionOwner;
                            if (cls instanceof PsiAnonymousClass) {
                                boolean found = false;
                                PsiClassType anonymousBaseType = ((PsiAnonymousClass)cls).getBaseClassType();
                                PsiClass anonymousBase = anonymousBaseType.resolve();
                                if (anonymousBase != null && anonymousBase.isInheritor(containingClass, true)) {
                                    cls = anonymousBase;
                                    found = true;
                                } else {
                                    PsiClass surroundingBaseType = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)cls, PsiClass.class, (boolean)true);
                                    if (surroundingBaseType != null && surroundingBaseType.isInheritor(containingClass, true)) {
                                        cls = surroundingBaseType;
                                        found = true;
                                    }
                                }
                                if (!found) break;
                            }
                            if ((expressionOwner = evaluator.getInternalName(cls)) == null) break;
                            int specificApi = ApiDetector.this.mApiDatabase.getCallVersion(expressionOwner, name, desc);
                            if (specificApi != -1) {
                                if (specificApi <= minSdk) {
                                    return;
                                }
                                if (specificApi < api) {
                                    api = specificApi;
                                    fqcn = expressionOwner.replace('/', '.');
                                }
                                api = Math.min(specificApi, api);
                                break;
                            }
                            if (ApiLookup.isRelevantOwner(expressionOwner)) {
                                return;
                            }
                            cls = cls.getSuperClass();
                        }
                    }
                }
                if (ApiDetector.isSuppressed(api, (UElement)expression2, minSdk, this.mContext, UNSUPPORTED)) {
                    return;
                }
                if (UastExpressionUtils.isMethodCall((UElement)expression2) && expression2.getReceiver() instanceof USuperExpression && (containingMethod = UastUtils.getContainingMethod((UElement)expression2)) != null && name.equals(containingMethod.getName()) && MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)containingMethod) && !method.isConstructor()) {
                    return;
                }
                UIdentifier locationNode = expression2.getMethodIdentifier();
                if (locationNode == null) {
                    locationNode = expression2;
                }
                Location location = this.mContext.getUastLocation((UElement)locationNode);
                String message = String.format("Call requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn + '#' + method.getName());
                this.mContext.report(UNSUPPORTED, location, message);
            }
        }

        public boolean visitLocalVariable(ULocalVariable variable2) {
            UExpression initializer = variable2.getUastInitializer();
            if (initializer == null) {
                return true;
            }
            PsiType initializerType = initializer.getExpressionType();
            if (!(initializerType instanceof PsiClassType)) {
                return true;
            }
            PsiType interfaceType = variable2.getType();
            if (initializerType.equals(interfaceType)) {
                return true;
            }
            if (!(interfaceType instanceof PsiClassType)) {
                return true;
            }
            this.checkCast((UElement)initializer, (PsiClassType)initializerType, (PsiClassType)interfaceType);
            return true;
        }

        public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/ApiDetector$ApiVisitor", "visitBinaryExpression"));
            }
            if (UastExpressionUtils.isAssignment((UElement)node)) {
                this.visitAssignmentExpression(node);
            }
            return super.visitBinaryExpression(node);
        }

        private void visitAssignmentExpression(UBinaryExpression expression2) {
            UExpression rExpression = expression2.getRightOperand();
            PsiType rhsType = rExpression.getExpressionType();
            if (!(rhsType instanceof PsiClassType)) {
                return;
            }
            PsiType interfaceType = expression2.getLeftOperand().getExpressionType();
            if (rhsType.equals(interfaceType)) {
                return;
            }
            if (!(interfaceType instanceof PsiClassType)) {
                return;
            }
            this.checkCast((UElement)rExpression, (PsiClassType)rhsType, (PsiClassType)interfaceType);
        }

        public boolean visitTryExpression(@NotNull UTryExpression statement) {
            String message;
            int minSdk;
            int api;
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/android/tools/klint/checks/ApiDetector$ApiVisitor", "visitTryExpression"));
            }
            if (statement.getHasResources() && (api = 19) > (minSdk = ApiDetector.this.getMinSdk(this.mContext)) && api > ApiDetector.getTargetApi((UElement)statement)) {
                Location location = this.mContext.getUastLocation((UElement)statement);
                message = String.format("Try-with-resources requires API level %1$d (current min is %2$d)", api, minSdk);
                LintDriver driver = this.mContext.getDriver();
                if (!driver.isSuppressed(this.mContext, UNSUPPORTED, (UElement)statement)) {
                    this.mContext.report(UNSUPPORTED, (UElement)statement, location, message);
                }
            }
            for (UCatchClause catchClause : statement.getCatchClauses()) {
                int minSdk2 = ApiDetector.this.getMinSdk(this.mContext);
                if (minSdk2 < 19 && ApiDetector.isMultiCatchReflectiveOperationException(catchClause)) {
                    message = String.format("Multi-catch with these reflection exceptions requires API level 19 (current min is %d) because they get compiled to the common but new super type `ReflectiveOperationException`. As a workaround either create individual catch statements, or catch `Exception`.", minSdk2);
                    this.mContext.report(UNSUPPORTED, ApiDetector.getCatchParametersLocation(this.mContext, catchClause), message);
                    continue;
                }
                for (UTypeReferenceExpression typeReference2 : catchClause.getTypeReferences()) {
                    this.checkCatchTypeElement(statement, typeReference2, typeReference2.getType());
                }
            }
            return super.visitTryExpression(statement);
        }

        private void checkCatchTypeElement(UTryExpression statement, UTypeReferenceExpression typeReference2, PsiType type2) {
            PsiClass resolved = null;
            if (type2 instanceof PsiClassType) {
                resolved = ((PsiClassType)type2).resolve();
            }
            if (resolved != null) {
                String signature = this.mContext.getEvaluator().getInternalName(resolved);
                int api = ApiDetector.this.mApiDatabase.getClassVersion(signature);
                if (api == -1) {
                    return;
                }
                int minSdk = ApiDetector.this.getMinSdk(this.mContext);
                if (api <= minSdk) {
                    return;
                }
                int target = ApiDetector.getTargetApi((UElement)statement);
                if (target != -1 && api <= target) {
                    return;
                }
                Location location = this.mContext.getUastLocation((UElement)typeReference2);
                String fqcn = resolved.getQualifiedName();
                String message = String.format("Class requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn);
                this.mContext.report(UNSUPPORTED, location, message);
            }
        }

        private void checkType(PsiType type2, UElement element) {
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiClass resolved = ((PsiClassType)type2).resolve();
            if (resolved == null) {
                return;
            }
            String signature = this.mContext.getEvaluator().getInternalName(resolved);
            int api = ApiDetector.this.mApiDatabase.getClassVersion(signature);
            if (api == -1) {
                return;
            }
            int minSdk = ApiDetector.this.getMinSdk(this.mContext);
            if (api <= minSdk) {
                return;
            }
            if (ApiDetector.isSuppressed(api, element, minSdk, this.mContext, UNSUPPORTED)) {
                return;
            }
            Location location = this.mContext.getUastLocation(element);
            String fqcn = resolved.getQualifiedName();
            String message = String.format("Class requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn);
            this.mContext.report(UNSUPPORTED, location, message);
        }

        private boolean checkField(UElement node, PsiField field) {
            PsiType type2 = field.getType();
            Issue issue = type2 instanceof PsiPrimitiveType || LintUtils.isString(type2) ? INLINED : UNSUPPORTED;
            String name = field.getName();
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null || name == null) {
                return false;
            }
            String owner = this.mContext.getEvaluator().getInternalName(containingClass);
            int api = ApiDetector.this.mApiDatabase.getFieldVersion(owner, name);
            if (api != -1) {
                int minSdk = ApiDetector.this.getMinSdk(this.mContext);
                if (api > minSdk && api > ApiDetector.getTargetApi(node)) {
                    LintDriver driver;
                    UElement reference;
                    if (ApiDetector.isBenignConstantUsage(node, name, owner)) {
                        return true;
                    }
                    String fqcn = ClassContext.getFqcn(owner) + '#' + name;
                    if (node instanceof UImportStatement && (reference = ((UImportStatement)node).getImportReference()) != null) {
                        node = reference;
                    }
                    if ((driver = this.mContext.getDriver()).isSuppressed(this.mContext, INLINED, node)) {
                        return true;
                    }
                    if (driver.isSuppressed(this.mContext, UNSUPPORTED, node)) {
                        return true;
                    }
                    if (ApiDetector.isWithinVersionCheckConditional(node, api, this.mContext)) {
                        return true;
                    }
                    if (ApiDetector.isPrecededByVersionCheckExit(node, api, this.mContext)) {
                        return true;
                    }
                    String message = String.format("Field requires API level %1$d (current min is %2$d): `%3$s`", api, minSdk, fqcn);
                    Location location = this.mContext.getUastLocation(node);
                    this.mContext.report(issue, node, location, message);
                }
                return true;
            }
            return false;
        }
    }
}

